/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gadgets;

import forestry.api.core.ForestryAPI;
import forestry.api.recipes.IFabricatorManager;
import forestry.core.fluids.Fluids;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.FilteredTank;
import forestry.core.fluids.tanks.StandardTank;
import forestry.core.gadgets.TileBase;
import forestry.core.gadgets.TilePowered;
import forestry.core.interfaces.ICrafter;
import forestry.core.interfaces.ICraftingPlan;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.InvTools;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.network.GuiId;
import forestry.core.utils.GuiUtil;
import forestry.core.utils.ShapedRecipeCustom;
import forestry.core.utils.StackUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class MachineFabricator
extends TilePowered
implements ICrafter,
ILiquidTankContainer,
ISidedInventory {
    private static final int MAX_HEAT = 5000;
    public static final short SLOT_METAL = 0;
    public static final short SLOT_PLAN = 1;
    public static final short SLOT_RESULT = 2;
    public static final short SLOT_CRAFTING_LEGACY_1 = 3;
    public static final short SLOT_CRAFTING_LEGACY_COUNT = 9;
    public static final short SLOT_INVENTORY_1 = 12;
    public static final short SLOT_INVENTORY_COUNT = 18;
    public static final short SLOT_COUNT = 30;
    public static final short SLOT_CRAFTING_1 = 0;
    public static final short SLOT_CRAFTING_COUNT = 9;
    private final TileInventoryAdapter craftingInventory = new TileInventoryAdapter<MachineFabricator>(this, 9, "CraftItems");
    private final TankManager tankManager;
    private final FilteredTank moltenTank;
    private int heat = 0;
    private int guiMeltingPoint = 0;

    public MachineFabricator() {
        super(1100, 50, 3300);
        this.setInternalInventory(new FabricatorInventoryAdapter(this));
        this.moltenTank = new FilteredTank(2000, Fluids.GLASS.getFluid());
        this.moltenTank.tankMode = StandardTank.TankMode.INTERNAL;
        this.tankManager = new TankManager(this.moltenTank);
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.FabricatorGUI.ordinal(), player.field_70170_p, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("Heat", this.heat);
        this.tankManager.writeTanksToNBT(nbttagcompound);
        this.craftingInventory.writeToNBT(nbttagcompound);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.heat = nbttagcompound.func_74762_e("Heat");
        this.tankManager.readTanksFromNBT(nbttagcompound);
        this.craftingInventory.readFromNBT(nbttagcompound);
        IInventoryAdapter inventory = this.getInternalInventory();
        for (int slot = 3; slot < 12; ++slot) {
            ItemStack stack = inventory.func_70301_a(slot);
            if (stack == null) continue;
            inventory.func_70299_a(slot, null);
            int newSlot = slot - 3;
            this.craftingInventory.func_70299_a(newSlot, stack);
        }
    }

    @Override
    public void updateServerSide() {
        Smelting smelt;
        super.updateServerSide();
        if (!this.moltenTank.isFull()) {
            this.trySmelting();
        }
        if (!this.moltenTank.isEmpty() && (smelt = RecipeManager.findMatchingSmelting(this.moltenTank.getFluid())) != null && this.heat < smelt.meltingPoint) {
            this.moltenTank.drain(5, true);
        }
        this.dissipateHeat();
    }

    private void trySmelting() {
        IInventoryAdapter inventory = this.getInternalInventory();
        ItemStack smeltResource = inventory.func_70301_a(0);
        if (smeltResource == null) {
            return;
        }
        Smelting smelt = RecipeManager.findMatchingSmelting(smeltResource);
        if (smelt == null || smelt.meltingPoint > this.heat) {
            return;
        }
        FluidStack smeltFluid = smelt.getProduct();
        if (this.moltenTank.fill(smeltFluid, false) == smeltFluid.amount) {
            this.func_70298_a(0, 1);
            this.moltenTank.fill(smeltFluid, true);
        }
    }

    @Override
    public boolean workCycle() {
        this.craftResult(null);
        return this.addHeat(25);
    }

    private boolean addHeat(int addition) {
        if (this.heat >= 5000) {
            return false;
        }
        this.heat += addition;
        if (this.heat > 5000) {
            this.heat = 5000;
        }
        return true;
    }

    private void dissipateHeat() {
        if (this.heat > 2500) {
            this.heat -= 2;
        } else if (this.heat > 0) {
            --this.heat;
        }
    }

    private Recipe getRecipe() {
        IInventoryAdapter inventory = this.getInternalInventory();
        ItemStack plan = inventory.func_70301_a(1);
        ItemStack[] crafting = InvTools.getStacks((IInventory)this.craftingInventory, 0, 9);
        return RecipeManager.findMatchingRecipe(plan, this.moltenTank.getFluid(), crafting);
    }

    @Override
    public boolean canTakeStack(int slotIndex) {
        return true;
    }

    @Override
    public ItemStack getResult() {
        Recipe myRecipe = this.getRecipe();
        if (myRecipe == null) {
            return null;
        }
        return myRecipe.internal.func_77571_b().func_77946_l();
    }

    @Override
    public ItemStack takenFromSlot(int slotIndex, EntityPlayer player) {
        if (slotIndex != 2) {
            return null;
        }
        return this.getInternalInventory().func_70298_a(2, 1);
    }

    private void craftResult(EntityPlayer player) {
        Item planItem;
        Recipe myRecipe = this.getRecipe();
        if (myRecipe == null) {
            return;
        }
        ItemStack result = this.getResult();
        if (result == null) {
            return;
        }
        IInventoryAdapter inventory = this.getInternalInventory();
        if (inventory.func_70301_a(2) != null) {
            return;
        }
        FluidStack liquid = myRecipe.molten;
        ItemStack[] crafting = InvTools.getStacks((IInventory)this.craftingInventory, 0, 9);
        if (!this.removeFromInventory(crafting, player, false)) {
            return;
        }
        FluidStack canDrain = this.moltenTank.drain(liquid.amount, false);
        if (canDrain == null || !canDrain.isFluidStackIdentical(liquid)) {
            return;
        }
        this.removeFromInventory(crafting, player, true);
        this.moltenTank.drain(liquid.amount, true);
        if (inventory.func_70301_a(1) != null && (planItem = inventory.func_70301_a(1).func_77973_b()) instanceof ICraftingPlan) {
            inventory.func_70299_a(1, ((ICraftingPlan)planItem).planUsed(inventory.func_70301_a(1), result));
        }
        inventory.func_70299_a(2, result);
    }

    private boolean removeFromInventory(ItemStack[] set, EntityPlayer player, boolean doRemove) {
        IInventoryAdapter inventory = this.getInternalInventory();
        if (doRemove) {
            return InvTools.removeSets((IInventory)inventory, 1, set, 12, 18, player, true, true);
        }
        ItemStack[] stock = InvTools.getStacks((IInventory)inventory, 12, 18);
        return StackUtils.containsSets(set, stock) >= 1;
    }

    @Override
    public boolean isWorking() {
        return this.heat <= 5000;
    }

    @Override
    public boolean hasWork() {
        IInventoryAdapter inventory = this.getInternalInventory();
        ItemStack itemToMelt = inventory.func_70301_a(0);
        Smelting smelting = RecipeManager.findMatchingSmelting(itemToMelt);
        if (smelting != null && this.moltenTank.fill(smelting.getProduct(), false) > 0) {
            return true;
        }
        ItemStack plan = inventory.func_70301_a(1);
        ItemStack[] resources = InvTools.getStacks((IInventory)this.craftingInventory, 0, 9);
        return RecipeManager.findMatchingRecipe(plan, this.moltenTank.getFluid(), resources) != null;
    }

    public int getHeatScaled(int i) {
        return this.heat * i / 5000;
    }

    public int getMeltingPoint() {
        Smelting smelt;
        if (this.moltenTank.getFluidAmount() > 0) {
            Smelting smelt2 = RecipeManager.findMatchingSmelting(this.moltenTank.getFluid());
            if (smelt2 != null) {
                return smelt2.meltingPoint;
            }
        } else if (this.func_70301_a(0) != null && (smelt = RecipeManager.findMatchingSmelting(this.func_70301_a(0))) != null) {
            return smelt.meltingPoint;
        }
        return 0;
    }

    public int getMeltingPointScaled(int i) {
        if (this.guiMeltingPoint > 0) {
            return this.guiMeltingPoint * i / 5000;
        }
        int meltingPoint = this.getMeltingPoint();
        if (meltingPoint <= 0) {
            return 0;
        }
        return meltingPoint * i / 5000;
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        int messageId = this.tankManager.maxMessageId() + 1;
        if (i == messageId) {
            this.heat = j;
        } else if (i == messageId + 1) {
            this.guiMeltingPoint = j;
        }
    }

    @Override
    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        int messageId = this.tankManager.maxMessageId() + 1;
        iCrafting.func_71112_a(container, messageId, this.heat);
        iCrafting.func_71112_a(container, messageId + 1, this.getMeltingPoint());
    }

    public InventoryAdapter getCraftingInventory() {
        return this.craftingInventory;
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tankManager.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tankManager.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tankManager.drain(from, maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.tankManager.getTankInfo(from);
    }

    private static class FabricatorInventoryAdapter
    extends TileInventoryAdapter<MachineFabricator> {
        public FabricatorInventoryAdapter(MachineFabricator fabricator) {
            super(fabricator, 30, "Items");
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            if (slotIndex == 0) {
                return RecipeManager.findMatchingSmelting(itemStack) != null;
            }
            if (slotIndex == 1) {
                return RecipeManager.isPlan(itemStack);
            }
            return GuiUtil.isIndexInRange(slotIndex, 12, 18);
        }

        @Override
        public boolean func_102008_b(int slotIndex, ItemStack stack, int side) {
            return slotIndex == 2;
        }
    }

    public static class RecipeManager
    implements IFabricatorManager {
        public static final ArrayList<Recipe> recipes = new ArrayList();
        public static final ArrayList<Smelting> smeltings = new ArrayList();

        @Override
        public void addRecipe(ItemStack plan, FluidStack molten, ItemStack result, Object[] pattern) {
            recipes.add(new Recipe(plan, molten, ShapedRecipeCustom.createShapedRecipe(result, pattern)));
        }

        @Override
        public void addSmelting(ItemStack resource, FluidStack molten, int meltingPoint) {
            smeltings.add(new Smelting(resource, molten, meltingPoint));
        }

        public static Recipe findMatchingRecipe(ItemStack plan, FluidStack liquid, ItemStack[] resources) {
            ItemStack[][] gridResources = new ItemStack[3][3];
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    gridResources[j][i] = resources[i * 3 + j];
                }
            }
            for (Recipe recipe : recipes) {
                if (!recipe.matches(plan, gridResources) || !recipe.hasLiquid(liquid)) continue;
                return recipe;
            }
            return null;
        }

        public static boolean isPlan(ItemStack plan) {
            for (Recipe recipe : recipes) {
                if (!StackUtils.isIdenticalItem(recipe.getPlan(), plan)) continue;
                return true;
            }
            return false;
        }

        public static Smelting findMatchingSmelting(ItemStack resource) {
            if (resource == null) {
                return null;
            }
            for (Smelting smelting : smeltings) {
                if (!StackUtils.isCraftingEquivalent(smelting.resource, resource)) continue;
                return smelting;
            }
            return null;
        }

        public static Smelting findMatchingSmelting(FluidStack product) {
            if (product == null) {
                return null;
            }
            for (Smelting smelting : smeltings) {
                if (!smelting.matches(product)) continue;
                return smelting;
            }
            return null;
        }

        @Override
        public Map<Object[], Object[]> getRecipes() {
            HashMap<Object[], Object[]> recipeList = new HashMap<Object[], Object[]>();
            for (Recipe recipe : recipes) {
                recipeList.put(recipe.internal.getIngredients(), new Object[]{recipe.internal.func_77571_b()});
            }
            return recipeList;
        }
    }

    public static class Smelting {
        private final ItemStack resource;
        private final FluidStack product;
        private final int meltingPoint;

        public Smelting(ItemStack resource, FluidStack molten, int meltingPoint) {
            if (resource == null) {
                throw new IllegalArgumentException("Resource cannot be null");
            }
            if (molten == null) {
                throw new IllegalArgumentException("Molten cannot be null");
            }
            this.resource = resource;
            this.product = molten;
            this.meltingPoint = meltingPoint;
        }

        public boolean matches(FluidStack product) {
            return this.product.isFluidEqual(product);
        }

        public ItemStack getResource() {
            return this.resource;
        }

        public FluidStack getProduct() {
            return this.product;
        }

        public int getMeltingPoint() {
            return this.meltingPoint;
        }
    }

    public static class Recipe {
        private final ItemStack plan;
        private final FluidStack molten;
        private final ShapedRecipeCustom internal;

        public Recipe(ItemStack plan, FluidStack molten, ShapedRecipeCustom internal) {
            this.plan = plan;
            this.molten = molten;
            this.internal = internal;
        }

        public boolean matches(ItemStack plan, ItemStack[][] resources) {
            if (this.plan != null && !StackUtils.isCraftingEquivalent(this.plan, plan)) {
                return false;
            }
            return this.internal.matches(resources);
        }

        public boolean hasLiquid(FluidStack resource) {
            if (resource == null) {
                return this.molten == null;
            }
            return resource.containsFluid(this.molten);
        }

        public ItemStack getPlan() {
            return this.plan;
        }

        public FluidStack getLiquid() {
            return this.molten;
        }

        public IRecipe asIRecipe() {
            return this.internal;
        }
    }
}

