/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gadgets;

import cpw.mods.fml.common.eventhandler.Event;
import forestry.api.core.ForestryAPI;
import forestry.core.gadgets.TileBase;
import forestry.core.interfaces.ICrafterWorktable;
import forestry.core.inventory.InvTools;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.inventory.wrappers.InventoryMapper;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.core.utils.GuiUtil;
import forestry.core.utils.RecipeUtil;
import forestry.factory.recipes.RecipeMemory;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;

public class TileWorktable
extends TileBase
implements ICrafterWorktable {
    public static final int SLOT_CRAFTING_1 = 0;
    public static final int SLOT_CRAFTING_COUNT = 9;
    public static final int SLOT_CRAFTING_RESULT = 9;
    public static final short SLOT_INVENTORY_1 = 0;
    public static final short SLOT_INVENTORY_COUNT = 18;
    private RecipeMemory.Recipe currentRecipe;
    private InventoryCrafting currentCrafting;
    private final RecipeMemory memorized;
    private final TileInventoryAdapter craftingInventory = new TileInventoryAdapter<TileWorktable>(this, 10, "CraftItems");

    public TileWorktable() {
        this.setInternalInventory(new WorktableInventoryAdapter(this));
        this.memorized = new RecipeMemory();
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.WorktableGUI.ordinal(), player.field_70170_p, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        this.craftingInventory.writeToNBT(nbttagcompound);
        this.memorized.writeToNBT(nbttagcompound);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.craftingInventory.readFromNBT(nbttagcompound);
        this.memorized.readFromNBT(nbttagcompound);
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.craftingInventory.writeData(data);
        this.memorized.writeData(data);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.craftingInventory.readData(data);
        this.memorized.readData(data);
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        this.memorized.validate(this.field_145850_b);
    }

    public RecipeMemory getMemory() {
        return this.memorized;
    }

    public void chooseRecipe(int recipeIndex) {
        if (recipeIndex >= 9) {
            for (int slot = 0; slot < this.craftingInventory.func_70302_i_(); ++slot) {
                this.craftingInventory.func_70299_a(slot, null);
            }
            return;
        }
        IInventory matrix = this.memorized.getRecipeMatrix(recipeIndex);
        if (matrix == null) {
            return;
        }
        for (int slot = 0; slot < matrix.func_70302_i_(); ++slot) {
            this.craftingInventory.func_70299_a(slot, matrix.func_70301_a(slot));
        }
    }

    public void setRecipe(InventoryCrafting crafting) {
        ItemStack recipeOutput = CraftingManager.func_77594_a().func_82787_a(crafting, this.field_145850_b);
        if (recipeOutput == null) {
            this.currentRecipe = null;
            this.currentCrafting = null;
        } else {
            this.currentRecipe = new RecipeMemory.Recipe(crafting);
            this.currentCrafting = crafting;
        }
        this.updateCraftResult();
    }

    private void updateCraftResult() {
        ItemStack result;
        if (this.currentRecipe != null && (result = this.currentRecipe.getRecipeOutput(this.field_145850_b)) != null) {
            this.craftingInventory.func_70299_a(9, result.func_77946_l());
            return;
        }
        this.craftingInventory.func_70299_a(9, null);
    }

    private boolean canCraftCurrentRecipe() {
        if (this.currentRecipe == null) {
            return false;
        }
        ItemStack[] recipeItems = InvTools.getStacks((IInventory)this.craftingInventory, 0, 9);
        ItemStack[] inventory = InvTools.getStacks((IInventory)this.getInternalInventory(), 0, 18);
        ItemStack recipeOutput = this.currentRecipe.getRecipeOutput(this.field_145850_b);
        return RecipeUtil.canCraftRecipe(this.field_145850_b, recipeItems, recipeOutput, inventory);
    }

    @Override
    public boolean canTakeStack(int slotIndex) {
        if (slotIndex == 9) {
            return this.canCraftCurrentRecipe();
        }
        return true;
    }

    @Override
    public boolean onCraftingStart(EntityPlayer player) {
        ItemStack[] set = InvTools.getStacks((IInventory)this.currentRecipe.getMatrix(), 0, 9);
        ItemStack[] removed = InvTools.removeSets((IInventory)this, 1, set, 0, 18, player, false, true, true);
        if (removed == null) {
            return false;
        }
        for (int i = 0; i < removed.length; ++i) {
            this.craftingInventory.func_70299_a(i, removed[i]);
        }
        return true;
    }

    @Override
    public void onCraftingComplete(EntityPlayer player) {
        IInventory craftingInventory = this.getCraftingInventory();
        for (int i = 0; i < craftingInventory.func_70302_i_(); ++i) {
            ItemStack itemStack = craftingInventory.func_70301_a(i);
            if (itemStack == null || !itemStack.func_77973_b().hasContainerItem(itemStack)) continue;
            ItemStack container = itemStack.func_77973_b().getContainerItem(itemStack);
            if (container != null && container.func_77984_f() && container.func_77960_j() > container.func_77958_k()) {
                MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(player, container));
                continue;
            }
            if (InvTools.tryAddStack((IInventory)this, container, true)) continue;
            player.func_71019_a(container, false);
        }
        if (Proxies.common.isSimulating(this.field_145850_b)) {
            this.memorized.memorizeRecipe(this.field_145850_b, this.currentRecipe, this.currentCrafting);
        }
        this.updateCraftResult();
    }

    @Override
    public ItemStack getResult() {
        if (this.currentRecipe == null) {
            return null;
        }
        if (this.currentRecipe.getRecipeOutput(this.field_145850_b) != null) {
            return this.currentRecipe.getRecipeOutput(this.field_145850_b).func_77946_l();
        }
        return null;
    }

    public IInventory getCraftingInventory() {
        return new InventoryMapper((IInventory)this.craftingInventory, 0, 9);
    }

    private static class WorktableInventoryAdapter
    extends TileInventoryAdapter<TileWorktable> {
        public WorktableInventoryAdapter(TileWorktable worktable) {
            super(worktable, 18, "Items");
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            return GuiUtil.isIndexInRange(slotIndex, 0, 18);
        }
    }
}

