/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.core.utils.BlockUtil;
import forestry.core.vect.Vect;
import forestry.farming.logic.CropBlock;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class FarmableCocoa
implements IFarmable {
    public static final Block COCOA_PLANT = Blocks.field_150375_by;
    public static final Item COCOA_SEED = Items.field_151100_aR;
    public static final int COCOA_META = 3;

    @Override
    public boolean isSaplingAt(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z) == COCOA_PLANT;
    }

    @Override
    public ICrop getCropAt(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block != COCOA_PLANT) {
            return null;
        }
        int meta = world.func_72805_g(x, y, z);
        if (BlockUtil.getMaturityPod(meta) < 2) {
            return null;
        }
        return new CropBlock(world, block, meta, new Vect(x, y, z));
    }

    @Override
    public boolean isGermling(ItemStack itemstack) {
        return itemstack.func_77973_b() == COCOA_SEED && itemstack.func_77960_j() == 3;
    }

    @Override
    public boolean isWindfall(ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean plantSaplingAt(EntityPlayer player, ItemStack germling, World world, int x, int y, int z) {
        return BlockUtil.tryPlantPot(world, x, y, z, COCOA_PLANT);
    }
}

