/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.triggers;

import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import forestry.api.core.ITileStructure;
import forestry.core.triggers.Trigger;
import forestry.farming.gadgets.TileFarmPlain;
import forestry.farming.gadgets.TileHatch;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TriggerLowSoil
extends Trigger {
    private final int threshold;

    public TriggerLowSoil(int threshold) {
        super("lowSoil." + threshold, "lowSoil");
        this.threshold = threshold;
    }

    @Override
    public String getDescription() {
        return super.getDescription() + " < " + this.threshold;
    }

    @Override
    public int maxParameters() {
        return 1;
    }

    @Override
    public int minParameters() {
        return 0;
    }

    public boolean isTriggerActive(TileEntity tile, ForgeDirection side, IStatementContainer source, IStatementParameter[] parameters) {
        IStatementParameter parameter = null;
        if (parameters.length > 0) {
            parameter = parameters[0];
        }
        if (!(tile instanceof TileHatch)) {
            return false;
        }
        ITileStructure central = ((TileHatch)tile).getCentralTE();
        if (central == null || !(central instanceof TileFarmPlain)) {
            return false;
        }
        if (parameter == null || parameter.getItemStack() == null) {
            return !((TileFarmPlain)central).hasResourcesAmount(this.threshold);
        }
        ItemStack filter = parameter.getItemStack().func_77946_l();
        filter.field_77994_a = this.threshold;
        return !((TileFarmPlain)central).hasResources(new ItemStack[]{filter});
    }
}

