/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gui;

import com.mojang.authlib.GameProfile;
import forestry.api.mail.EnumAddressee;
import forestry.api.mail.ILetter;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.IPostalCarrier;
import forestry.api.mail.ITradeStation;
import forestry.api.mail.PostManager;
import forestry.api.mail.TradeStationInfo;
import forestry.core.gui.ContainerItemInventory;
import forestry.core.gui.slots.SlotFiltered;
import forestry.core.network.PacketId;
import forestry.core.network.PacketString;
import forestry.core.proxy.Proxies;
import forestry.mail.items.ItemLetter;
import forestry.mail.network.PacketLetterInfo;
import forestry.mail.network.PacketRequestLetterInfo;
import java.util.Iterator;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;

public class ContainerLetter
extends ContainerItemInventory<ItemLetter.LetterInventory> {
    private EnumAddressee carrierType = EnumAddressee.PLAYER;
    private TradeStationInfo tradeInfo = null;

    public ContainerLetter(EntityPlayer player, ItemLetter.LetterInventory inventory) {
        super(inventory, player.field_71071_by, 17, 145);
        IMailAddress[] recipients;
        ILetter letter;
        int i;
        for (i = 0; i < 4; ++i) {
            this.func_75146_a(new SlotFiltered(inventory, 18 + i, 150, 14 + i * 19).setStackLimit(1));
        }
        for (i = 0; i < 2; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new SlotFiltered(inventory, 0 + j + i * 9, 17 + j * 18, 98 + i * 18));
            }
        }
        if (Proxies.common.isSimulating(player.field_70170_p) && inventory.getLetter().isProcessed()) {
            inventory.onLetterOpened();
        }
        if ((letter = inventory.getLetter()) != null && (recipients = letter.getRecipients()) != null && recipients.length > 0) {
            this.carrierType = recipients[0].getType();
        }
    }

    public void func_75134_a(EntityPlayer entityplayer) {
        ILetter letter;
        if (Proxies.common.isSimulating(entityplayer.field_70170_p) && !(letter = ((ItemLetter.LetterInventory)this.inventory).getLetter()).isProcessed()) {
            IMailAddress sender = PostManager.postRegistry.getMailAddress(entityplayer.func_146103_bH());
            letter.setSender(sender);
        }
        ((ItemLetter.LetterInventory)this.inventory).onContainerClosed();
        super.func_75134_a(entityplayer);
    }

    public ILetter getLetter() {
        return ((ItemLetter.LetterInventory)this.inventory).getLetter();
    }

    public void setCarrierType(EnumAddressee type) {
        this.carrierType = type;
    }

    public EnumAddressee getCarrierType() {
        return this.carrierType;
    }

    public void advanceCarrierType() {
        Iterator<IPostalCarrier> it = PostManager.postRegistry.getRegisteredCarriers().values().iterator();
        while (it.hasNext() && !it.next().getType().equals((Object)this.carrierType)) {
        }
        IPostalCarrier postal = it.hasNext() ? it.next() : PostManager.postRegistry.getRegisteredCarriers().values().iterator().next();
        this.setCarrierType(postal.getType());
    }

    public void handleRequestLetterInfo(EntityPlayer player, PacketRequestLetterInfo packet) {
        String recipientName = packet.getRecipientName();
        EnumAddressee type = packet.getAddressType();
        IMailAddress recipient = ContainerLetter.getRecipient(recipientName, type);
        this.getLetter().setRecipient(recipient);
        if (recipient == null || recipient.isTrader()) {
            this.updateTradeInfo(player.field_70170_p, recipient);
        }
        Proxies.net.sendToPlayer(new PacketLetterInfo(PacketId.LETTER_INFO, type, this.tradeInfo, recipient), player);
    }

    public static IMailAddress getRecipient(String recipientName, EnumAddressee type) {
        switch (type) {
            case PLAYER: {
                GameProfile gameProfile = MinecraftServer.func_71276_C().func_152358_ax().func_152655_a(recipientName);
                if (gameProfile == null) {
                    gameProfile = new GameProfile(new UUID(0L, 0L), recipientName);
                }
                return PostManager.postRegistry.getMailAddress(gameProfile);
            }
            case TRADER: {
                return PostManager.postRegistry.getMailAddress(recipientName);
            }
        }
        return null;
    }

    public IMailAddress getRecipient() {
        if (this.getLetter().getRecipients().length > 0) {
            return this.getLetter().getRecipients()[0];
        }
        return null;
    }

    public String getText() {
        return this.getLetter().getText();
    }

    public void setText(String text) {
        this.getLetter().setText(text);
        PacketString packet = new PacketString(PacketId.LETTER_TEXT, text);
        Proxies.net.sendToServer(packet);
    }

    public void handleSetText(PacketString packet) {
        String text = packet.getString();
        this.getLetter().setText(text);
    }

    public void updateTradeInfo(World world, IMailAddress address) {
        if (!Proxies.common.isSimulating(world)) {
            return;
        }
        if (address == null) {
            this.setTradeInfo(null);
            return;
        }
        ITradeStation station = PostManager.postRegistry.getTradeStation(world, address);
        if (station == null) {
            this.setTradeInfo(null);
            return;
        }
        this.setTradeInfo(station.getTradeInfo());
    }

    public void handleLetterInfoUpdate(PacketLetterInfo packet) {
        this.carrierType = packet.type;
        if (packet.type == EnumAddressee.PLAYER) {
            this.getLetter().setRecipient(packet.address);
        } else if (packet.type == EnumAddressee.TRADER) {
            this.setTradeInfo(packet.tradeInfo);
        }
    }

    public TradeStationInfo getTradeInfo() {
        return this.tradeInfo;
    }

    private void setTradeInfo(TradeStationInfo info) {
        this.tradeInfo = info;
        if (this.tradeInfo == null) {
            this.getLetter().setRecipient(null);
        } else {
            this.getLetter().setRecipient(this.tradeInfo.address);
        }
    }
}

