/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.ITreeRoot;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.Tabs;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IClassification;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.ICrateRegistry;
import forestry.api.storage.StorageManager;
import forestry.arboriculture.FruitProviderNone;
import forestry.arboriculture.FruitProviderPod;
import forestry.arboriculture.FruitProviderRandom;
import forestry.arboriculture.FruitProviderRipening;
import forestry.arboriculture.GuiHandlerArboriculture;
import forestry.arboriculture.VillageHandlerArboriculture;
import forestry.arboriculture.WoodType;
import forestry.arboriculture.commands.CommandTree;
import forestry.arboriculture.gadgets.BlockArbFence;
import forestry.arboriculture.gadgets.BlockArbStairs;
import forestry.arboriculture.gadgets.BlockFireproofLog;
import forestry.arboriculture.gadgets.BlockFireproofPlanks;
import forestry.arboriculture.gadgets.BlockFruitPod;
import forestry.arboriculture.gadgets.BlockLog;
import forestry.arboriculture.gadgets.BlockPlanks;
import forestry.arboriculture.gadgets.BlockSapling;
import forestry.arboriculture.gadgets.BlockSlab;
import forestry.arboriculture.gadgets.ForestryBlockLeaves;
import forestry.arboriculture.gadgets.TileArboristChest;
import forestry.arboriculture.gadgets.TileFruitPod;
import forestry.arboriculture.gadgets.TileLeaves;
import forestry.arboriculture.gadgets.TileSapling;
import forestry.arboriculture.gadgets.TileStairs;
import forestry.arboriculture.genetics.AlleleFruit;
import forestry.arboriculture.genetics.AlleleGrowth;
import forestry.arboriculture.genetics.AlleleLeafEffectNone;
import forestry.arboriculture.genetics.AlleleTreeSpecies;
import forestry.arboriculture.genetics.BranchTrees;
import forestry.arboriculture.genetics.GrowthProvider;
import forestry.arboriculture.genetics.GrowthProviderTropical;
import forestry.arboriculture.genetics.Tree;
import forestry.arboriculture.genetics.TreeHelper;
import forestry.arboriculture.genetics.TreeMutation;
import forestry.arboriculture.genetics.TreeTemplates;
import forestry.arboriculture.genetics.TreekeepingMode;
import forestry.arboriculture.items.ItemGermlingGE;
import forestry.arboriculture.items.ItemGrafter;
import forestry.arboriculture.items.ItemLeavesBlock;
import forestry.arboriculture.items.ItemStairs;
import forestry.arboriculture.items.ItemTreealyzer;
import forestry.arboriculture.items.ItemWoodBlock;
import forestry.arboriculture.network.PacketHandlerArboriculture;
import forestry.arboriculture.proxy.ProxyArboriculture;
import forestry.arboriculture.worldgen.WorldGenAcacia;
import forestry.arboriculture.worldgen.WorldGenAcaciaVanilla;
import forestry.arboriculture.worldgen.WorldGenBalsa;
import forestry.arboriculture.worldgen.WorldGenBaobab;
import forestry.arboriculture.worldgen.WorldGenBirch;
import forestry.arboriculture.worldgen.WorldGenCherry;
import forestry.arboriculture.worldgen.WorldGenChestnut;
import forestry.arboriculture.worldgen.WorldGenCocobolo;
import forestry.arboriculture.worldgen.WorldGenDarkOak;
import forestry.arboriculture.worldgen.WorldGenDate;
import forestry.arboriculture.worldgen.WorldGenEbony;
import forestry.arboriculture.worldgen.WorldGenGiganteum;
import forestry.arboriculture.worldgen.WorldGenGreenheart;
import forestry.arboriculture.worldgen.WorldGenIpe;
import forestry.arboriculture.worldgen.WorldGenJungle;
import forestry.arboriculture.worldgen.WorldGenKapok;
import forestry.arboriculture.worldgen.WorldGenLarch;
import forestry.arboriculture.worldgen.WorldGenLemon;
import forestry.arboriculture.worldgen.WorldGenLime;
import forestry.arboriculture.worldgen.WorldGenMahoe;
import forestry.arboriculture.worldgen.WorldGenMahogany;
import forestry.arboriculture.worldgen.WorldGenMaple;
import forestry.arboriculture.worldgen.WorldGenOak;
import forestry.arboriculture.worldgen.WorldGenPadauk;
import forestry.arboriculture.worldgen.WorldGenPapaya;
import forestry.arboriculture.worldgen.WorldGenPine;
import forestry.arboriculture.worldgen.WorldGenPlum;
import forestry.arboriculture.worldgen.WorldGenPoplar;
import forestry.arboriculture.worldgen.WorldGenSequoia;
import forestry.arboriculture.worldgen.WorldGenSpruce;
import forestry.arboriculture.worldgen.WorldGenTeak;
import forestry.arboriculture.worldgen.WorldGenWalnut;
import forestry.arboriculture.worldgen.WorldGenWenge;
import forestry.arboriculture.worldgen.WorldGenWillow;
import forestry.arboriculture.worldgen.WorldGenZebrawood;
import forestry.core.GameMode;
import forestry.core.config.Config;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.fluids.Fluids;
import forestry.core.gadgets.BlockBase;
import forestry.core.gadgets.MachineDefinition;
import forestry.core.genetics.FruitFamily;
import forestry.core.genetics.alleles.Allele;
import forestry.core.items.ItemForestryBlock;
import forestry.core.items.ItemFruit;
import forestry.core.network.IPacketHandler;
import forestry.core.proxy.Proxies;
import forestry.core.utils.RecipeUtil;
import forestry.core.utils.ShapedRecipeCustom;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.Plugin;
import forestry.plugins.PluginCore;
import forestry.plugins.PluginManager;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.oredict.OreDictionary;

@Plugin(pluginID="Arboriculture", name="Arboriculture", author="Binnie & SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.arboriculture.description")
public class PluginArboriculture
extends ForestryPlugin {
    @SidedProxy(clientSide="forestry.arboriculture.proxy.ClientProxyArboriculture", serverSide="forestry.arboriculture.proxy.ProxyArboriculture")
    public static ProxyArboriculture proxy;
    public static String treekeepingMode;
    public static int modelIdSaplings;
    public static int modelIdLeaves;
    public static int modelIdFences;
    public static int modelIdPods;
    public static ITreeRoot treeInterface;
    public static MachineDefinition definitionChest;
    public static final List<Block> validFences;
    private static final EnumSet<ForestryBlock> logs;
    public static final EnumSet<ForestryBlock> fireproofLogs;
    private static final EnumSet<ForestryBlock> planks;
    private static final EnumSet<ForestryBlock> fireproofPlanks;
    private static final EnumSet<ForestryBlock> slabs;
    private static final EnumSet<ForestryBlock> fences;

    @Override
    protected void setupAPI() {
        super.setupAPI();
        treeInterface = new TreeHelper();
        AlleleManager.alleleRegistry.registerSpeciesRoot(treeInterface);
        treeInterface.registerTreekeepingMode(TreekeepingMode.easy);
        treeInterface.registerTreekeepingMode(TreekeepingMode.normal);
        treeInterface.registerTreekeepingMode(TreekeepingMode.hard);
        treeInterface.registerTreekeepingMode(TreekeepingMode.hardcore);
        treeInterface.registerTreekeepingMode(TreekeepingMode.insane);
    }

    @Override
    public void preInit() {
        super.preInit();
        ForestryBlock.log1.registerBlock(new BlockLog(BlockLog.LogCat.CAT0), ItemWoodBlock.class, "log1");
        ForestryBlock.log2.registerBlock(new BlockLog(BlockLog.LogCat.CAT1), ItemWoodBlock.class, "log2");
        ForestryBlock.log3.registerBlock(new BlockLog(BlockLog.LogCat.CAT2), ItemWoodBlock.class, "log3");
        ForestryBlock.log4.registerBlock(new BlockLog(BlockLog.LogCat.CAT3), ItemWoodBlock.class, "log4");
        ForestryBlock.log5.registerBlock(new BlockLog(BlockLog.LogCat.CAT4), ItemWoodBlock.class, "log5");
        ForestryBlock.log6.registerBlock(new BlockLog(BlockLog.LogCat.CAT5), ItemWoodBlock.class, "log6");
        ForestryBlock.log7.registerBlock(new BlockLog(BlockLog.LogCat.CAT6), ItemWoodBlock.class, "log7");
        ForestryBlock.log8.registerBlock(new BlockLog(BlockLog.LogCat.CAT7), ItemWoodBlock.class, "log8");
        for (ForestryBlock log : logs) {
            log.block().setHarvestLevel("axe", 0);
            OreDictionary.registerOre((String)"logWood", (ItemStack)log.getWildcard());
        }
        ForestryBlock.fireproofLog1.registerBlock(new BlockFireproofLog(BlockLog.LogCat.CAT0), ItemWoodBlock.class, "fireproofLog1");
        ForestryBlock.fireproofLog2.registerBlock(new BlockFireproofLog(BlockLog.LogCat.CAT1), ItemWoodBlock.class, "fireproofLog2");
        ForestryBlock.fireproofLog3.registerBlock(new BlockFireproofLog(BlockLog.LogCat.CAT2), ItemWoodBlock.class, "fireproofLog3");
        ForestryBlock.fireproofLog4.registerBlock(new BlockFireproofLog(BlockLog.LogCat.CAT3), ItemWoodBlock.class, "fireproofLog4");
        ForestryBlock.fireproofLog5.registerBlock(new BlockFireproofLog(BlockLog.LogCat.CAT4), ItemWoodBlock.class, "fireproofLog5");
        ForestryBlock.fireproofLog6.registerBlock(new BlockFireproofLog(BlockLog.LogCat.CAT5), ItemWoodBlock.class, "fireproofLog6");
        ForestryBlock.fireproofLog7.registerBlock(new BlockFireproofLog(BlockLog.LogCat.CAT6), ItemWoodBlock.class, "fireproofLog7");
        ForestryBlock.fireproofLog8.registerBlock(new BlockFireproofLog(BlockLog.LogCat.CAT7), ItemWoodBlock.class, "fireproofLog8");
        for (ForestryBlock fireproofLog : fireproofLogs) {
            fireproofLog.block().setHarvestLevel("axe", 0);
            OreDictionary.registerOre((String)"logWood", (ItemStack)fireproofLog.getWildcard());
        }
        ForestryBlock.planks1.registerBlock(new BlockPlanks(BlockPlanks.PlankCat.CAT0), ItemWoodBlock.class, "planks");
        ForestryBlock.planks2.registerBlock(new BlockPlanks(BlockPlanks.PlankCat.CAT1), ItemWoodBlock.class, "planks2");
        for (ForestryBlock plank : planks) {
            plank.block().setHarvestLevel("axe", 0);
            OreDictionary.registerOre((String)"plankWood", (ItemStack)plank.getWildcard());
        }
        ForestryBlock.fireproofPlanks1.registerBlock(new BlockFireproofPlanks(BlockPlanks.PlankCat.CAT0), ItemWoodBlock.class, "fireproofPlanks1");
        ForestryBlock.fireproofPlanks2.registerBlock(new BlockFireproofPlanks(BlockPlanks.PlankCat.CAT1), ItemWoodBlock.class, "fireproofPlanks2");
        for (ForestryBlock plank : fireproofPlanks) {
            plank.block().setHarvestLevel("axe", 0);
            OreDictionary.registerOre((String)"plankWood", (ItemStack)plank.getWildcard());
        }
        ForestryBlock.slabs1.registerBlock((Block)new BlockSlab(BlockSlab.SlabCat.CAT0), ItemWoodBlock.class, "slabs1");
        ForestryBlock.slabs2.registerBlock((Block)new BlockSlab(BlockSlab.SlabCat.CAT1), ItemWoodBlock.class, "slabs2");
        ForestryBlock.slabs3.registerBlock((Block)new BlockSlab(BlockSlab.SlabCat.CAT2), ItemWoodBlock.class, "slabs3");
        ForestryBlock.slabs4.registerBlock((Block)new BlockSlab(BlockSlab.SlabCat.CAT3), ItemWoodBlock.class, "slabs4");
        for (ForestryBlock plank : slabs) {
            plank.block().setHarvestLevel("axe", 0);
            OreDictionary.registerOre((String)"slabWood", (ItemStack)plank.getWildcard());
        }
        ForestryBlock.fences1.registerBlock((Block)new BlockArbFence(BlockArbFence.FenceCat.CAT0), ItemWoodBlock.class, "fences");
        ForestryBlock.fences2.registerBlock((Block)new BlockArbFence(BlockArbFence.FenceCat.CAT1), ItemWoodBlock.class, "fences2");
        for (ForestryBlock block : fences) {
            block.block().setHarvestLevel("axe", 0);
            OreDictionary.registerOre((String)"fenceWood", (ItemStack)block.getWildcard());
        }
        ForestryBlock.stairs.registerBlock((Block)new BlockArbStairs(ForestryBlock.planks1.block(), 0), ItemStairs.class, "stairs");
        ForestryBlock.stairs.block().setHarvestLevel("axe", 0);
        OreDictionary.registerOre((String)"stairWood", (ItemStack)ForestryBlock.stairs.getWildcard());
        ForestryBlock.saplingGE.registerBlock((Block)new BlockSapling(), ItemForestryBlock.class, "saplingGE");
        OreDictionary.registerOre((String)"treeSapling", (ItemStack)ForestryBlock.saplingGE.getWildcard());
        ForestryBlock.leaves.registerBlock((Block)new ForestryBlockLeaves(), ItemLeavesBlock.class, "leaves");
        OreDictionary.registerOre((String)"treeLeaves", (ItemStack)ForestryBlock.leaves.getWildcard());
        ForestryBlock.pods.registerBlock((Block)new BlockFruitPod(), ItemForestryBlock.class, "pods");
        ForestryBlock.arboriculture.registerBlock((Block)new BlockBase(Material.field_151573_f), ItemForestryBlock.class, "arboriculture");
        ForestryBlock.arboriculture.block().func_149647_a(Tabs.tabArboriculture);
        definitionChest = ((BlockBase)ForestryBlock.arboriculture.block()).addDefinition(new MachineDefinition(0, "forestry.ArbChest", TileArboristChest.class, ShapedRecipeCustom.createShapedRecipe(ForestryBlock.arboriculture.getItemStack(1, 0), " # ", "XYX", "XXX", Character.valueOf('#'), Blocks.field_150359_w, Character.valueOf('X'), "treeSapling", Character.valueOf('Y'), Blocks.field_150486_ae)).setFaces(0, 1, 2, 3, 4, 4, 0, 7));
        proxy.initializeRendering();
        validFences.add(ForestryBlock.fences1.block());
        validFences.add(ForestryBlock.fences2.block());
        validFences.add(Blocks.field_150422_aJ);
        validFences.add(Blocks.field_150396_be);
        validFences.add(Blocks.field_150386_bk);
        PluginCore.rootCommand.addChildCommand(new CommandTree());
    }

    @Override
    public void doInit() {
        super.doInit();
        PluginArboriculture.createAlleles();
        PluginArboriculture.createMutations();
        PluginArboriculture.registerTemplates();
        PluginArboriculture.registerErsatzGenomes();
        GameRegistry.registerTileEntity(TileSapling.class, (String)"forestry.Sapling");
        GameRegistry.registerTileEntity(TileLeaves.class, (String)"forestry.Leaves");
        GameRegistry.registerTileEntity(TileStairs.class, (String)"forestry.Stairs");
        GameRegistry.registerTileEntity(TileFruitPod.class, (String)"forestry.Pods");
        definitionChest.register();
        if (Config.enableVillager) {
            VillagerRegistry.instance().registerVillagerId(81);
            Proxies.render.registerVillagerSkin(81, "textures/entity/lumberjack.png");
            VillagerRegistry.instance().registerVillageTradeHandler(81, (VillagerRegistry.IVillageTradeHandler)new VillageHandlerArboriculture());
        }
    }

    @Override
    public void postInit() {
        super.postInit();
        PluginArboriculture.registerDungeonLoot();
    }

    @Override
    protected void registerItems() {
        ForestryItem.sapling.registerItem(new ItemGermlingGE(EnumGermlingType.SAPLING), "sapling");
        OreDictionary.registerOre((String)"treeSapling", (ItemStack)ForestryItem.sapling.getWildcard());
        if (PluginManager.Module.APICULTURE.isEnabled()) {
            ForestryItem.pollenFertile.registerItem(new ItemGermlingGE(EnumGermlingType.POLLEN), "pollenFertile");
            ForestryItem.treealyzer.registerItem(new ItemTreealyzer(), "treealyzer");
        }
        ForestryItem.grafter.registerItem(new ItemGrafter(4), "grafter");
        ForestryItem.grafterProven.registerItem(new ItemGrafter(149), "grafterProven");
    }

    @Override
    protected void registerCrates() {
        ICrateRegistry crateRegistry = StorageManager.crateRegistry;
        crateRegistry.registerCrate(ItemFruit.EnumFruit.CHERRY.getStack(), "cratedCherry");
        crateRegistry.registerCrate(ItemFruit.EnumFruit.WALNUT.getStack(), "cratedWalnut");
        crateRegistry.registerCrate(ItemFruit.EnumFruit.CHESTNUT.getStack(), "cratedChestnut");
        crateRegistry.registerCrate(ItemFruit.EnumFruit.LEMON.getStack(), "cratedLemon");
        crateRegistry.registerCrate(ItemFruit.EnumFruit.PLUM.getStack(), "cratedPlum");
        crateRegistry.registerCrate(ItemFruit.EnumFruit.PAPAYA.getStack(), "cratedPapaya");
        crateRegistry.registerCrate(ItemFruit.EnumFruit.DATES.getStack(), "cratedDates");
    }

    @Override
    protected void registerRecipes() {
        int i;
        int i2;
        for (ForestryBlock log : logs) {
            Proxies.common.addSmelting(log.getWildcard(), new ItemStack(Items.field_151044_h, 1, 1), 0.15f);
        }
        for (i2 = 0; i2 < 4; ++i2) {
            Proxies.common.addShapelessRecipe(ForestryBlock.planks1.getItemStack(4, i2), ForestryBlock.log1.getItemStack(1, i2));
        }
        for (i2 = 0; i2 < 4; ++i2) {
            Proxies.common.addShapelessRecipe(ForestryBlock.planks1.getItemStack(4, 4 + i2), ForestryBlock.log2.getItemStack(1, i2));
        }
        for (i2 = 0; i2 < 4; ++i2) {
            Proxies.common.addShapelessRecipe(ForestryBlock.planks1.getItemStack(4, 8 + i2), ForestryBlock.log3.getItemStack(1, i2));
        }
        for (i2 = 0; i2 < 4; ++i2) {
            Proxies.common.addShapelessRecipe(ForestryBlock.planks1.getItemStack(4, 12 + i2), ForestryBlock.log4.getItemStack(1, i2));
        }
        for (i2 = 0; i2 < 4; ++i2) {
            Proxies.common.addShapelessRecipe(ForestryBlock.planks2.getItemStack(4, i2), ForestryBlock.log5.getItemStack(1, i2));
        }
        for (i2 = 0; i2 < 4; ++i2) {
            Proxies.common.addShapelessRecipe(ForestryBlock.planks2.getItemStack(4, 4 + i2), ForestryBlock.log6.getItemStack(1, i2));
        }
        for (i2 = 0; i2 < 4; ++i2) {
            Proxies.common.addShapelessRecipe(ForestryBlock.planks2.getItemStack(4, 8 + i2), ForestryBlock.log7.getItemStack(1, i2));
        }
        for (i2 = 0; i2 < 1; ++i2) {
            Proxies.common.addShapelessRecipe(ForestryBlock.planks2.getItemStack(4, 12 + i2), ForestryBlock.log8.getItemStack(1, i2));
        }
        if (PluginManager.Module.FACTORY.isEnabled() && PluginManager.Module.APICULTURE.isEnabled()) {
            ItemStack plankStack;
            ForestryBlock fireproofPlank;
            int i3;
            for (ForestryBlock forestryBlock : logs) {
                BlockLog blockLog = (BlockLog)forestryBlock.block();
                ForestryBlock fireproofLog = BlockFireproofLog.getFireproofLog(blockLog);
                for (int i4 = 0; i4 < 4 && (forestryBlock != ForestryBlock.log8 || i4 <= 0); ++i4) {
                    ItemStack logStack = forestryBlock.getItemStack(1, i4);
                    ItemStack fireproofLogStack = fireproofLog.getItemStack(1, i4);
                    RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), fireproofLogStack, new Object[]{" # ", "#X#", " # ", Character.valueOf('#'), ForestryItem.refractoryWax, Character.valueOf('X'), logStack});
                }
            }
            ForestryBlock plank = ForestryBlock.planks1;
            for (i3 = 0; i3 < 16; ++i3) {
                fireproofPlank = BlockFireproofPlanks.getFireproofPlanks((BlockPlanks)plank.block());
                plankStack = plank.getItemStack(1, i3);
                ItemStack fireproofPlankStack = fireproofPlank.getItemStack(5, i3);
                RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), fireproofPlankStack, new Object[]{"X#X", "#X#", "X#X", Character.valueOf('#'), ForestryItem.refractoryWax, Character.valueOf('X'), plankStack});
            }
            plank = ForestryBlock.planks2;
            for (i3 = 0; i3 < 12; ++i3) {
                fireproofPlank = BlockFireproofPlanks.getFireproofPlanks((BlockPlanks)plank.block());
                plankStack = plank.getItemStack(1, i3);
                ItemStack fireproofPlankStack = fireproofPlank.getItemStack(5, i3);
                RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), fireproofPlankStack, new Object[]{"X#X", "#X#", "X#X", Character.valueOf('#'), ForestryItem.refractoryWax, Character.valueOf('X'), plankStack});
            }
        }
        for (i = 0; i < 4; ++i) {
            Proxies.common.addShapelessRecipe(ForestryBlock.fireproofPlanks1.getItemStack(4, i), ForestryBlock.fireproofLog1.getItemStack(1, i));
        }
        for (i = 0; i < 4; ++i) {
            Proxies.common.addShapelessRecipe(ForestryBlock.fireproofPlanks1.getItemStack(4, 4 + i), ForestryBlock.fireproofLog2.getItemStack(1, i));
        }
        for (i = 0; i < 4; ++i) {
            Proxies.common.addShapelessRecipe(ForestryBlock.fireproofPlanks1.getItemStack(4, 8 + i), ForestryBlock.fireproofLog3.getItemStack(1, i));
        }
        for (i = 0; i < 4; ++i) {
            Proxies.common.addShapelessRecipe(ForestryBlock.fireproofPlanks1.getItemStack(4, 12 + i), ForestryBlock.fireproofLog4.getItemStack(1, i));
        }
        for (i = 0; i < 4; ++i) {
            Proxies.common.addShapelessRecipe(ForestryBlock.fireproofPlanks2.getItemStack(4, i), ForestryBlock.fireproofLog5.getItemStack(1, i));
        }
        for (i = 0; i < 4; ++i) {
            Proxies.common.addShapelessRecipe(ForestryBlock.fireproofPlanks2.getItemStack(4, 4 + i), ForestryBlock.fireproofLog6.getItemStack(1, i));
        }
        for (i = 0; i < 4; ++i) {
            Proxies.common.addShapelessRecipe(ForestryBlock.fireproofPlanks2.getItemStack(4, 8 + i), ForestryBlock.fireproofLog7.getItemStack(1, i));
        }
        for (i = 0; i < 1; ++i) {
            Proxies.common.addShapelessRecipe(ForestryBlock.fireproofPlanks2.getItemStack(4, 12 + i), ForestryBlock.fireproofLog8.getItemStack(1, i));
        }
        for (WoodType woodType : WoodType.values()) {
            int i5 = woodType.ordinal();
            if (i5 < 8) {
                Proxies.common.addPriorityRecipe(ForestryBlock.slabs1.getItemStack(6, i5 % 8), "###", Character.valueOf('#'), ForestryBlock.planks1.getItemStack(1, i5 % 16));
                continue;
            }
            if (i5 < 16) {
                Proxies.common.addPriorityRecipe(ForestryBlock.slabs2.getItemStack(6, i5 % 8), "###", Character.valueOf('#'), ForestryBlock.planks1.getItemStack(1, i5 % 16));
                continue;
            }
            if (i5 < 24) {
                Proxies.common.addPriorityRecipe(ForestryBlock.slabs3.getItemStack(6, i5 % 8), "###", Character.valueOf('#'), ForestryBlock.planks2.getItemStack(1, i5 % 16));
                continue;
            }
            if (i5 < 32) {
                Proxies.common.addPriorityRecipe(ForestryBlock.slabs4.getItemStack(6, i5 % 8), "###", Character.valueOf('#'), ForestryBlock.planks2.getItemStack(1, i5 % 16));
                continue;
            }
            throw new RuntimeException("Wood type has no slabs defined");
        }
        for (WoodType woodType : WoodType.values()) {
            int i6 = woodType.ordinal();
            if (i6 < 16) {
                Proxies.common.addRecipe(ForestryBlock.fences1.getItemStack(4, i6 % 16), "###", "# #", Character.valueOf('#'), ForestryBlock.planks1.getItemStack(1, i6 % 16));
                Proxies.common.addRecipe(ForestryBlock.fences1.getItemStack(3, i6 % 16), "#X#", "#X#", Character.valueOf('#'), ForestryBlock.planks1.getItemStack(1, i6 % 16), Character.valueOf('X'), "stickWood");
                continue;
            }
            if (i6 < 32) {
                Proxies.common.addRecipe(ForestryBlock.fences2.getItemStack(4, i6 % 16), "###", "# #", Character.valueOf('#'), ForestryBlock.planks2.getItemStack(1, i6 % 16));
                Proxies.common.addRecipe(ForestryBlock.fences2.getItemStack(3, i6 % 16), "#X#", "#X#", Character.valueOf('#'), ForestryBlock.planks2.getItemStack(1, i6 % 16), Character.valueOf('X'), "stickWood");
                continue;
            }
            throw new RuntimeException("Wood type has no fences defined");
        }
        if (PluginManager.Module.FACTORY.isEnabled()) {
            RecipeManagers.carpenterManager.addRecipe(100, Fluids.WATER.getFluid(2000), null, ForestryItem.treealyzer.getItemStack(), "X#X", "X#X", "RDR", Character.valueOf('#'), Blocks.field_150410_aZ, Character.valueOf('X'), "ingotCopper", Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('D'), Items.field_151045_i);
            int seedOilMultiplier = GameMode.getGameMode().getIntegerSetting("squeezer.liquid.seed");
            int juiceMultiplier = GameMode.getGameMode().getIntegerSetting("squeezer.liquid.apple");
            int mulchMultiplier = GameMode.getGameMode().getIntegerSetting("squeezer.mulch.apple");
            RecipeManagers.squeezerManager.addRecipe(20, new ItemStack[]{ItemFruit.EnumFruit.CHERRY.getStack()}, Fluids.SEEDOIL.getFluid(5 * seedOilMultiplier), ForestryItem.mulch.getItemStack(), 5);
            RecipeManagers.squeezerManager.addRecipe(60, new ItemStack[]{ItemFruit.EnumFruit.WALNUT.getStack()}, Fluids.SEEDOIL.getFluid(18 * seedOilMultiplier), ForestryItem.mulch.getItemStack(), 5);
            RecipeManagers.squeezerManager.addRecipe(70, new ItemStack[]{ItemFruit.EnumFruit.CHESTNUT.getStack()}, Fluids.SEEDOIL.getFluid(22 * seedOilMultiplier), ForestryItem.mulch.getItemStack(), 2);
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{ItemFruit.EnumFruit.LEMON.getStack()}, Fluids.JUICE.getFluid(juiceMultiplier * 2), ForestryItem.mulch.getItemStack(), (int)Math.floor((float)mulchMultiplier * 0.5f));
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{ItemFruit.EnumFruit.PLUM.getStack()}, Fluids.JUICE.getFluid((int)Math.floor((float)juiceMultiplier * 0.5f)), ForestryItem.mulch.getItemStack(), mulchMultiplier * 3);
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{ItemFruit.EnumFruit.PAPAYA.getStack()}, Fluids.JUICE.getFluid(juiceMultiplier * 3), ForestryItem.mulch.getItemStack(), (int)Math.floor((float)mulchMultiplier * 0.5f));
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{ItemFruit.EnumFruit.DATES.getStack()}, Fluids.JUICE.getFluid((int)Math.floor((double)juiceMultiplier * 0.25)), ForestryItem.mulch.getItemStack(), mulchMultiplier);
            RecipeUtil.injectLeveledRecipe(ForestryItem.sapling.getItemStack(), GameMode.getGameMode().getIntegerSetting("fermenter.yield.sapling"), Fluids.BIOMASS);
        }
        for (WoodType woodType : WoodType.values()) {
            ForestryBlock planks;
            int i7 = woodType.ordinal();
            if (i7 < 16) {
                planks = ForestryBlock.planks1;
            } else if (i7 < 32) {
                planks = ForestryBlock.planks2;
            } else {
                throw new RuntimeException("Wood type has no planks defined");
            }
            NBTTagCompound compound = new NBTTagCompound();
            woodType.saveToCompound(compound);
            ItemStack stairs = ForestryBlock.stairs.getItemStack(4);
            stairs.func_77982_d(compound);
            Proxies.common.addPriorityRecipe(stairs, "#  ", "## ", "###", Character.valueOf('#'), planks.getItemStack(1, i7 % 16));
        }
        Proxies.common.addRecipe(ForestryItem.grafter.getItemStack(), "  B", " # ", "#  ", Character.valueOf('B'), "ingotBronze", Character.valueOf('#'), Items.field_151055_y);
    }

    private static void createAlleles() {
        IClassification angiosperms = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.DIVISION, "angiosperms", "Angiosperms");
        AlleleManager.alleleRegistry.getClassification("kingdom.plantae").addMemberGroup(angiosperms);
        IClassification pinophyta = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.DIVISION, "pinophyta", "Pinophyta");
        AlleleManager.alleleRegistry.getClassification("kingdom.plantae").addMemberGroup(pinophyta);
        IClassification magnoliophyta = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.DIVISION, "magnoliophyta", "Magnoliophyta");
        AlleleManager.alleleRegistry.getClassification("kingdom.plantae").addMemberGroup(magnoliophyta);
        IClassification rosids = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.CLASS, "rosids", "Rosids");
        angiosperms.addMemberGroup(rosids);
        IClassification asterids = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.CLASS, "asterids", "Asterids");
        angiosperms.addMemberGroup(asterids);
        IClassification pinopsida = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.CLASS, "pinopsida", "Pinopsida");
        pinophyta.addMemberGroup(pinopsida);
        IClassification magnoliopsida = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.CLASS, "magnoliopsida", "Magnoliopsida");
        pinophyta.addMemberGroup(magnoliopsida);
        IClassification fabales = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "fabales", "Fabales");
        rosids.addMemberGroup(fabales);
        IClassification rosales = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "rosales", "Rosales");
        rosids.addMemberGroup(rosales);
        IClassification fagales = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "fagales", "Fagales");
        rosids.addMemberGroup(fagales);
        IClassification malvales = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "malvales", "Malvales");
        rosids.addMemberGroup(malvales);
        IClassification malpighiales = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "malpighiales", "Malpighiales");
        rosids.addMemberGroup(malpighiales);
        IClassification ericales = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "ericales", "Ericales");
        asterids.addMemberGroup(ericales);
        IClassification lamiales = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "lamiales", "Lamiales");
        asterids.addMemberGroup(lamiales);
        IClassification pinales = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "pinales", "Pinales");
        pinopsida.addMemberGroup(pinales);
        IClassification laurales = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "laurales", "Laurales");
        rosids.addMemberGroup(laurales);
        IClassification sapindales = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "sapindales", "Sapindales");
        rosids.addMemberGroup(sapindales);
        IClassification brassicales = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "brassicales", "Brassicales");
        rosids.addMemberGroup(brassicales);
        IClassification betulaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "betulaceae", "Betulaceae");
        fagales.addMemberGroup(betulaceae);
        IClassification fagaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "fagaceae", "Fagaceae");
        fagales.addMemberGroup(fagaceae);
        IClassification juglandaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "juglandaceae", "Juglandaceae");
        fagales.addMemberGroup(juglandaceae);
        IClassification malvaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "malvaceae", "Malvaceae");
        malvales.addMemberGroup(malvaceae);
        IClassification dipterocarpaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "dipterocarpaceae", "Dipterocarpaceae");
        malvales.addMemberGroup(dipterocarpaceae);
        IClassification pinaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "pinaceae", "Pinaceae");
        pinales.addMemberGroup(pinaceae);
        IClassification cupressaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "cupressaceae", "Cupressaceae");
        pinales.addMemberGroup(cupressaceae);
        IClassification lamiaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "lamiaceae", "Lamiaceae");
        lamiales.addMemberGroup(lamiaceae);
        IClassification bignoniaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "bignoniaceae", "Bignoniaceae");
        lamiales.addMemberGroup(bignoniaceae);
        IClassification ebenaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "ebenaceae", "Ebenaceae");
        ericales.addMemberGroup(ebenaceae);
        IClassification fabaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "fabaceae", "Fabaceae");
        ericales.addMemberGroup(fabaceae);
        IClassification rosaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "rosaceae", "Rosaceae");
        rosales.addMemberGroup(rosaceae);
        IClassification salicaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "salicaceae", "Salicaceae");
        malpighiales.addMemberGroup(salicaceae);
        IClassification lauraceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "lauraceae", "Lauraceae");
        malpighiales.addMemberGroup(lauraceae);
        IClassification rutaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "rutaceae", "Rutaceae");
        sapindales.addMemberGroup(rutaceae);
        IClassification sapindaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "sapindaceae", "Sapindaceae");
        sapindales.addMemberGroup(sapindaceae);
        IClassification anacardiaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "anacardiaceae", "Anacardiaceae");
        sapindales.addMemberGroup(anacardiaceae);
        IClassification caricaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "caricaceae", "Caricaceae");
        brassicales.addMemberGroup(caricaceae);
        BranchTrees quercus = new BranchTrees("quercus", "Quercus");
        fagaceae.addMemberGroup(quercus);
        BranchTrees castanea = new BranchTrees("castanea", "Castanea");
        fagaceae.addMemberGroup(castanea);
        BranchTrees betula = new BranchTrees("betula", "Betula");
        betulaceae.addMemberGroup(betula);
        BranchTrees tilia = new BranchTrees("tilia", "Tilia");
        malvaceae.addMemberGroup(tilia);
        BranchTrees ceiba = new BranchTrees("ceiba", "Ceiba");
        malvaceae.addMemberGroup(ceiba);
        BranchTrees adansonia = new BranchTrees("adansonia", "Adansonia");
        malvaceae.addMemberGroup(adansonia);
        BranchTrees picea = new BranchTrees("picea", "Picea");
        pinaceae.addMemberGroup(picea);
        BranchTrees pinus = new BranchTrees("pinus", "Pinus");
        pinaceae.addMemberGroup(pinus);
        BranchTrees larix = new BranchTrees("larix", "Larix");
        pinaceae.addMemberGroup(larix);
        BranchTrees juglans = new BranchTrees("juglans", "Juglans");
        juglandaceae.addMemberGroup(juglans);
        BranchTrees sequoia = new BranchTrees("sequoia", "Sequoia");
        cupressaceae.addMemberGroup(sequoia);
        BranchTrees sequoiadendron = new BranchTrees("sequoiadendron", "Sequoiadendron");
        cupressaceae.addMemberGroup(sequoiadendron);
        BranchTrees tectona = new BranchTrees("tectona", "Tectona");
        lamiaceae.addMemberGroup(tectona);
        BranchTrees diospyros = new BranchTrees("ebony", "Diospyros");
        ebenaceae.addMemberGroup(diospyros);
        BranchTrees shorea = new BranchTrees("mahogany", "Shorea");
        dipterocarpaceae.addMemberGroup(shorea);
        BranchTrees acacia = new BranchTrees("acacia", "Acacia");
        fabaceae.addMemberGroup(acacia);
        BranchTrees millettia = new BranchTrees("millettia", "Millettia");
        fabaceae.addMemberGroup(millettia);
        BranchTrees dalbergia = new BranchTrees("dalbergia", "Dalbergia");
        fabaceae.addMemberGroup(dalbergia);
        BranchTrees pterocarpus = new BranchTrees("pterocarpus", "Pterocarpus");
        fabaceae.addMemberGroup(pterocarpus);
        BranchTrees tabebuia = new BranchTrees("tabebuia", "Tabebuia");
        bignoniaceae.addMemberGroup(tabebuia);
        BranchTrees astronium = new BranchTrees("astronium", "Astronium");
        anacardiaceae.addMemberGroup(astronium);
        BranchTrees ochroma = new BranchTrees("ochroma", "Ochroma");
        malvaceae.addMemberGroup(ochroma);
        BranchTrees prunus = new BranchTrees("prunus", "Prunus");
        rosaceae.addMemberGroup(prunus);
        BranchTrees salix = new BranchTrees("salix", "Salix");
        salicaceae.addMemberGroup(salix);
        BranchTrees chlorocardium = new BranchTrees("chlorocardium", "Chlorocardium");
        salicaceae.addMemberGroup(chlorocardium);
        BranchTrees talipariti = new BranchTrees("talipariti", "Talipariti");
        malvaceae.addMemberGroup(talipariti);
        BranchTrees populus = new BranchTrees("populus", "Populus");
        salicaceae.addMemberGroup(populus);
        BranchTrees citrus = new BranchTrees("citrus", "Citrus");
        rutaceae.addMemberGroup(citrus);
        BranchTrees acer = new BranchTrees("acer", "Acer");
        sapindaceae.addMemberGroup(acer);
        BranchTrees tropical = new BranchTrees("Tropical", "");
        BranchTrees carica = new BranchTrees("carica", "Carica");
        FruitFamily prunes = new FruitFamily("prunes", "Prunus domestica");
        FruitFamily pomes = new FruitFamily("pomes", "Pomum");
        FruitFamily jungle = new FruitFamily("jungle", "Tropicus");
        FruitFamily nux = new FruitFamily("nuts", "Nux");
        ItemStack oakLog = new ItemStack(Blocks.field_150364_r, 1, 0);
        ItemStack spruceLog = new ItemStack(Blocks.field_150364_r, 1, 1);
        ItemStack birchLog = new ItemStack(Blocks.field_150364_r, 1, 2);
        ItemStack jungleLog = new ItemStack(Blocks.field_150364_r, 1, 3);
        ItemStack acaciaLog = new ItemStack(Blocks.field_150363_s, 1, 0);
        ItemStack darkOakLog = new ItemStack(Blocks.field_150363_s, 1, 1);
        ItemStack larchLog = ForestryBlock.log1.getItemStack(1, 0);
        ItemStack teakLog = ForestryBlock.log1.getItemStack(1, 1);
        ItemStack desertAcaciaLog = ForestryBlock.log1.getItemStack(1, 2);
        ItemStack limeLog = ForestryBlock.log1.getItemStack(1, 3);
        ItemStack chestnutLog = ForestryBlock.log2.getItemStack(1, 0);
        ItemStack wengeLog = ForestryBlock.log2.getItemStack(1, 1);
        ItemStack baobabLog = ForestryBlock.log2.getItemStack(1, 2);
        ItemStack sequioaLog = ForestryBlock.log2.getItemStack(1, 3);
        ItemStack kapokLog = ForestryBlock.log3.getItemStack(1, 0);
        ItemStack ebonyLog = ForestryBlock.log3.getItemStack(1, 1);
        ItemStack mahoganyLog = ForestryBlock.log3.getItemStack(1, 2);
        ItemStack balsaLog = ForestryBlock.log3.getItemStack(1, 3);
        ItemStack willowLog = ForestryBlock.log4.getItemStack(1, 0);
        ItemStack walnutLog = ForestryBlock.log4.getItemStack(1, 1);
        ItemStack sipiriLog = ForestryBlock.log4.getItemStack(1, 2);
        ItemStack cherryLog = ForestryBlock.log4.getItemStack(1, 3);
        ItemStack mahoeLog = ForestryBlock.log5.getItemStack(1, 0);
        ItemStack poplarLog = ForestryBlock.log5.getItemStack(1, 1);
        ItemStack dateLog = ForestryBlock.log5.getItemStack(1, 2);
        ItemStack papayaLog = ForestryBlock.log5.getItemStack(1, 3);
        ItemStack pineLog = ForestryBlock.log6.getItemStack(1, 0);
        ItemStack plumLog = ForestryBlock.log6.getItemStack(1, 1);
        ItemStack mapleLog = ForestryBlock.log6.getItemStack(1, 2);
        ItemStack lemonLog = ForestryBlock.log6.getItemStack(1, 3);
        ItemStack giganteumLog = ForestryBlock.log7.getItemStack(1, 0);
        ItemStack ipeLog = ForestryBlock.log7.getItemStack(1, 1);
        ItemStack padaukLog = ForestryBlock.log7.getItemStack(1, 2);
        ItemStack cocoboloLog = ForestryBlock.log7.getItemStack(1, 3);
        ItemStack zebrawoodLog = ForestryBlock.log8.getItemStack(1, 0);
        Allele.treeOak = new AlleleTreeSpecies("treeOak", false, "appleOak", quercus, "robur", proxy.getFoliageColorBasic(), WorldGenOak.class, oakLog).addFruitFamily(pomes).setVanillaMap(0);
        Allele.treeDarkOak = new AlleleTreeSpecies("treeDarkOak", false, "darkOak", quercus, "velutina", proxy.getFoliageColorBasic(), WorldGenDarkOak.class, darkOakLog).addFruitFamily(pomes).setVanillaMap(5);
        Allele.treeBirch = new AlleleTreeSpecies("treeBirch", false, "silverBirch", betula, "pendula", proxy.getFoliageColorBirch(), 11585096, WorldGenBirch.class, birchLog).setVanillaMap(2);
        Allele.treeLime = new AlleleTreeSpecies("treeLime", true, "silverLime", tilia, "tomentosa", 6201607, WorldGenLime.class, limeLog).addFruitFamily(nux).addFruitFamily(prunes).addFruitFamily(pomes);
        Allele.treeWalnut = new AlleleTreeSpecies("treeWalnut", true, "commonWalnut", juglans, "regia", 7965781, 11585096, WorldGenWalnut.class, walnutLog).addFruitFamily(nux).addFruitFamily(prunes).addFruitFamily(pomes).setGirth(2);
        Allele.treeChestnut = new AlleleTreeSpecies("treeChestnut", true, "sweetChestnut", castanea, "sativa", 6201607, 11585096, WorldGenChestnut.class, chestnutLog).addFruitFamily(nux).addFruitFamily(prunes).addFruitFamily(pomes).setGirth(2);
        Allele.treeCherry = new AlleleTreeSpecies("treeCherry", true, "hillCherry", prunus, "serrulata", 15110618, 15089241, WorldGenCherry.class, cherryLog).addFruitFamily(prunes).addFruitFamily(pomes);
        Allele.treeLemon = new AlleleTreeSpecies("treeLemon", true, "lemon", citrus, "limon", 8957780, 10729552, WorldGenLemon.class, lemonLog).addFruitFamily(pomes).addFruitFamily(prunes);
        Allele.treePlum = new AlleleTreeSpecies("treePlum", true, "plum", prunus, "domestica", 5804614, 10729552, WorldGenPlum.class, plumLog).addFruitFamily(pomes).addFruitFamily(prunes);
        Allele.treeMaple = new AlleleTreeSpecies("treeMaple", true, "sugarMaple", acer, "saccharum", 13956133, 6396476, WorldGenMaple.class, mapleLog).addFruitFamily(prunes).addFruitFamily(pomes).setLeafIndices("maple");
        Allele.treeSpruce = new AlleleTreeSpecies("treeSpruce", false, "redSpruce", picea, "abies", proxy.getFoliageColorPine(), 5479698, WorldGenSpruce.class, spruceLog).setLeafIndices("conifers").setVanillaMap(1);
        Allele.treeLarch = new AlleleTreeSpecies("treeLarch", true, "mundaneLarch", larix, "decidua", 6918032, 5675158, WorldGenLarch.class, larchLog).setLeafIndices("conifers");
        Allele.treePine = new AlleleTreeSpecies("treePine", true, "bullPine", pinus, "sabiniana", 0xFEFF8F, 16767375, WorldGenPine.class, pineLog).setLeafIndices("conifers");
        Allele.treeSequioa = new AlleleTreeSpecies("treeSequioa", false, "coastSequoia", sequoia, "sempervirens", 4296305, 5675158, WorldGenSequoia.class, sequioaLog).setLeafIndices("conifers").setGirth(3);
        Allele.treeGiganteum = new AlleleTreeSpecies("treeGigant", false, "giantSequoia", sequoiadendron, "giganteum", 7570484, WorldGenGiganteum.class, giganteumLog).setLeafIndices("conifers").setGirth(4);
        Allele.treeJungle = new AlleleTreeSpecies("treeJungle", false, "jungle", tropical, "tectona", proxy.getFoliageColorBasic(), 5479698, WorldGenJungle.class, jungleLog).addFruitFamily(jungle).setLeafIndices("jungle").setVanillaMap(3);
        Allele.treeTeak = new AlleleTreeSpecies("treeTeak", true, "teak", tectona, "grandis", 0xFEFF8F, 16767375, WorldGenTeak.class, teakLog).addFruitFamily(jungle).setLeafIndices("jungle");
        Allele.treeIpe = new AlleleTreeSpecies("treeIpe", true, "ipe", tabebuia, "serratifolia", 16634375, 11374340, WorldGenIpe.class, ipeLog).addFruitFamily(jungle).setLeafIndices("jungle").setGirth(2);
        Allele.treeKapok = new AlleleTreeSpecies("treeKapok", true, "kapok", ceiba, "pentandra", 9017467, 9022110, WorldGenKapok.class, kapokLog).addFruitFamily(jungle).addFruitFamily(prunes).setLeafIndices("jungle");
        Allele.treeEbony = new AlleleTreeSpecies("treeEbony", true, "myrtleEbony", diospyros, "pentamera", 10670666, 12898890, WorldGenEbony.class, ebonyLog).addFruitFamily(jungle).addFruitFamily(prunes).setGirth(3).setLeafIndices("jungle");
        Allele.treeZebrawood = new AlleleTreeSpecies("treeZebrawood", false, "zebrawood", astronium, "graveolens", 10670666, 12898890, WorldGenZebrawood.class, zebrawoodLog).addFruitFamily(nux).setGirth(2).setLeafIndices("jungle");
        Allele.treeMahogany = new AlleleTreeSpecies("treeMahogony", true, "yellowMeranti", shorea, "gibbosa", 9089364, 11120980, WorldGenMahogany.class, mahoganyLog).addFruitFamily(jungle).setGirth(2).setLeafIndices("jungle");
        Allele.treeAcacia = new AlleleTreeSpecies("treeAcaciaVanilla", true, "acacia", acacia, "aneura", 0x616101, 11776770, WorldGenAcaciaVanilla.class, acaciaLog).addFruitFamily(jungle).addFruitFamily(nux).setVanillaMap(4);
        Allele.treeDesertAcacia = new AlleleTreeSpecies("treeAcacia", true, "desertAcacia", acacia, "erioloba", 7638044, 11776770, WorldGenAcacia.class, desertAcaciaLog).addFruitFamily(jungle).addFruitFamily(nux);
        Allele.treePadauk = new AlleleTreeSpecies("treePadauk", true, "padauk", pterocarpus, "soyauxii", 13688716, 4414514, WorldGenPadauk.class, padaukLog).addFruitFamily(jungle);
        Allele.treeBalsa = new AlleleTreeSpecies("treeBalsa", true, "balsa", ochroma, "pyramidale", 5876736, 0xFEFF8F, WorldGenBalsa.class, balsaLog).addFruitFamily(jungle).addFruitFamily(nux);
        Allele.treeCocobolo = new AlleleTreeSpecies("treeCocobolo", false, "cocobolo", dalbergia, "retusa", 6988154, 4750668, WorldGenCocobolo.class, cocoboloLog).addFruitFamily(jungle);
        Allele.treeWenge = new AlleleTreeSpecies("treeWenge", true, "wenge", millettia, "laurentii", 11379031, 11373143, WorldGenWenge.class, wengeLog).addFruitFamily(jungle).addFruitFamily(nux).setGirth(2);
        Allele.treeBaobab = new AlleleTreeSpecies("treeBaobab", true, "grandidierBaobab", adansonia, "digitata", 0xFEFF8F, 16767375, WorldGenBaobab.class, baobabLog).addFruitFamily(jungle).addFruitFamily(nux).setGirth(3);
        Allele.treeMahoe = new AlleleTreeSpecies("treeMahoe", true, "blueMahoe", talipariti, "elatum", 10533403, 7971189, WorldGenMahoe.class, mahoeLog).addFruitFamily(jungle).addFruitFamily(pomes).addFruitFamily(prunes);
        Allele.treeWillow = new AlleleTreeSpecies("treeWillow", true, "whiteWillow", salix, "alba", 10729637, 10729552, WorldGenWillow.class, willowLog).addFruitFamily(nux).addFruitFamily(prunes).addFruitFamily(pomes).setLeafIndices("willow");
        Allele.treeSipiri = new AlleleTreeSpecies("treeSipiri", true, "sipiri", chlorocardium, "rodiei", 6785297, 7971189, WorldGenGreenheart.class, sipiriLog).addFruitFamily(jungle);
        Allele.treePapaya = new AlleleTreeSpecies("treePapaya", true, "papaya", carica, "papaya", 7184216, 10413695, WorldGenPapaya.class, papayaLog).addFruitFamily(jungle).addFruitFamily(nux).setLeafIndices("palm");
        Allele.treeDate = new AlleleTreeSpecies("treeDate", true, "datePalm", null, "dactylifera", 13356409, 15790991, WorldGenDate.class, dateLog).addFruitFamily(jungle).addFruitFamily(nux).setLeafIndices("palm");
        Allele.treePoplar = new AlleleTreeSpecies("treePoplar", true, "whitePoplar", populus, "alba", 10729637, 5479698, WorldGenPoplar.class, poplarLog).addFruitFamily(pomes).addFruitFamily(prunes);
        Allele.fruitNone = new AlleleFruit("none", new FruitProviderNone("none", null));
        Allele.fruitApple = new AlleleFruit("apple", new FruitProviderRandom("apple", pomes, new ItemStack(Items.field_151034_e), 1.0f).setColour(0xFF2E2E).setOverlay("pomes"));
        Allele.fruitCocoa = new AlleleFruit("cocoa", new FruitProviderPod("cocoa", jungle, FruitProviderPod.EnumPodType.COCOA, new ItemStack[0]));
        Allele.fruitChestnut = new AlleleFruit("chestnut", new FruitProviderRipening("chestnut", nux, ItemFruit.EnumFruit.CHESTNUT.getStack(), 1.0f).setRipeningPeriod(6).setColours(8336189, 12898890).setOverlay("nuts"), true);
        Allele.fruitWalnut = new AlleleFruit("walnut", new FruitProviderRipening("walnut", nux, ItemFruit.EnumFruit.WALNUT.getStack(), 1.0f).setRipeningPeriod(8).setColours(16491080, 12898890).setOverlay("nuts"), true);
        Allele.fruitCherry = new AlleleFruit("cherry", new FruitProviderRipening("cherry", prunes, ItemFruit.EnumFruit.CHERRY.getStack(), 1.0f).setColours(0xFF2E2E, 12898890).setOverlay("berries"), true);
        Allele.fruitDates = new AlleleFruit("dates", new FruitProviderPod("dates", jungle, FruitProviderPod.EnumPodType.DATES, ItemFruit.EnumFruit.DATES.getStack(4)));
        Allele.fruitPapaya = new AlleleFruit("papaya", new FruitProviderPod("papaya", jungle, FruitProviderPod.EnumPodType.PAPAYA, ItemFruit.EnumFruit.PAPAYA.getStack()));
        Allele.fruitLemon = new AlleleFruit("lemon", new FruitProviderRipening("lemon", prunes, ItemFruit.EnumFruit.LEMON.getStack(), 1.0f).setColours(0xEEEE00, 0x99FF00).setOverlay("citrus"), true);
        Allele.fruitPlum = new AlleleFruit("plum", new FruitProviderRipening("plum", prunes, ItemFruit.EnumFruit.PLUM.getStack(), 1.0f).setColours(0x663446, 15662874).setOverlay("plums"), true);
        Allele.growthLightlevel = new AlleleGrowth("lightlevel", new GrowthProvider());
        Allele.growthAcacia = new AlleleGrowth("acacia", new GrowthProvider());
        Allele.growthTropical = new AlleleGrowth("tropical", new GrowthProviderTropical());
        Allele.leavesNone = new AlleleLeafEffectNone();
    }

    private static void registerTemplates() {
        treeInterface.registerTemplate(TreeTemplates.getOakTemplate());
        treeInterface.registerTemplate(TreeTemplates.getBirchTemplate());
        treeInterface.registerTemplate(TreeTemplates.getSpruceTemplate());
        treeInterface.registerTemplate(TreeTemplates.getJungleTemplate());
        treeInterface.registerTemplate(TreeTemplates.getAcaciaTemplate());
        treeInterface.registerTemplate(TreeTemplates.getDarkOakTemplate());
        treeInterface.registerTemplate(TreeTemplates.getLimeTemplate());
        treeInterface.registerTemplate(TreeTemplates.getCherryTemplate());
        treeInterface.registerTemplate(TreeTemplates.getChestnutTemplate());
        treeInterface.registerTemplate(TreeTemplates.getWalnutTemplate());
        treeInterface.registerTemplate(TreeTemplates.getLarchTemplate());
        treeInterface.registerTemplate(TreeTemplates.getPineTemplate());
        treeInterface.registerTemplate(TreeTemplates.getSequoiaTemplate());
        treeInterface.registerTemplate(TreeTemplates.getGiganteumTemplate());
        treeInterface.registerTemplate(TreeTemplates.getBalsaTemplate());
        treeInterface.registerTemplate(TreeTemplates.getDesertAcaciaTemplate());
        treeInterface.registerTemplate(TreeTemplates.getWengeTemplate());
        treeInterface.registerTemplate(TreeTemplates.getBaobabTemplate());
        treeInterface.registerTemplate(TreeTemplates.getPadaukTemplate());
        treeInterface.registerTemplate(TreeTemplates.getCocoboloTemplate());
        treeInterface.registerTemplate(TreeTemplates.getTeakTemplate());
        treeInterface.registerTemplate(TreeTemplates.getIpeTemplate());
        treeInterface.registerTemplate(TreeTemplates.getKapokTemplate());
        treeInterface.registerTemplate(TreeTemplates.getEbonyTemplate());
        treeInterface.registerTemplate(TreeTemplates.getZebrawoodTemplate());
        treeInterface.registerTemplate(TreeTemplates.getMahoganyTemplate());
        treeInterface.registerTemplate(TreeTemplates.getWillowTemplate());
        treeInterface.registerTemplate(TreeTemplates.getSipiriTemplate());
        treeInterface.registerTemplate(TreeTemplates.getMahoeTemplate());
        treeInterface.registerTemplate(TreeTemplates.getPoplarTemplate());
        treeInterface.registerTemplate(TreeTemplates.getLemonTemplate());
        treeInterface.registerTemplate(TreeTemplates.getPlumTemplate());
        treeInterface.registerTemplate(TreeTemplates.getMapleTemplate());
        treeInterface.registerTemplate(TreeTemplates.getPapayaTemplate());
        treeInterface.registerTemplate(TreeTemplates.getDateTemplate());
    }

    private static void registerErsatzGenomes() {
        AlleleManager.ersatzSpecimen.put(new ItemStack((Block)Blocks.field_150362_t, 1, 0), new Tree(TreeTemplates.templateAsGenome(TreeTemplates.getOakTemplate())));
        AlleleManager.ersatzSpecimen.put(new ItemStack((Block)Blocks.field_150362_t, 1, 1), new Tree(TreeTemplates.templateAsGenome(TreeTemplates.getSpruceTemplate())));
        AlleleManager.ersatzSpecimen.put(new ItemStack((Block)Blocks.field_150362_t, 1, 2), new Tree(TreeTemplates.templateAsGenome(TreeTemplates.getBirchTemplate())));
        AlleleManager.ersatzSpecimen.put(new ItemStack((Block)Blocks.field_150362_t, 1, 3), new Tree(TreeTemplates.templateAsGenome(TreeTemplates.getJungleTemplate())));
        AlleleManager.ersatzSpecimen.put(new ItemStack((Block)Blocks.field_150361_u, 1, 0), new Tree(TreeTemplates.templateAsGenome(TreeTemplates.getAcaciaTemplate())));
        AlleleManager.ersatzSpecimen.put(new ItemStack((Block)Blocks.field_150361_u, 1, 1), new Tree(TreeTemplates.templateAsGenome(TreeTemplates.getDarkOakTemplate())));
        AlleleManager.ersatzSaplings.put(new ItemStack(Blocks.field_150345_g, 1, 0), new Tree(TreeTemplates.templateAsGenome(TreeTemplates.getOakTemplate())));
        AlleleManager.ersatzSaplings.put(new ItemStack(Blocks.field_150345_g, 1, 1), new Tree(TreeTemplates.templateAsGenome(TreeTemplates.getSpruceTemplate())));
        AlleleManager.ersatzSaplings.put(new ItemStack(Blocks.field_150345_g, 1, 2), new Tree(TreeTemplates.templateAsGenome(TreeTemplates.getBirchTemplate())));
        AlleleManager.ersatzSaplings.put(new ItemStack(Blocks.field_150345_g, 1, 3), new Tree(TreeTemplates.templateAsGenome(TreeTemplates.getJungleTemplate())));
        AlleleManager.ersatzSaplings.put(new ItemStack(Blocks.field_150345_g, 1, 4), new Tree(TreeTemplates.templateAsGenome(TreeTemplates.getAcaciaTemplate())));
        AlleleManager.ersatzSaplings.put(new ItemStack(Blocks.field_150345_g, 1, 5), new Tree(TreeTemplates.templateAsGenome(TreeTemplates.getDarkOakTemplate())));
    }

    private static void createMutations() {
        TreeTemplates.limeA = new TreeMutation(Allele.treeBirch, Allele.treeOak, TreeTemplates.getLimeTemplate(), 15);
        TreeTemplates.mapleA = new TreeMutation(Allele.treeSpruce, Allele.treeLarch, TreeTemplates.getMapleTemplate(), 5);
        TreeTemplates.cherryA = new TreeMutation(Allele.treeLime, Allele.treeOak, TreeTemplates.getCherryTemplate(), 10);
        TreeTemplates.cherryB = new TreeMutation(Allele.treeLime, Allele.treeBirch, TreeTemplates.getCherryTemplate(), 10);
        TreeTemplates.lemonA = new TreeMutation(Allele.treeLime, Allele.treeCherry, TreeTemplates.getLemonTemplate(), 5);
        TreeTemplates.plumA = new TreeMutation(Allele.treeLemon, Allele.treeCherry, TreeTemplates.getPlumTemplate(), 5);
        TreeTemplates.walnutA = new TreeMutation(Allele.treeLime, Allele.treeCherry, TreeTemplates.getWalnutTemplate(), 10);
        TreeTemplates.chestnutA = new TreeMutation(Allele.treeWalnut, Allele.treeLime, TreeTemplates.getChestnutTemplate(), 10);
        TreeTemplates.chestnutB = new TreeMutation(Allele.treeWalnut, Allele.treeCherry, TreeTemplates.getChestnutTemplate(), 10);
        TreeTemplates.larchA = new TreeMutation(Allele.treeSpruce, Allele.treeBirch, TreeTemplates.getLarchTemplate(), 10);
        TreeTemplates.larchB = new TreeMutation(Allele.treeSpruce, Allele.treeOak, TreeTemplates.getLarchTemplate(), 10);
        TreeTemplates.pineA = new TreeMutation(Allele.treeSpruce, Allele.treeLarch, TreeTemplates.getPineTemplate(), 10);
        TreeTemplates.sequoiaA = new TreeMutation(Allele.treeLarch, Allele.treePine, TreeTemplates.getSequoiaTemplate(), 5);
        TreeTemplates.teakA = new TreeMutation(Allele.treeDarkOak, Allele.treeJungle, TreeTemplates.getTeakTemplate(), 10);
        TreeTemplates.ipeA = new TreeMutation(Allele.treeTeak, Allele.treeDarkOak, TreeTemplates.getIpeTemplate(), 10);
        TreeTemplates.kapokA = new TreeMutation(Allele.treeJungle, Allele.treeTeak, TreeTemplates.getKapokTemplate(), 10);
        TreeTemplates.ebonyA = new TreeMutation(Allele.treeDarkOak, Allele.treeKapok, TreeTemplates.getEbonyTemplate(), 10);
        TreeTemplates.zebrawoodA = new TreeMutation(Allele.treeEbony, Allele.treePoplar, TreeTemplates.getZebrawoodTemplate(), 5);
        TreeTemplates.mahoganyA = new TreeMutation(Allele.treeKapok, Allele.treeEbony, TreeTemplates.getMahoganyTemplate(), 10);
        TreeTemplates.papayaA = new TreeMutation(Allele.treeJungle, Allele.treeCherry, TreeTemplates.getPapayaTemplate(), 5);
        TreeTemplates.dateA = new TreeMutation(Allele.treeJungle, Allele.treePapaya, TreeTemplates.getDateTemplate(), 5);
        TreeTemplates.balsaA = new TreeMutation(Allele.treeTeak, Allele.treeAcacia, TreeTemplates.getBalsaTemplate(), 10);
        TreeTemplates.acaciaA = new TreeMutation(Allele.treeTeak, Allele.treeBalsa, TreeTemplates.getDesertAcaciaTemplate(), 10);
        TreeTemplates.padaukA = new TreeMutation(Allele.treeAcacia, Allele.treeJungle, TreeTemplates.getPadaukTemplate(), 10);
        TreeTemplates.cocoboloA = new TreeMutation(Allele.treeDesertAcacia, Allele.treeDarkOak, TreeTemplates.getCocoboloTemplate(), 10);
        TreeTemplates.wengeA = new TreeMutation(Allele.treeCocobolo, Allele.treeBalsa, TreeTemplates.getWengeTemplate(), 10);
        TreeTemplates.baobabA = new TreeMutation(Allele.treeBalsa, Allele.treeWenge, TreeTemplates.getBaobabTemplate(), 10);
        TreeTemplates.mahoeA = new TreeMutation(Allele.treeBalsa, Allele.treeDesertAcacia, TreeTemplates.getMahoeTemplate(), 5);
        TreeTemplates.willowA = new TreeMutation(Allele.treeOak, Allele.treeBirch, TreeTemplates.getWillowTemplate(), 10).restrictTemperature(EnumTemperature.WARM, EnumTemperature.HOT).restrictHumidity(EnumHumidity.DAMP);
        TreeTemplates.willowB = new TreeMutation(Allele.treeOak, Allele.treeLime, TreeTemplates.getWillowTemplate(), 10).restrictTemperature(EnumTemperature.WARM, EnumTemperature.HOT).restrictHumidity(EnumHumidity.DAMP);
        TreeTemplates.willowC = new TreeMutation(Allele.treeLime, Allele.treeBirch, TreeTemplates.getWillowTemplate(), 10).restrictTemperature(EnumTemperature.WARM, EnumTemperature.HOT).restrictHumidity(EnumHumidity.DAMP);
        TreeTemplates.sipiriA = new TreeMutation(Allele.treeKapok, Allele.treeMahogany, TreeTemplates.getSipiriTemplate(), 10).restrictTemperature(EnumTemperature.WARM, EnumTemperature.HOT).restrictHumidity(EnumHumidity.DAMP);
        TreeTemplates.poplarA = new TreeMutation(Allele.treeBirch, Allele.treeWillow, TreeTemplates.getPoplarTemplate(), 5);
        TreeTemplates.poplarB = new TreeMutation(Allele.treeOak, Allele.treeWillow, TreeTemplates.getPoplarTemplate(), 5);
        TreeTemplates.poplarB = new TreeMutation(Allele.treeLime, Allele.treeWillow, TreeTemplates.getPoplarTemplate(), 5);
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return new GuiHandlerArboriculture();
    }

    @Override
    public IFuelHandler getFuelHandler() {
        return new FuelHandler();
    }

    @Override
    public IPacketHandler getPacketHandler() {
        return new PacketHandlerArboriculture();
    }

    @Override
    public boolean processIMCMessage(FMLInterModComms.IMCMessage message) {
        if (message.key.equals("add-fence-block") && message.isStringMessage()) {
            Block block = (Block)GameData.getBlockRegistry().getRaw(message.getStringValue());
            if (block != null && block != Blocks.field_150350_a) {
                validFences.add(block);
            } else {
                PluginArboriculture.logInvalidIMCMessage(message);
            }
            return true;
        }
        return super.processIMCMessage(message);
    }

    private static void registerDungeonLoot() {
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(ForestryItem.grafter.getItemStack(), 1, 1, 8));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(PluginArboriculture.getTreeItemFromTemplate(TreeTemplates.getOakTemplate(), EnumGermlingType.SAPLING), 2, 3, 6));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(PluginArboriculture.getTreeItemFromTemplate(TreeTemplates.getSpruceTemplate(), EnumGermlingType.SAPLING), 2, 3, 6));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(PluginArboriculture.getTreeItemFromTemplate(TreeTemplates.getBirchTemplate(), EnumGermlingType.SAPLING), 2, 3, 6));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(PluginArboriculture.getTreeItemFromTemplate(TreeTemplates.getLarchTemplate(), EnumGermlingType.SAPLING), 1, 2, 4));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(PluginArboriculture.getTreeItemFromTemplate(TreeTemplates.getLimeTemplate(), EnumGermlingType.SAPLING), 1, 2, 4));
        if (PluginManager.Module.APICULTURE.isEnabled()) {
            ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(PluginArboriculture.getTreeItemFromTemplate(TreeTemplates.getOakTemplate(), EnumGermlingType.POLLEN), 2, 3, 4));
            ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(PluginArboriculture.getTreeItemFromTemplate(TreeTemplates.getSpruceTemplate(), EnumGermlingType.POLLEN), 2, 3, 4));
            ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(PluginArboriculture.getTreeItemFromTemplate(TreeTemplates.getBirchTemplate(), EnumGermlingType.POLLEN), 2, 3, 4));
            ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(PluginArboriculture.getTreeItemFromTemplate(TreeTemplates.getLarchTemplate(), EnumGermlingType.POLLEN), 1, 2, 3));
            ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(PluginArboriculture.getTreeItemFromTemplate(TreeTemplates.getLimeTemplate(), EnumGermlingType.POLLEN), 1, 2, 3));
        }
    }

    private static ItemStack getTreeItemFromTemplate(IAllele[] template, EnumGermlingType type) {
        ItemStack treeItem;
        Tree tree = new Tree(treeInterface.templateAsGenome(template));
        switch (type) {
            default: {
                treeItem = ForestryItem.pollenFertile.getItemStack();
                break;
            }
            case SAPLING: {
                treeItem = ForestryItem.sapling.getItemStack();
            }
        }
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        tree.writeToNBT(nbtTagCompound);
        treeItem.func_77982_d(nbtTagCompound);
        return treeItem;
    }

    static {
        treekeepingMode = "NORMAL";
        validFences = new ArrayList<Block>();
        logs = EnumSet.of(ForestryBlock.log1, new ForestryBlock[]{ForestryBlock.log2, ForestryBlock.log3, ForestryBlock.log4, ForestryBlock.log5, ForestryBlock.log6, ForestryBlock.log7, ForestryBlock.log8});
        fireproofLogs = EnumSet.of(ForestryBlock.fireproofLog1, new ForestryBlock[]{ForestryBlock.fireproofLog2, ForestryBlock.fireproofLog3, ForestryBlock.fireproofLog4, ForestryBlock.fireproofLog5, ForestryBlock.fireproofLog6, ForestryBlock.fireproofLog7, ForestryBlock.fireproofLog8});
        planks = EnumSet.of(ForestryBlock.planks1, ForestryBlock.planks2);
        fireproofPlanks = EnumSet.of(ForestryBlock.fireproofPlanks1, ForestryBlock.fireproofPlanks2);
        slabs = EnumSet.of(ForestryBlock.slabs1, ForestryBlock.slabs2, ForestryBlock.slabs3, ForestryBlock.slabs4);
        fences = EnumSet.of(ForestryBlock.fences1, ForestryBlock.fences2);
    }

    private static class FuelHandler
    implements IFuelHandler {
        private FuelHandler() {
        }

        public int getBurnTime(ItemStack fuel) {
            if (ForestryItem.sapling.isItemEqual(fuel)) {
                return 100;
            }
            for (ForestryBlock slab : slabs) {
                if (!slab.isItemEqual(fuel)) continue;
                return 150;
            }
            return 0;
        }
    }
}

