/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.farming.Farmables;
import forestry.core.circuits.Circuit;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.proxy.Proxies;
import forestry.farming.circuits.CircuitFarmLogic;
import forestry.farming.logic.FarmLogicEnder;
import forestry.farming.logic.FarmableGenericCrop;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.Plugin;
import forestry.plugins.PluginManager;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

@Plugin(pluginID="ExtraUtilities", name="ExtraUtilities", author="Nirek", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.extrautilities.description")
public class PluginExtraUtilities
extends ForestryPlugin {
    private static final String ExU = "ExtraUtilities";
    public static Block ExUEnderLilly;

    @Override
    public boolean isAvailable() {
        return Proxies.common.isModLoaded(ExU);
    }

    @Override
    public String getFailMessage() {
        return "ExtraUtilities not found";
    }

    @Override
    public void doInit() {
        super.doInit();
        ExUEnderLilly = GameRegistry.findBlock((String)ExU, (String)"plant/ender_lilly");
        Farmables.farmables.put("farmEnder", new ArrayList());
        if (Config.isExUtilEnderLilyEnabled()) {
            Circuit.farmEnderManaged = new CircuitFarmLogic("managedEnder", FarmLogicEnder.class);
            Farmables.farmables.get("farmEnder").add(new FarmableGenericCrop(new ItemStack(ExUEnderLilly, 1, 0), ExUEnderLilly, 7));
        }
    }

    @Override
    protected void registerRecipes() {
        super.registerRecipes();
        if (PluginManager.Module.FARMING.isEnabled() && Config.isExUtilEnderLilyEnabled()) {
            ICircuitLayout layoutManaged = ChipsetManager.circuitRegistry.getLayout("forestry.farms.managed");
            ChipsetManager.solderManager.addRecipe(layoutManaged, ForestryItem.tubes.getItemStack(1, 12), Circuit.farmEnderManaged);
        }
    }
}

