/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.network.IGuiHandler;
import forestry.api.food.BeverageManager;
import forestry.api.food.IBeverageEffect;
import forestry.core.config.ForestryItem;
import forestry.core.fluids.Fluids;
import forestry.core.items.ItemForestryFood;
import forestry.core.proxy.Proxies;
import forestry.core.utils.LiquidHelper;
import forestry.food.BeverageEffect;
import forestry.food.GuiHandlerFood;
import forestry.food.items.ItemAmbrosia;
import forestry.food.items.ItemBeverage;
import forestry.food.items.ItemInfuser;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.Plugin;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@Plugin(pluginID="Food", name="Food", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.food.description")
public class PluginFood
extends ForestryPlugin {
    @Override
    protected void setupAPI() {
        super.setupAPI();
        BeverageManager.infuserManager = new ItemInfuser.MixtureManager();
        BeverageManager.ingredientManager = new ItemInfuser.IngredientManager();
    }

    @Override
    public void postInit() {
        super.postInit();
        ItemInfuser.initialize();
    }

    @Override
    protected void registerItems() {
        ForestryItem.honeyedSlice.registerItem((Item)new ItemForestryFood(8, 0.6f), "honeyedSlice");
        ForestryItem.beverage.registerItem((Item)new ItemBeverage(new ItemBeverage.BeverageInfo("meadShort", "glass", 15505945, 0xFFFFFF, 1, 0.2f, true), new ItemBeverage.BeverageInfo("meadCurative", "glass", 12975871, 0xFFFFFF, 1, 0.2f, true)), "beverage");
        ForestryItem.ambrosia.registerItem((Item)new ItemAmbrosia().setIsDrink(), "ambrosia");
        ForestryItem.honeyPot.registerItem((Item)new ItemForestryFood(2, 0.2f).setIsDrink(), "honeyPot");
        ForestryItem.infuser.registerItem(new ItemInfuser(), "infuser");
        ItemStack meadBottle = ForestryItem.beverage.getItemStack();
        ((ItemBeverage)ForestryItem.beverage.item()).beverages[0].saveEffects(meadBottle, new IBeverageEffect[]{BeverageEffect.weakAlcoholic});
        LiquidHelper.injectLiquidContainer(Fluids.SHORT_MEAD, 1000, meadBottle, new ItemStack(Items.field_151069_bo));
    }

    @Override
    protected void registerRecipes() {
        Proxies.common.addRecipe(ForestryItem.infuser.getItemStack(), "X", "#", "X", Character.valueOf('#'), Items.field_151042_j, Character.valueOf('X'), "ingotBronze");
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return new GuiHandlerFood();
    }
}

