/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.registry.GameData;
import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.GeneratorFuel;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.BackpackManager;
import forestry.api.storage.IBackpackDefinition;
import forestry.api.storage.ICrateRegistry;
import forestry.api.storage.StorageManager;
import forestry.core.GameMode;
import forestry.core.circuits.Circuit;
import forestry.core.circuits.CircuitLayout;
import forestry.core.config.Config;
import forestry.core.config.Configuration;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.fluids.Fluids;
import forestry.core.gadgets.BlockBase;
import forestry.core.gadgets.MachineDefinition;
import forestry.core.proxy.Proxies;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.RecipeUtil;
import forestry.core.utils.ShapedRecipeCustom;
import forestry.core.utils.StackUtils;
import forestry.energy.circuits.CircuitElectricBoost;
import forestry.energy.circuits.CircuitElectricChoke;
import forestry.energy.circuits.CircuitElectricEfficiency;
import forestry.energy.circuits.CircuitFireDampener;
import forestry.energy.gadgets.EngineDefinition;
import forestry.energy.gadgets.EngineTin;
import forestry.energy.gadgets.MachineGenerator;
import forestry.farming.circuits.CircuitFarmLogic;
import forestry.farming.logic.FarmLogicRubber;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.Plugin;
import forestry.plugins.PluginEnergy;
import forestry.plugins.PluginManager;
import ic2.api.item.IC2Items;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.Recipes;
import java.util.EnumSet;
import java.util.Map;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

@Plugin(pluginID="IC2", name="IndustrialCraft2", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.ic2.description")
public class PluginIC2
extends ForestryPlugin {
    public static PluginIC2 instance;
    public static Configuration config;
    public static boolean ignore;
    public static MachineDefinition definitionGenerator;
    public static MachineDefinition definitionEngineTin;
    public static ItemStack plantBall;
    public static ItemStack compressedPlantBall;
    public static ItemStack wrench;
    public static ItemStack treetap;
    public static ItemStack resin;
    public static ItemStack rubbersapling;
    public static ItemStack rubberwood;
    public static ItemStack rubberleaves;
    public static ItemStack emptyCell;
    public static ItemStack lavaCell;
    public static ItemStack waterCell;
    public static ItemStack rubber;
    public static ItemStack scrap;
    public static ItemStack silver;
    public static ItemStack brass;
    public static ItemStack uuMatter;

    public PluginIC2() {
        if (instance == null) {
            instance = this;
        }
    }

    @Override
    public boolean isAvailable() {
        return Proxies.common.isModLoaded("IC2");
    }

    @Override
    public String getFailMessage() {
        return "IndustrialCraft2 not found";
    }

    @Override
    public EnumSet<PluginManager.Module> getDependancies() {
        EnumSet<PluginManager.Module> deps = super.getDependancies();
        deps.add(PluginManager.Module.FARMING);
        deps.add(PluginManager.Module.FACTORY);
        deps.add(PluginManager.Module.ENERGY);
        return deps;
    }

    @Override
    @Optional.Method(modid="IC2")
    public void preInit() {
        super.preInit();
        definitionEngineTin = ((BlockBase)ForestryBlock.engine.block()).addDefinition(new EngineDefinition(0, "forestry.EngineTin", EngineTin.class, PluginEnergy.proxy.getRenderDefaultEngine("textures/blocks/engine_tin_"), ShapedRecipeCustom.createShapedRecipe(ForestryBlock.engine.getItemStack(1, 0), "###", " X ", "YVY", Character.valueOf('#'), "ingotTin", Character.valueOf('X'), Blocks.field_150359_w, Character.valueOf('Y'), "gearTin", Character.valueOf('V'), Blocks.field_150331_J)));
        definitionGenerator = ((BlockBase)ForestryBlock.engine.block()).addDefinition(new MachineDefinition(3, "forestry.Generator", MachineGenerator.class, Proxies.render.getRenderDefaultMachine("textures/blocks/generator_"), ShapedRecipeCustom.createShapedRecipe(ForestryBlock.engine.getItemStack(1, 3), new Object[]{"X#X", "XYX", "X#X", Character.valueOf('#'), Blocks.field_150359_w, Character.valueOf('X'), Items.field_151043_k, Character.valueOf('Y'), ForestryItem.sturdyCasing})));
        emptyCell = IC2Items.getItem((String)"cell");
        if (emptyCell != null) {
            lavaCell = IC2Items.getItem((String)"lavaCell");
            waterCell = IC2Items.getItem((String)"waterCell");
        } else {
            Proxies.log.fine("IC2 empty cell could not be found. Skipped adding IC2 liquid containers.");
        }
        treetap = IC2Items.getItem((String)"treetap");
        rubberwood = IC2Items.getItem((String)"rubberWood");
        resin = IC2Items.getItem((String)"resin");
        rubbersapling = IC2Items.getItem((String)"rubberSapling");
        rubberleaves = IC2Items.getItem((String)"rubberLeaves");
        plantBall = IC2Items.getItem((String)"plantBall");
        compressedPlantBall = IC2Items.getItem((String)"compressedPlantBall");
        resin = IC2Items.getItem((String)"resin");
        rubber = IC2Items.getItem((String)"rubber");
        scrap = IC2Items.getItem((String)"scrap");
        uuMatter = IC2Items.getItem((String)"matter");
        silver = IC2Items.getItem((String)"silverIngot");
        brass = IC2Items.getItem((String)"bronzeIngot");
        Circuit.farmRubberManual = new CircuitFarmLogic("manualRubber", FarmLogicRubber.class);
        CircuitLayout layoutEngineTin = new CircuitLayout("engine.tin");
        ChipsetManager.circuitRegistry.registerLayout(layoutEngineTin);
    }

    @Override
    @Optional.Method(modid="IC2")
    public void doInit() {
        super.doInit();
        config = Config.config;
        if (Recipes.recyclerBlacklist != null) {
            if (PluginManager.Module.APICULTURE.isEnabled()) {
                Recipes.recyclerBlacklist.add((IRecipeInput)new RecipeInputItemStack(ForestryItem.beeQueenGE.getItemStack()));
                Recipes.recyclerBlacklist.add((IRecipeInput)new RecipeInputItemStack(ForestryItem.beePrincessGE.getItemStack()));
            }
        } else {
            Proxies.log.severe("IC2 Recipes.recyclerBlacklist not found.");
        }
        definitionEngineTin.register();
        definitionGenerator.register();
        FluidStack ethanol = Fluids.ETHANOL.getFluid(1);
        GeneratorFuel ethanolFuel = new GeneratorFuel(ethanol, (int)(32.0f * GameMode.getGameMode().getFloatSetting("fuel.ethanol.generator")), 4);
        FuelManager.generatorFuel.put(ethanol.getFluid(), ethanolFuel);
        FluidStack biomass = Fluids.BIOMASS.getFluid(1);
        GeneratorFuel biomassFuel = new GeneratorFuel(biomass, (int)(8.0f * GameMode.getGameMode().getFloatSetting("fuel.biomass.generator")), 1);
        FuelManager.generatorFuel.put(biomass.getFluid(), biomassFuel);
        Circuit.energyElectricChoke1 = new CircuitElectricChoke("electric.choke.1");
        Circuit.energyFireDampener1 = new CircuitFireDampener("dampener.1");
        Circuit.energyElectricEfficiency1 = new CircuitElectricEfficiency("electric.efficiency.1");
        Circuit.energyElectricBoost1 = new CircuitElectricBoost("electric.boost.1", 2, 7, 20);
        Circuit.energyElectricBoost2 = new CircuitElectricBoost("electric.boost.2", 2, 15, 40);
    }

    @Override
    @Optional.Method(modid="IC2")
    protected void registerBackpackItems() {
        if (BackpackManager.definitions == null) {
            return;
        }
        IBackpackDefinition forester = BackpackManager.definitions.get("forester");
        if (resin != null) {
            forester.addValidItem(resin);
        }
        if (rubber != null) {
            forester.addValidItem(rubber);
        }
        if (rubbersapling != null) {
            forester.addValidItem(rubbersapling);
        }
        if (rubberleaves != null) {
            forester.addValidItem(rubberleaves);
        }
    }

    @Override
    @Optional.Method(modid="IC2")
    protected void registerCrates() {
        ICrateRegistry crateRegistry = StorageManager.crateRegistry;
        if (resin != null) {
            crateRegistry.registerCrate(resin, "cratedResin");
        }
        if (rubber != null) {
            crateRegistry.registerCrate(rubber, "cratedRubber");
        }
        if (scrap != null) {
            crateRegistry.registerCrate(scrap, "cratedScrap");
        }
        if (uuMatter != null) {
            crateRegistry.registerCrate(uuMatter, "cratedUUM");
        }
        if (silver != null) {
            crateRegistry.registerCrateUsingOreDict(silver, "cratedSilver");
        }
        if (brass != null) {
            crateRegistry.registerCrateUsingOreDict(brass, "cratedBrass");
        }
    }

    @Override
    @Optional.Method(modid="IC2")
    protected void registerRecipes() {
        if (rubber != null) {
            for (Object rubberOreDict : RecipeUtil.getOreDictRecipeEquivalents(rubber)) {
                RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), ForestryItem.tubes.getItemStack(4, 8), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), Items.field_151137_ax, Character.valueOf('X'), rubberOreDict});
            }
        }
        if (plantBall != null) {
            RecipeUtil.injectLeveledRecipe(plantBall, GameMode.getGameMode().getIntegerSetting("fermenter.yield.wheat") * 9, Fluids.BIOMASS);
        }
        if (compressedPlantBall != null) {
            RecipeUtil.injectLeveledRecipe(compressedPlantBall, GameMode.getGameMode().getIntegerSetting("fermenter.yield.wheat") * 9, Fluids.BIOMASS);
        }
        if (resin != null) {
            RecipeManagers.centrifugeManager.addRecipe(20, ForestryItem.propolis.getItemStack(), (Map<ItemStack, Float>)ImmutableMap.of((Object)resin, (Object)Float.valueOf(1.0f)));
        } else {
            Proxies.log.fine("Missing IC2 resin, skipping centrifuge recipe for propolis to resin.");
        }
        if (rubbersapling != null) {
            RecipeUtil.injectLeveledRecipe(rubbersapling, GameMode.getGameMode().getIntegerSetting("fermenter.yield.sapling"), Fluids.BIOMASS);
        } else {
            Proxies.log.fine("Missing IC2 rubber sapling, skipping fermenter recipe for converting rubber sapling to biomass.");
        }
        if (rubbersapling != null && resin != null) {
            String saplingName = GameData.getBlockRegistry().func_148750_c((Object)StackUtils.getBlock(rubbersapling));
            String resinName = GameData.getItemRegistry().func_148750_c((Object)resin.func_77973_b());
            String imc = String.format("farmArboreal@%s.%s.%s.%s", saplingName, rubbersapling.func_77960_j(), resinName, resin.func_77960_j());
            Proxies.log.finest("Sending IMC '%s'.", (Object)imc);
            FMLInterModComms.sendMessage((String)"Forestry", (String)"add-farmable-sapling", (String)imc);
        }
        if (lavaCell != null) {
            LiquidHelper.injectTinContainer(Fluids.LAVA, 1000, lavaCell, emptyCell);
        }
        if (waterCell != null) {
            LiquidHelper.injectTinContainer(Fluids.WATER, 1000, waterCell, emptyCell);
            ItemStack bogEarthCan = GameMode.getGameMode().getStackSetting("recipe.output.bogearth.can");
            if (bogEarthCan.field_77994_a > 0) {
                Proxies.common.addRecipe(bogEarthCan, "#Y#", "YXY", "#Y#", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), waterCell, Character.valueOf('Y'), Blocks.field_150354_m);
            }
        }
        ICircuitLayout layout = ChipsetManager.circuitRegistry.getLayout("forestry.engine.tin");
        ChipsetManager.solderManager.addRecipe(layout, ForestryItem.tubes.getItemStack(1, 0), Circuit.energyElectricChoke1);
        ChipsetManager.solderManager.addRecipe(layout, ForestryItem.tubes.getItemStack(1, 1), Circuit.energyElectricBoost1);
        ChipsetManager.solderManager.addRecipe(layout, ForestryItem.tubes.getItemStack(1, 2), Circuit.energyElectricBoost2);
        ChipsetManager.solderManager.addRecipe(layout, ForestryItem.tubes.getItemStack(1, 3), Circuit.energyElectricEfficiency1);
        if (PluginManager.Module.FARMING.isEnabled() && resin != null && rubberwood != null) {
            ICircuitLayout layoutManual = ChipsetManager.circuitRegistry.getLayout("forestry.farms.manual");
            ChipsetManager.solderManager.addRecipe(layoutManual, ForestryItem.tubes.getItemStack(1, 8), Circuit.farmRubberManual);
        }
    }
}

