/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.network.IGuiHandler;
import forestry.api.arboriculture.ITreeRoot;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.Tabs;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IClassification;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.IAlleleButterflySpecies;
import forestry.api.lepidopterology.IButterflyRoot;
import forestry.api.recipes.RecipeManagers;
import forestry.core.config.Configuration;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.config.Property;
import forestry.core.fluids.Fluids;
import forestry.core.gadgets.BlockBase;
import forestry.core.gadgets.MachineDefinition;
import forestry.core.genetics.Branch;
import forestry.core.genetics.alleles.Allele;
import forestry.core.genetics.alleles.AlleleSpecies;
import forestry.core.items.ItemForestryBlock;
import forestry.core.utils.ShapedRecipeCustom;
import forestry.core.utils.Utils;
import forestry.lepidopterology.ButterflySpawner;
import forestry.lepidopterology.GuiHandlerLepidopterology;
import forestry.lepidopterology.MatingRecipe;
import forestry.lepidopterology.commands.CommandButterfly;
import forestry.lepidopterology.entities.EntityButterfly;
import forestry.lepidopterology.gadgets.TileLepidopteristChest;
import forestry.lepidopterology.genetics.AlleleButterflySpecies;
import forestry.lepidopterology.genetics.AlleleEffectNone;
import forestry.lepidopterology.genetics.ButterflyHelper;
import forestry.lepidopterology.genetics.ButterflyTemplates;
import forestry.lepidopterology.items.ItemButterflyGE;
import forestry.lepidopterology.items.ItemFlutterlyzer;
import forestry.lepidopterology.proxy.ProxyLepidopterology;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.Plugin;
import forestry.plugins.PluginCore;
import forestry.plugins.PluginManager;
import java.util.EnumSet;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.oredict.RecipeSorter;

@Plugin(pluginID="Lepidopterology", name="Lepidopterology", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.lepidopterology.description")
public class PluginLepidopterology
extends ForestryPlugin {
    @SidedProxy(clientSide="forestry.lepidopterology.proxy.ClientProxyLepidopterology", serverSide="forestry.lepidopterology.proxy.ProxyLepidopterology")
    public static ProxyLepidopterology proxy;
    private static final String CONFIG_CATEGORY = "lepidopterology";
    private Configuration config;
    public static int spawnConstraint;
    public static int entityConstraint;
    private static boolean allowPollination;
    public static IClassification geometridae;
    public static IClassification saturniidae;
    public static IClassification pieridae;
    public static IClassification nymphalidae;
    public static IClassification lycaenidae;
    public static IClassification papilionidae;
    public static IClassification notchidae;
    public static IButterflyRoot butterflyInterface;
    public static MachineDefinition definitionChest;

    @Override
    protected void setupAPI() {
        super.setupAPI();
        butterflyInterface = new ButterflyHelper();
        AlleleManager.alleleRegistry.registerSpeciesRoot(butterflyInterface);
    }

    @Override
    public void preInit() {
        ForestryBlock.lepidopterology.registerBlock((Block)new BlockBase(Material.field_151573_f), ItemForestryBlock.class, CONFIG_CATEGORY);
        ForestryBlock.lepidopterology.block().func_149647_a(Tabs.tabLepidopterology);
        PluginLepidopterology.createAlleles();
    }

    @Override
    public EnumSet<PluginManager.Module> getDependancies() {
        EnumSet<PluginManager.Module> deps = super.getDependancies();
        deps.add(PluginManager.Module.ARBORICULTURE);
        return deps;
    }

    @Override
    public void doInit() {
        this.config = new Configuration();
        Property property = this.config.get("entities.spawn.limit", CONFIG_CATEGORY, spawnConstraint);
        property.comment = "determines the global butterfly entity count above which natural spawning of butterflies ceases.";
        spawnConstraint = Integer.parseInt(property.value);
        property = this.config.get("entities.maximum.allowed", CONFIG_CATEGORY, entityConstraint);
        property.comment = "determines the global butterfly entity count above which butterflies will stay in item form and will not take flight anymore.";
        entityConstraint = Integer.parseInt(property.value);
        property = this.config.get("entities.pollination.allowed", CONFIG_CATEGORY, allowPollination);
        property.comment = "determines whether butterflies can pollinate leaves.";
        allowPollination = Boolean.parseBoolean(property.value);
        this.config.save();
        PluginCore.rootCommand.addChildCommand(new CommandButterfly());
        Utils.registerEntity(EntityButterfly.class, "butterflyGE", 0, 0, 0xFFFFFF, 50, 1, true);
        proxy.initializeRendering();
        PluginLepidopterology.registerTemplates();
        BlockBase lepidopterology = (BlockBase)ForestryBlock.lepidopterology.block();
        definitionChest = lepidopterology.addDefinition(new MachineDefinition(0, "forestry.LepiChest", TileLepidopteristChest.class, ShapedRecipeCustom.createShapedRecipe(ForestryBlock.lepidopterology.getItemStack(1, 0), " # ", "XYX", "XXX", Character.valueOf('#'), Blocks.field_150359_w, Character.valueOf('X'), ForestryItem.butterflyGE.getItemStack(1, Short.MAX_VALUE), Character.valueOf('Y'), Blocks.field_150486_ae)).setFaces(0, 1, 2, 3, 4, 4, 0, 7));
        definitionChest.register();
        ((ITreeRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootTrees")).registerLeafTickHandler(new ButterflySpawner());
        RecipeSorter.register((String)"forestry:lepidopterologymating", MatingRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"before:minecraft:shapeless");
    }

    @Override
    protected void registerItems() {
        ForestryItem.flutterlyzer.registerItem(new ItemFlutterlyzer(), "flutterlyzer");
        ForestryItem.butterflyGE.registerItem(new ItemButterflyGE(EnumFlutterType.BUTTERFLY), "butterflyGE");
        ForestryItem.serumGE.registerItem(new ItemButterflyGE(EnumFlutterType.SERUM), "serumGE");
        ForestryItem.caterpillarGE.registerItem(new ItemButterflyGE(EnumFlutterType.CATERPILLAR), "caterpillarGE");
    }

    @Override
    protected void registerRecipes() {
        CraftingManager.func_77594_a().func_77592_b().add(new MatingRecipe());
        RecipeManagers.carpenterManager.addRecipe(100, Fluids.WATER.getFluid(2000), null, ForestryItem.flutterlyzer.getItemStack(), "X#X", "X#X", "RDR", Character.valueOf('#'), Blocks.field_150410_aZ, Character.valueOf('X'), "ingotBronze", Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('D'), Items.field_151045_i);
    }

    private static void createAlleles() {
        IClassification lepidoptera = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "lepidoptera", "Lepidoptera");
        AlleleManager.alleleRegistry.getClassification("class.insecta").addMemberGroup(lepidoptera);
        geometridae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "geometridae", "Geometridae");
        lepidoptera.addMemberGroup(geometridae);
        saturniidae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "saturniidae", "Saturniidae");
        lepidoptera.addMemberGroup(saturniidae);
        pieridae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "pieridae", "Pieridae");
        lepidoptera.addMemberGroup(pieridae);
        nymphalidae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "nymphalidae", "Nymphalidae");
        lepidoptera.addMemberGroup(nymphalidae);
        lycaenidae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "lycaenidae", "Lycaenidae");
        lepidoptera.addMemberGroup(lycaenidae);
        papilionidae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "papilionidae", "Papilionidae");
        lepidoptera.addMemberGroup(papilionidae);
        notchidae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "notchidae", "Notchidae");
        lepidoptera.addMemberGroup(notchidae);
        IClassification opisthograptis = PluginLepidopterology.createButterflyBranch(geometridae, "Opisthograptis");
        IClassification chiasmia = PluginLepidopterology.createButterflyBranch(geometridae, "Chiasmia");
        Allele.mothBrimstone = new AlleleButterflySpecies("mothBrimstone", true, "brimstone", opisthograptis, "luteolata", 16771648).setNocturnal(true).setRarity(1.0f);
        Allele.mothLatticedHeath = new AlleleButterflySpecies("mothLatticedHeath", true, "latticedHeath", chiasmia, "clathrata", 15921342).setNocturnal(true).setRarity(0.5f);
        IClassification attacus = PluginLepidopterology.createButterflyBranch(saturniidae, "Attacus");
        Allele.mothAtlas = new AlleleButterflySpecies("mothAtlas", false, "atlas", attacus, "atlas", 14249533).setNocturnal(true);
        IClassification pieris = PluginLepidopterology.createButterflyBranch(pieridae, "Pieris");
        IClassification gonepteryx = PluginLepidopterology.createButterflyBranch(pieridae, "Gonepteryx");
        IClassification anthocharis = PluginLepidopterology.createButterflyBranch(pieridae, "Anthocharis");
        IClassification colias = PluginLepidopterology.createButterflyBranch(pieridae, "Colias");
        IClassification pontia = PluginLepidopterology.createButterflyBranch(pieridae, "Pontia");
        IClassification celastrina = PluginLepidopterology.createButterflyBranch(pieridae, "Celastrina");
        Allele.lepiCabbageWhite = new AlleleButterflySpecies("lepiCabbageWhite", true, "cabbageWhite", pieris, "rapae", 0xCCFFEE).setRarity(1.0f);
        Allele.lepiBrimstone = new AlleleButterflySpecies("lepiBrimstone", true, "brimstone", gonepteryx, "rhamni", 15789624).setRarity(1.0f);
        Allele.lepiAurora = new AlleleButterflySpecies("lepiAurora", true, "orangeTip", anthocharis, "cardamines", 14896901).setRarity(0.5f);
        Allele.lepiPostillion = new AlleleButterflySpecies("lepiPostillion", true, "postillion", colias, "croceus", 14122500).setRarity(0.5f);
        Allele.lepiPalaenoSulphur = new AlleleButterflySpecies("lepiPalaenoSulphur", true, "palaenoSulphur", colias, "palaeno", 16317347).setRarity(0.4f);
        Allele.lepiReseda = new AlleleButterflySpecies("lepiReseda", true, "reseda", pontia, "edusa", 7634248).setRarity(0.3f);
        Allele.lepiSpringAzure = new AlleleButterflySpecies("lepiSpringAzure", true, "springAzure", celastrina, "argiolus", 12110562).setRarity(0.3f);
        Allele.lepiGozoraAzure = new AlleleButterflySpecies("lepiGozoraAzure", true, "gozoraAzure", celastrina, "gozora", 6844647).setRarity(0.2f);
        IClassification papilio = PluginLepidopterology.createButterflyBranch(papilionidae, "Papilio");
        IClassification protographium = PluginLepidopterology.createButterflyBranch(papilionidae, "Protographium");
        Allele.lepiCitrusSwallow = (IAlleleButterflySpecies)((AlleleSpecies)new AlleleButterflySpecies("lepiCitrusSwallow", false, "swallowtailC", papilio, "demodocus", 15393673).setRarity(1.0f).setTemperatureDeprecated(EnumTemperature.WARM)).setHumidityDeprecated(EnumHumidity.DAMP);
        Allele.lepiEmeraldPeacock = (IAlleleButterflySpecies)((AlleleSpecies)new AlleleButterflySpecies("lepiEmeraldPeacock", true, "emeraldPeacock", papilio, "palinurus", 8191616).setTemperatureDeprecated(EnumTemperature.WARM)).setHumidityDeprecated(EnumHumidity.DAMP);
        Allele.lepiThoasSwallow = (IAlleleButterflySpecies)((AlleleSpecies)new AlleleButterflySpecies("lepiThoasSwallow", false, "swallowtailT", papilio, "thoas", 15386499).setRarity(0.2f).setTemperatureDeprecated(EnumTemperature.WARM)).setHumidityDeprecated(EnumHumidity.DAMP);
        Allele.lepiSpicebush = new AlleleButterflySpecies("lepiSpicebush", true, "swallowtailS", papilio, "troilus", 0xEEFEFF).setRarity(0.5f);
        Allele.lepiBlackSwallow = new AlleleButterflySpecies("lepiBlackSwallow", true, "swallowtailB", papilio, "polyxenes", 15386499).setRarity(1.0f);
        Allele.lepiZebraSwallow = new AlleleButterflySpecies("lepiZebraSwallow", true, "swallowtailZ", protographium, "marcellus", 0xEAFEFF).setRarity(0.5f);
        IClassification pararge = PluginLepidopterology.createButterflyBranch(nymphalidae, "Pararge");
        IClassification polygonia = PluginLepidopterology.createButterflyBranch(nymphalidae, "Polygonia");
        IClassification morpho = PluginLepidopterology.createButterflyBranch(nymphalidae, "Morpho");
        IClassification greta = PluginLepidopterology.createButterflyBranch(nymphalidae, "Greta");
        IClassification batesia = PluginLepidopterology.createButterflyBranch(nymphalidae, "Batesia");
        IClassification myscelia = PluginLepidopterology.createButterflyBranch(nymphalidae, "Myscelia");
        IClassification danaus = PluginLepidopterology.createButterflyBranch(nymphalidae, "Danaus");
        IClassification bassarona = PluginLepidopterology.createButterflyBranch(nymphalidae, "Bassarona");
        IClassification parantica = PluginLepidopterology.createButterflyBranch(nymphalidae, "Parantica");
        IClassification heliconius = PluginLepidopterology.createButterflyBranch(nymphalidae, "Heliconius");
        IClassification siproeta = PluginLepidopterology.createButterflyBranch(nymphalidae, "Siproeta");
        IClassification cethosia = PluginLepidopterology.createButterflyBranch(nymphalidae, "Cethosia");
        IClassification speyeria = PluginLepidopterology.createButterflyBranch(nymphalidae, "Speyeria");
        Allele.lepiGlasswing = (IAlleleButterflySpecies)new AlleleButterflySpecies("lepiGlasswing", true, "glasswing", greta, "oto", 5781298).setTemperatureDeprecated(EnumTemperature.WARM);
        Allele.lepiSpeckledWood = new AlleleButterflySpecies("lepiSpeckledWood", true, "speckledWood", pararge, "aegeria", 9728581).setRarity(1.0f);
        Allele.lepiMadeiranSpeckledWood = new AlleleButterflySpecies("lepiMSpeckledWood", true, "speckledWoodM", pararge, "xiphia", 4204825).setRarity(0.5f);
        Allele.lepiCanarySpeckledWood = new AlleleButterflySpecies("lepiCSpeckledWood", true, "speckledWoodC", pararge, "xiphioides", 5322538).setRarity(0.5f);
        Allele.lepiMenelausBlueMorpho = (IAlleleButterflySpecies)((AlleleSpecies)new AlleleButterflySpecies("lepiMBlueMorpho", true, "blueMorphoM", morpho, "menelaus", 7528957).setRarity(0.5f).setTemperatureDeprecated(EnumTemperature.WARM)).setHumidityDeprecated(EnumHumidity.DAMP);
        Allele.lepiPeleidesBlueMorpho = (IAlleleButterflySpecies)((AlleleSpecies)new AlleleButterflySpecies("lepiPBlueMorpho", true, "blueMorphoP", morpho, "peleides", 7261416).setRarity(0.25f).setTemperatureDeprecated(EnumTemperature.WARM)).setHumidityDeprecated(EnumHumidity.DAMP);
        Allele.lepiRhetenorBlueMorpho = (IAlleleButterflySpecies)((AlleleSpecies)new AlleleButterflySpecies("lepiRBlueMorpho", true, "blueMorphoR", morpho, "rhetenor", 48888).setTemperatureDeprecated(EnumTemperature.WARM)).setHumidityDeprecated(EnumHumidity.DAMP);
        Allele.lepiComma = new AlleleButterflySpecies("lepiComma", true, "comma", polygonia, "c-album", 16291077).setRarity(0.3f);
        Allele.lepiBatesia = (IAlleleButterflySpecies)((AlleleSpecies)new AlleleButterflySpecies("lepiBatesia", true, "paintedBeauty", batesia, "hypochlora", 16676707).setRarity(0.3f).setTemperatureDeprecated(EnumTemperature.WARM)).setHumidityDeprecated(EnumHumidity.DAMP);
        Allele.lepiBlueWing = new AlleleButterflySpecies("lepiBlueWing", true, "blueWing", myscelia, "ethusa", 3838924).setRarity(0.3f);
        Allele.lepiMonarch = new AlleleButterflySpecies("lepiMonarch", true, "monarch", danaus, "plexippus", 16754466).setRarity(0.2f);
        Allele.lepiBlueDuke = (IAlleleButterflySpecies)new AlleleButterflySpecies("lepiBlueDuke", true, "blueDuke", bassarona, "durga", 3162688).setRarity(0.5f).setTemperatureDeprecated(EnumTemperature.COLD);
        Allele.lepiGlassyTiger = new AlleleButterflySpecies("lepiGlassyTiger", true, "glassyTiger", parantica, "aglea", 5978421).setRarity(0.3f);
        Allele.lepiPostman = new AlleleButterflySpecies("lepiPostman", true, "postman", heliconius, "melpomene", 16199725).setRarity(0.3f);
        Allele.lepiMalachite = (IAlleleButterflySpecies)((AlleleSpecies)new AlleleButterflySpecies("lepiMalachite", true, "malachite", siproeta, "stelenes", 12451667).setRarity(0.5f).setTemperatureDeprecated(EnumTemperature.WARM)).setHumidityDeprecated(EnumHumidity.DAMP);
        Allele.lepiLLacewing = new AlleleButterflySpecies("lepiLLacewing", true, "leopardLacewing", cethosia, "cyane", 16484870).setRarity(0.7f);
        Allele.lepiDianaFrit = new AlleleButterflySpecies("lepiDianaFrit", true, "dianaFritillary", speyeria, "diana", 16755717).setRarity(0.6f);
        Allele.butterflyNone = new AlleleEffectNone();
    }

    private static IClassification createButterflyBranch(IClassification family, String scientific) {
        Branch branch = new Branch("moth." + scientific.toLowerCase(Locale.ENGLISH), scientific);
        branch.setParent(family);
        return branch;
    }

    private static void registerTemplates() {
        butterflyInterface.registerTemplate(ButterflyTemplates.getBrimstoneMothTemplate());
        butterflyInterface.registerTemplate(ButterflyTemplates.getLatticedHeathTemplate());
        butterflyInterface.registerTemplate(ButterflyTemplates.getAtlasMothTemplate());
        butterflyInterface.registerTemplate(ButterflyTemplates.getCabbageWhiteTemplate());
        butterflyInterface.registerTemplate(ButterflyTemplates.getGlasswingTemplate());
        butterflyInterface.registerTemplate(ButterflyTemplates.getEmeraldPeacockTemplate());
        butterflyInterface.registerTemplate(ButterflyTemplates.getThoasSwallowTemplate());
        butterflyInterface.registerTemplate(ButterflyTemplates.getCitrusSwallowTemplate());
        butterflyInterface.registerTemplate(ButterflyTemplates.getBlackSwallowTemplate());
        butterflyInterface.registerTemplate(ButterflyTemplates.getZebraSwallowTemplate());
        butterflyInterface.registerTemplate(ButterflyTemplates.getDianaFritTemplate());
        butterflyInterface.registerTemplate(ButterflyTemplates.getSpeckledWoodTemplate());
        butterflyInterface.registerTemplate(ButterflyTemplates.getMadeiranSpeckledWoodTemplate());
        butterflyInterface.registerTemplate(ButterflyTemplates.getCanarySpeckledWoodTemplate());
        butterflyInterface.registerTemplate(ButterflyTemplates.getMenelausBlueMorphoTemplate());
        butterflyInterface.registerTemplate(ButterflyTemplates.getRhetenorBlueMorphoTemplate());
        butterflyInterface.registerTemplate(ButterflyTemplates.getPeleidesBlueMorphoTemplate());
        butterflyInterface.registerTemplate(ButterflyTemplates.getBrimstoneTemplate());
        butterflyInterface.registerTemplate(ButterflyTemplates.getAuroraTemplate());
        butterflyInterface.registerTemplate(ButterflyTemplates.getPostillionTemplate());
        butterflyInterface.registerTemplate(ButterflyTemplates.getPalaenoSulphurTemplate());
        butterflyInterface.registerTemplate(ButterflyTemplates.getResedaTemplate());
        butterflyInterface.registerTemplate(ButterflyTemplates.getSpringAzureTemplate());
        butterflyInterface.registerTemplate(ButterflyTemplates.getGozoraAzureTemplate());
        butterflyInterface.registerTemplate(ButterflyTemplates.getCommaTemplate());
        butterflyInterface.registerTemplate(ButterflyTemplates.getBatesiaTemplate());
        butterflyInterface.registerTemplate(ButterflyTemplates.getBlueWingTemplate());
        butterflyInterface.registerTemplate(ButterflyTemplates.getBlueDukeTemplate());
        butterflyInterface.registerTemplate(ButterflyTemplates.getGlassyTigerTemplate());
        butterflyInterface.registerTemplate(ButterflyTemplates.getMonarchTemplate());
        butterflyInterface.registerTemplate(ButterflyTemplates.getPostmanTemplate());
        butterflyInterface.registerTemplate(ButterflyTemplates.getSpicebushTemplate());
        butterflyInterface.registerTemplate(ButterflyTemplates.getMalachiteTemplate());
        butterflyInterface.registerTemplate(ButterflyTemplates.getLeopardLacewingTemplate());
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return new GuiHandlerLepidopterology();
    }

    public static boolean isPollinationAllowed() {
        return allowPollination;
    }

    static {
        spawnConstraint = 100;
        entityConstraint = 1000;
        allowPollination = true;
    }
}

