/*
 * Decompiled with CFR 0.152.
 */
package tonius.neiintegration;

import codechicken.nei.NEIServerUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidContainerItem;
import org.lwjgl.input.Keyboard;
import tonius.neiintegration.NEIIntegration;

public class Utils {
    public static String translate(String unlocalized, boolean prefix) {
        return StatCollector.func_74838_a((String)((prefix ? "neiintegration." : "") + unlocalized));
    }

    public static String translate(String unlocalized) {
        return Utils.translate(unlocalized, true);
    }

    public static boolean areStacksSameTypeCraftingSafe(ItemStack stack1, ItemStack stack2) {
        if (stack1 != null && stack2 != null) {
            return NEIServerUtils.areStacksSameTypeCrafting((ItemStack)stack1, (ItemStack)stack2);
        }
        return false;
    }

    public static List<ItemStack> getItemVariations(ItemStack base) {
        ArrayList<ItemStack> variations = new ArrayList<ItemStack>();
        base.func_77973_b().func_150895_a(base.func_77973_b(), null, variations);
        Iterator itr = variations.iterator();
        while (itr.hasNext()) {
            ItemStack stack = (ItemStack)itr.next();
            if (base.func_77969_a(stack) && stack.func_77942_o()) continue;
            itr.remove();
        }
        if (variations.isEmpty()) {
            return Collections.singletonList(base);
        }
        return variations;
    }

    public static FluidStack getFluidStack(ItemStack stack) {
        if (stack != null) {
            Fluid fluid;
            FluidStack fluidStack = null;
            if (stack.func_77973_b() instanceof IFluidContainerItem) {
                fluidStack = ((IFluidContainerItem)stack.func_77973_b()).getFluid(stack);
            }
            if (fluidStack == null) {
                fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
            }
            if (fluidStack == null && Block.func_149634_a((Item)stack.func_77973_b()) instanceof IFluidBlock && (fluid = ((IFluidBlock)Block.func_149634_a((Item)stack.func_77973_b())).getFluid()) != null) {
                fluidStack = new FluidStack(fluid, 1000);
            }
            return fluidStack;
        }
        return null;
    }

    public static boolean areFluidsSameType(FluidStack fluidStack1, FluidStack fluidStack2) {
        if (fluidStack1 == null || fluidStack2 == null) {
            return false;
        }
        return fluidStack1.getFluid() == fluidStack2.getFluid();
    }

    public static boolean isShiftKeyDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public static Class getClass(String name) {
        try {
            Class<?> clazz = Class.forName(name);
            return clazz;
        }
        catch (Exception e) {
            NEIIntegration.log.error("Failed to find class " + name);
            return null;
        }
    }
}

