/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.forestry;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeMutationCustom;
import forestry.api.apiculture.IJubilanceProvider;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleFlowers;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IFlowerProvider;
import forestry.api.recipes.RecipeManagers;
import java.util.HashMap;
import net.bdew.gendustry.api.EnumMutationSetting;
import net.bdew.gendustry.api.GendustryAPI;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.integration.forestry.FlowerProviderSea;
import pl.asie.computronics.integration.forestry.JubilanceSea;
import pl.asie.computronics.reference.Mods;
import pl.asie.lib.item.ItemMultiple;

public class IntegrationForestry {
    public static IAlleleSpecies speciesScummy;
    public static IBeeMutationCustom scummyA;
    public static IBeeMutationCustom scummyB;
    public static IAlleleFlowers sea;
    public static ItemMultiple itemPartsForestry;
    private static final String speciesAgrarian = "forestry.speciesAgrarian";
    private static final String speciesExotic = "forestry.speciesExotic";
    private static final String speciesTipsy = "forestry.speciesTipsy";

    public void preInitOC() {
        if (Mods.isLoaded("OpenComputers")) {
            itemPartsForestry = new ItemMultiple("computronics", new String[]{"for.combAcid", "for.dropAcid"});
            itemPartsForestry.func_77637_a(Computronics.tab);
            GameRegistry.registerItem((Item)itemPartsForestry, (String)"computronics.partsForestry");
        }
    }

    @Optional.Method(modid="OpenComputers")
    public void initOC() {
        Computronics.log.info("Adding Forestry Bees for OpenComputers.");
        IClassification pirates = BeeManager.beeFactory.createBranch("pirates", "Piraticus");
        AlleleManager.alleleRegistry.getClassification("family.apidae").addMemberGroup(pirates);
        sea = AlleleManager.alleleFactory.createFlowers("computronics", "flowers", "sea", (IFlowerProvider)new FlowerProviderSea(), true);
        Block shortMead = null;
        Fluid shortMeadFluid = FluidRegistry.getFluid((String)"short.mead");
        if (shortMeadFluid != null) {
            shortMead = FluidRegistry.getFluid((String)"short.mead").getBlock();
        }
        speciesScummy = BeeManager.beeFactory.createSpecies("computronics.speciesScummy", false, "Sangar", "computronics.bees.species.scummy", "computronics.bees.species.scummy.description", pirates, "ebriosus", 57119, 16768022).setNocturnal().setJubilanceProvider((IJubilanceProvider)new JubilanceSea(shortMead, 0)).addSpecialty(new ItemStack((Item)itemPartsForestry, 1, 0), Float.valueOf(0.2f)).setIsSecret().setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.DAMP).setHasEffect().setIsNotCounted();
        scummyA = BeeManager.beeMutationFactory.createMutation((IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele(speciesAgrarian), (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele(speciesExotic), IntegrationForestry.getScummyTemplate(), 2);
        if (shortMead != null) {
            scummyA.requireResource(shortMead, 0);
        }
        scummyA.restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.OCEAN}).requireNight().restrictTemperature(EnumTemperature.WARM, EnumTemperature.HELLISH).setIsSecret();
        scummyB = BeeManager.beeMutationFactory.createMutation((IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele(speciesTipsy), (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele(speciesExotic), IntegrationForestry.getScummyTemplate(), 10);
        scummyB.requireNight().setIsSecret();
        BeeManager.beeRoot.registerTemplate(IntegrationForestry.getScummyTemplate());
        HashMap<ItemStack, Float> acidRecipe = new HashMap<ItemStack, Float>();
        acidRecipe.put(new ItemStack((Item)itemPartsForestry, 1, 1), Float.valueOf(1.0f));
        acidRecipe.put(new ItemStack((Item)itemPartsForestry, 1, 1), Float.valueOf(0.3f));
        RecipeManagers.centrifugeManager.addRecipe(40, new ItemStack((Item)itemPartsForestry, 1, 0), acidRecipe);
        Item bottleItem = GameRegistry.findItem((String)"Forestry", (String)"beverage");
        ItemStack bottle = bottleItem != null ? new ItemStack(bottleItem, 1, 0) : new ItemStack((Item)Items.field_151068_bn, 1, 32);
        GameRegistry.addShapelessRecipe((ItemStack)li.cil.oc.api.Items.get((String)"acid").createItemStack(1), (Object[])new Object[]{new ItemStack((Item)itemPartsForestry, 1, 1), new ItemStack((Item)itemPartsForestry, 1, 1), bottle});
        if (Mods.API.hasVersion("gendustryAPI", "[2.0.0,)")) {
            this.registerBees();
        }
    }

    @Optional.Method(modid="gendustryAPI")
    private void registerBees() {
        if (GendustryAPI.Registries != null && GendustryAPI.Registries.getMutatronOverrides() != null) {
            GendustryAPI.Registries.getMutatronOverrides().set(speciesScummy, EnumMutationSetting.REQUIREMENTS);
        }
    }

    public static IAllele[] getScummyTemplate() {
        IAllele[] alleles = (IAllele[])BeeManager.beeRoot.getTemplate(speciesExotic).clone();
        alleles[EnumBeeChromosome.CAVE_DWELLING.ordinal()] = AlleleManager.alleleRegistry.getAllele("forestry.boolFalse");
        alleles[EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal()] = AlleleManager.alleleRegistry.getAllele("forestry.toleranceUp1");
        alleles[EnumBeeChromosome.FLOWERING.ordinal()] = AlleleManager.alleleRegistry.getAllele("forestry.floweringSlowest");
        alleles[EnumBeeChromosome.TERRITORY.ordinal()] = AlleleManager.alleleRegistry.getAllele("forestry.territoryDefault");
        alleles[EnumBeeChromosome.SPECIES.ordinal()] = speciesScummy;
        alleles[EnumBeeChromosome.FERTILITY.ordinal()] = AlleleManager.alleleRegistry.getAllele("forestry.fertilityLow");
        alleles[EnumBeeChromosome.TOLERANT_FLYER.ordinal()] = AlleleManager.alleleRegistry.getAllele("forestry.boolTrue");
        alleles[EnumBeeChromosome.NOCTURNAL.ordinal()] = AlleleManager.alleleRegistry.getAllele("forestry.boolFalse");
        alleles[EnumBeeChromosome.SPEED.ordinal()] = AlleleManager.alleleRegistry.getAllele("forestry.speedSlowest");
        alleles[EnumBeeChromosome.LIFESPAN.ordinal()] = AlleleManager.alleleRegistry.getAllele("forestry.lifespanLonger");
        alleles[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = AlleleManager.alleleRegistry.getAllele("forestry.toleranceUp1");
        alleles[EnumBeeChromosome.FLOWER_PROVIDER.ordinal()] = sea;
        alleles[EnumBeeChromosome.EFFECT.ordinal()] = AlleleManager.alleleRegistry.getAllele("forestry.effectDrunkard");
        return alleles;
    }
}

