/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.railcraft.tile;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.SidedEnvironment;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.common.carts.EntityLocomotive;
import mods.railcraft.common.carts.EnumCart;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.cc.ISidedPeripheral;
import pl.asie.computronics.integration.railcraft.block.BlockDigitalDetector;
import pl.asie.computronics.reference.Mods;
import pl.asie.computronics.tile.TileEntityPeripheralBase;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SidedEnvironment", modid="OpenComputers")})
public class TileDigitalDetector
extends TileEntityPeripheralBase
implements SidedEnvironment,
ISidedPeripheral {
    public ForgeDirection direction;
    private boolean tested;
    private List<EntityMinecart> currentCarts = new ArrayList<EntityMinecart>();

    public TileDigitalDetector() {
        super("digital_detector");
        this.direction = ForgeDirection.UP;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (!this.tested) {
            this.tested = true;
            int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (meta != 0) {
                this.field_145850_b.func_147475_p(this.field_145851_c, this.field_145848_d, this.field_145848_d);
                BlockDigitalDetector block = Computronics.railcraft.detector;
                if (block != null) {
                    this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145848_d, (Block)block, 0, 3);
                }
            }
        }
        List carts = CartTools.getMinecartsOnAllSides((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (float)0.2f);
        for (EntityMinecart cart : carts) {
            if (this.currentCarts.contains(cart)) continue;
            ArrayList<Object> info = new ArrayList<Object>();
            this.appendCartType(info, cart);
            this.appendLocomotiveInformation(info, cart);
            if (Mods.isLoaded("OpenComputers") && this.node() != null) {
                this.eventOC(info);
            }
            if (!Mods.isLoaded("ComputerCraft")) continue;
            this.eventCC(info);
        }
        this.currentCarts.clear();
        this.currentCarts = carts;
    }

    @Override
    public boolean canBeColored() {
        return false;
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74774_a("direction", (byte)this.direction.ordinal());
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.direction = data.func_74764_b("direction") ? ForgeDirection.getOrientation((int)data.func_74771_c("direction")) : ForgeDirection.UP;
    }

    @Override
    public void writeToRemoteNBT(NBTTagCompound tag) {
        tag.func_74774_a("direction", (byte)this.direction.ordinal());
    }

    @Override
    public void readFromRemoteNBT(NBTTagCompound tag) {
        ForgeDirection oldDir = this.direction;
        ForgeDirection forgeDirection = this.direction = tag.func_74764_b("direction") ? ForgeDirection.getOrientation((int)tag.func_74771_c("direction")) : ForgeDirection.UP;
        if (oldDir != this.direction) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    private void appendCartType(ArrayList<Object> info, EntityMinecart cart) {
        EnumCart type = EnumCart.fromCart((EntityMinecart)cart);
        info.add(type != null ? type.name().toLowerCase(Locale.ENGLISH) : "unknown");
        String entityName = cart.func_95999_t();
        info.add(entityName != null ? entityName : "");
    }

    private void appendLocomotiveInformation(ArrayList<Object> info, EntityMinecart cart) {
        if (cart instanceof EntityLocomotive) {
            EntityLocomotive locomotive = (EntityLocomotive)cart;
            GameProfile owner = locomotive.getOwner();
            info.add(Math.max(15 - locomotive.getPrimaryColor(), -1));
            info.add(Math.max(15 - locomotive.getSecondaryColor(), -1));
            String destination = locomotive.getDestination();
            info.add(destination != null ? destination : "");
            info.add(owner != null ? owner.getName() : "");
        }
    }

    @Optional.Method(modid="OpenComputers")
    public void eventOC(ArrayList<Object> info) {
        ArrayList<Object> extendedInfo = new ArrayList<Object>();
        extendedInfo.add("minecart");
        extendedInfo.addAll(info);
        this.node().sendToReachable("computer.signal", extendedInfo.toArray());
    }

    @Optional.Method(modid="ComputerCraft")
    public void eventCC(ArrayList<Object> info) {
        if (this.attachedComputersCC != null) {
            for (IComputerAccess computer : this.attachedComputersCC) {
                ArrayList<Object> extendedInfo = new ArrayList<Object>();
                extendedInfo.add(computer.getAttachmentName());
                extendedInfo.addAll(info);
                computer.queueEvent("minecart", extendedInfo.toArray());
            }
        }
    }

    public Node sidedNode(ForgeDirection side) {
        return side == this.direction ? this.node() : null;
    }

    public boolean canConnect(ForgeDirection side) {
        return side == this.direction;
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return new String[0];
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        return null;
    }

    @Override
    public boolean canConnectPeripheralOnSide(int side) {
        return ForgeDirection.getOrientation((int)side) == this.direction;
    }

    @Override
    public boolean connectable(int side) {
        return false;
    }

    public short busRead(int addr) {
        return 0;
    }

    public void busWrite(int addr, short data) {
    }
}

