/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.railcraft.tile;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Locale;
import li.cil.oc.api.Network;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.BlacklistedPeripheral;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.SidedEnvironment;
import li.cil.oc.api.network.Visibility;
import mods.railcraft.api.signals.IReceiverTile;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.api.signals.SignalController;
import mods.railcraft.api.signals.SimpleSignalReceiver;
import mods.railcraft.common.blocks.signals.ISignalTileDefinition;
import mods.railcraft.common.blocks.signals.TileBoxBase;
import mods.railcraft.common.plugins.buildcraft.triggers.IAspectProvider;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import pl.asie.computronics.api.multiperipheral.IMultiPeripheral;
import pl.asie.computronics.cc.ISidedPeripheral;
import pl.asie.computronics.integration.railcraft.SignalTypes;
import pl.asie.computronics.reference.Mods;
import pl.asie.computronics.util.internal.IComputronicsPeripheral;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.Environment", modid="OpenComputers"), @Optional.Interface(iface="li.cil.oc.api.network.SidedEnvironment", modid="OpenComputers"), @Optional.Interface(iface="li.cil.oc.api.network.BlacklistedPeripheral", modid="OpenComputers"), @Optional.Interface(iface="pl.asie.computronics.api.multiperipheral.IMultiPeripheral", modid="ComputerCraft"), @Optional.Interface(iface="mods.railcraft.api.signals.IReceiverTile", modid="Railcraft"), @Optional.Interface(iface="mods.railcraft.common.plugins.buildcraft.triggers.IAspectProvider", modid="Railcraft")})
public class TileDigitalReceiverBox
extends TileBoxBase
implements IReceiverTile,
IAspectProvider,
Environment,
SidedEnvironment,
IMultiPeripheral,
IComputronicsPeripheral,
ISidedPeripheral,
BlacklistedPeripheral {
    private boolean prevBlinkState;
    private final SimpleSignalReceiver receiver = new SimpleSignalReceiver(this.getName(), (TileEntity)this);
    protected String peripheralName;
    protected Node node;
    protected ArrayList<IComputerAccess> attachedComputersCC;
    protected boolean addedToNetwork = false;

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.addedToNetwork && Mods.isLoaded("OpenComputers")) {
            this.addedToNetwork = true;
            Network.joinOrCreateNetwork((TileEntity)this);
        }
        if (this.field_145850_b.field_72995_K) {
            this.receiver.tickClient();
            if (this.receiver.getAspect().isBlinkAspect() && this.prevBlinkState != SignalAspect.isBlinkOn()) {
                this.prevBlinkState = SignalAspect.isBlinkOn();
                this.markBlockForUpdate();
            }
            return;
        }
        this.receiver.tickServer();
        SignalAspect prevAspect = this.receiver.getAspect();
        if (this.receiver.isBeingPaired()) {
            this.receiver.setAspect(SignalAspect.BLINK_YELLOW);
        } else if (!this.receiver.isPaired()) {
            this.receiver.setAspect(SignalAspect.BLINK_RED);
        }
        if (prevAspect != this.receiver.getAspect()) {
            this.updateNeighbors();
            this.sendUpdateToClient();
        }
    }

    public void onControllerAspectChange(SignalController con, SignalAspect aspect) {
        if (Mods.isLoaded("OpenComputers")) {
            this.eventOC(aspect);
        }
        if (Mods.isLoaded("ComputerCraft")) {
            this.eventCC(aspect);
        }
        this.updateNeighbors();
        this.sendUpdateToClient();
    }

    private void updateNeighbors() {
        this.notifyBlocksOfNeighborChange();
    }

    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        if (Mods.isLoaded("OpenComputers")) {
            this.writeToNBT_OC(data);
        }
        this.receiver.writeToNBT(data);
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        if (Mods.isLoaded("OpenComputers")) {
            this.readFromNBT_OC(data);
        }
        this.receiver.readFromNBT(data);
    }

    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        this.receiver.writePacketData(data);
    }

    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.receiver.readPacketData(data);
        this.markBlockForUpdate();
    }

    public SignalAspect getBoxSignalAspect(ForgeDirection side) {
        return this.receiver.getAspect();
    }

    public boolean canTransferAspect() {
        return true;
    }

    public SimpleSignalReceiver getReceiver() {
        return this.receiver;
    }

    public SignalAspect getTriggerAspect() {
        return this.getBoxSignalAspect(null);
    }

    public Block func_145838_q() {
        if (this.field_145854_h == null) {
            this.field_145854_h = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return this.field_145854_h;
    }

    public boolean isSideSolid(IBlockAccess world, int i, int j, int k, ForgeDirection side) {
        return side == ForgeDirection.UP;
    }

    public boolean isConnected(ForgeDirection side) {
        TileEntity tile = this.tileCache.getTileOnSide(side);
        return tile != null && tile instanceof TileBoxBase && ((TileBoxBase)tile).canReceiveAspect();
    }

    public ISignalTileDefinition getSignalType() {
        return SignalTypes.Digital;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        if (tag != null) {
            this.func_145839_a(tag);
        }
    }

    public TileDigitalReceiverBox() {
        this("digital_receiver_box");
    }

    public TileDigitalReceiverBox(String name) {
        this.peripheralName = name;
        if (Mods.isLoaded("OpenComputers")) {
            this.initOC();
        }
    }

    public TileDigitalReceiverBox(String name, double bufferSize) {
        this.peripheralName = name;
        if (Mods.isLoaded("OpenComputers")) {
            this.initOC(bufferSize);
        }
    }

    @Optional.Method(modid="OpenComputers")
    public void eventOC(SignalAspect aspect) {
        if (this.node != null) {
            this.node.sendToReachable("computer.signal", new Object[]{"aspect_changed", aspect.ordinal()});
        }
    }

    @Optional.Method(modid="ComputerCraft")
    public void eventCC(SignalAspect aspect) {
        if (this.attachedComputersCC != null) {
            for (IComputerAccess computer : this.attachedComputersCC) {
                computer.queueEvent("aspect_changed", new Object[]{computer.getAttachmentName(), aspect.ordinal()});
            }
        }
    }

    @Optional.Method(modid="OpenComputers")
    public Node node() {
        return this.node;
    }

    @Optional.Method(modid="OpenComputers")
    public void onConnect(Node node) {
    }

    @Optional.Method(modid="OpenComputers")
    public void onDisconnect(Node node) {
    }

    @Optional.Method(modid="OpenComputers")
    public void onMessage(Message message) {
    }

    @Optional.Method(modid="OpenComputers")
    public boolean isPeripheralBlacklisted() {
        return true;
    }

    private Object[] getSignal() {
        return new Object[]{this.getTriggerAspect().ordinal()};
    }

    private static Object[] aspects() {
        LinkedHashMap<String, Integer> aspectMap = new LinkedHashMap<String, Integer>();
        for (SignalAspect aspect : SignalAspect.VALUES) {
            aspectMap.put(aspect.name().toLowerCase(Locale.ENGLISH), aspect.ordinal());
        }
        return new Object[]{aspectMap};
    }

    @Callback(doc="function():number; Returns the currently received aspect that triggers the receiver box", direct=true, limit=16)
    @Optional.Method(modid="OpenComputers")
    public Object[] getSignal(Context context, Arguments args) {
        return this.getSignal();
    }

    @Callback(doc="This is a list of every available Signal Aspect in Railcraft", getter=true, direct=true, limit=16)
    public Object[] aspects(Context c, Arguments a) {
        return TileDigitalReceiverBox.aspects();
    }

    @Optional.Method(modid="OpenComputers")
    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.node != null) {
            this.node.remove();
        }
    }

    public void func_145843_s() {
        this.tileCache.purge();
        super.func_145843_s();
        if (Mods.isLoaded("OpenComputers") && this.node != null) {
            this.node.remove();
        }
    }

    @Optional.Method(modid="OpenComputers")
    private void initOC(double s) {
        this.node = Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(this.peripheralName, Visibility.Network).withConnector(s).create();
    }

    @Optional.Method(modid="OpenComputers")
    private void initOC() {
        this.node = Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(this.peripheralName, Visibility.Network).create();
    }

    @Optional.Method(modid="OpenComputers")
    public Node sidedNode(ForgeDirection forgeDirection) {
        return forgeDirection == ForgeDirection.DOWN || forgeDirection == ForgeDirection.UP ? this.node : null;
    }

    @Optional.Method(modid="OpenComputers")
    @SideOnly(value=Side.CLIENT)
    public boolean canConnect(ForgeDirection forgeDirection) {
        return forgeDirection == ForgeDirection.DOWN || forgeDirection == ForgeDirection.UP;
    }

    @Optional.Method(modid="OpenComputers")
    public void readFromNBT_OC(NBTTagCompound nbt) {
        if (this.node != null && this.node.host() == this) {
            this.node.load(nbt.func_74775_l("oc:node"));
        }
    }

    @Optional.Method(modid="OpenComputers")
    public void writeToNBT_OC(NBTTagCompound nbt) {
        if (this.node != null && this.node.host() == this) {
            NBTTagCompound nodeNbt = new NBTTagCompound();
            this.node.save(nodeNbt);
            nbt.func_74782_a("oc:node", (NBTBase)nodeNbt);
        }
    }

    @Optional.Method(modid="ComputerCraft")
    public String getType() {
        return this.peripheralName;
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return new String[]{"getSignal", "aspects"};
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (method < this.getMethodNames().length) {
            switch (method) {
                case 0: {
                    return this.getSignal();
                }
                case 1: {
                    return TileDigitalReceiverBox.aspects();
                }
            }
        }
        return null;
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
        if (this.attachedComputersCC == null) {
            this.attachedComputersCC = new ArrayList(2);
        }
        this.attachedComputersCC.add(computer);
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
        if (this.attachedComputersCC != null) {
            this.attachedComputersCC.remove(computer);
        }
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof TileEntity) {
            TileEntity tother = (TileEntity)other;
            if (!tother.func_145831_w().equals(this.field_145850_b)) {
                return false;
            }
            if (tother.field_145851_c != this.field_145851_c || tother.field_145848_d != this.field_145848_d || tother.field_145849_e != this.field_145849_e) {
                return false;
            }
        }
        return true;
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public int peripheralPriority() {
        return 1;
    }

    @Override
    public boolean canConnectPeripheralOnSide(int side) {
        ForgeDirection forgeDirection = ForgeDirection.getOrientation((int)side);
        return forgeDirection == ForgeDirection.DOWN || forgeDirection == ForgeDirection.UP;
    }
}

