/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.waila;

import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaRegistrar;
import pl.asie.computronics.reference.Mods;

public enum ConfigValues {
    OCAddress("computronics.enableOCAddress", "OpenComputers"),
    NCAddress("computronics.enableNCAddress", "nedocomputers"),
    Tape("computronics.enableTape"),
    TapeName("computronics.enableTapeName"),
    DriveState("computronics.enableDriveState"),
    RelayBound("computronics.enableRelayBound"),
    LampColor("computronics.enableLampColor");

    private String key;
    private boolean defvalue;
    private String modID;

    private ConfigValues(String key) {
        this(key, true);
    }

    private ConfigValues(String key, boolean defvalue) {
        this.key = key;
        this.defvalue = defvalue;
    }

    private ConfigValues(String key, String modID) {
        this(key, modID, true);
    }

    private ConfigValues(String key, String modID, boolean defvalue) {
        this.key = key;
        this.defvalue = defvalue;
        this.modID = modID;
    }

    private void registerConfigRemote(IWailaRegistrar reg) {
        reg.addConfigRemote("Computronics", this.key, this.defvalue);
    }

    static void registerConfigs(IWailaRegistrar reg) {
        for (ConfigValues value : ConfigValues.values()) {
            if (value.modID != null && !Mods.isLoaded(value.modID) && !Mods.API.hasAPI(value.modID)) continue;
            value.registerConfigRemote(reg);
        }
    }

    public boolean getValue(IWailaConfigHandler config) {
        return (this.modID == null || Mods.isLoaded(this.modID) || Mods.API.hasAPI(this.modID)) && config.getConfig(this.key, this.defvalue);
    }
}

