/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.oc;

import cpw.mods.fml.common.network.NetworkRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import li.cil.oc.api.Network;
import li.cil.oc.api.driver.EnvironmentHost;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Connector;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.prefab.ManagedEnvironment;
import li.cil.oc.util.Audio;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.reference.Config;
import pl.asie.lib.network.Packet;

public class DriverCardSound
extends ManagedEnvironment {
    protected final EnvironmentHost host;
    protected final ArrayList<Long> expirationList;

    public DriverCardSound(EnvironmentHost host) {
        this.host = host;
        this.expirationList = new ArrayList();
        this.setNode(Network.newNode((Environment)this, (Visibility)Visibility.Neighbors).withComponent("beep").withConnector(Config.SOUND_ENERGY_COST * 42.0).create());
    }

    public boolean canUpdate() {
        return true;
    }

    public void update() {
        if (this.expirationList.isEmpty()) {
            return;
        }
        while (this.expirationList.size() > 0 && this.expirationList.get(0) <= this.host.world().func_82737_E()) {
            this.expirationList.remove(0);
        }
    }

    @Callback(doc="function():number; returns the current amount of beeps currently being played", direct=true, limit=10)
    public Object[] getBeepCount(Context context, Arguments args) {
        return new Object[]{this.expirationList.size()};
    }

    @Callback(doc="function(frequencyDurationTable:table):boolean; table needs to contain frequency-duration pairs; plays each frequency for the specified duration.")
    public Object[] beep(Context context, Arguments args) throws Exception {
        Map map = args.checkTable(0);
        HashMap<Integer, Integer> freqMap = new HashMap<Integer, Integer>();
        double longest = 0.0;
        if (map.size() > 8) {
            return new Object[]{false, "table must not contain more than 8 frequencies"};
        }
        if (this.expirationList.size() + map.size() > 8) {
            return new Object[]{false, "already too many sounds playing, maximum is 8"};
        }
        for (Object o : map.keySet()) {
            if (!(o instanceof Number)) {
                throw new IllegalArgumentException("frequency " + o.toString() + "is not a number");
            }
            Object durObj = map.get(o);
            if (durObj != null && !(durObj instanceof Number)) {
                throw new IllegalArgumentException("duration '" + durObj.toString() + "'is not a number");
            }
            int frequency = ((Number)o).intValue();
            if (frequency < 20 || frequency > 2000) {
                throw new IllegalArgumentException("invalid frequency, must be in [20, 2000]");
            }
            double duration = DriverCardSound.optDouble(durObj != null ? (Number)((Number)durObj) : (Number)null, 0.1);
            int durationInMilliseconds = Math.max(50, Math.min(5000, (int)(duration * 1000.0)));
            longest = Math.max(longest, Math.max(50.0, Math.min(5000.0, duration * 1000.0)));
            this.expirationList.add(this.host.world().func_82737_E() + (long)(durationInMilliseconds / 1000 * 20));
            Collections.sort(this.expirationList);
            freqMap.put(frequency, durationInMilliseconds);
        }
        return this.trySendSound(freqMap, new Object[]{true}, Config.SOUND_ENERGY_COST * (double)map.size() * (longest / 1000.0), "beep");
    }

    private Object[] trySendSound(HashMap<Integer, Integer> freqMap, Object[] result, double v, String methodName) throws Exception {
        int power;
        if (this.node() instanceof Connector && (power = this.tryConsumeEnergy(v)) < 0) {
            return new Object[]{false, power + ": " + methodName + ": not enough energy available: required" + v + ", found " + ((Connector)this.node()).globalBuffer()};
        }
        DriverCardSound.sendSound(this.host.world(), this.host.xPosition(), this.host.yPosition(), this.host.zPosition(), freqMap);
        return result;
    }

    private int tryConsumeEnergy(double v) {
        if (v < 0.0) {
            return -2;
        }
        v = -v;
        if (this.node() instanceof Connector) {
            Connector connector = (Connector)this.node();
            return connector.tryChangeBuffer(v) ? 1 : -1;
        }
        return 0;
    }

    private static double optDouble(Number value, double def) {
        if (value == null) {
            return def;
        }
        return value.doubleValue();
    }

    private static void sendSound(World world, double x, double y, double z, HashMap<Integer, Integer> freqMap) throws Exception {
        Packet packet = Computronics.packet.create(4).writeInt(world.field_73011_w.field_76574_g).writeInt((int)Math.floor(x)).writeInt((int)Math.floor(y)).writeInt((int)Math.floor(z)).writeInt(freqMap.size());
        for (int frequency : freqMap.keySet()) {
            int duration = freqMap.get(frequency);
            packet.writeShort((short)frequency).writeShort((short)duration);
        }
        Computronics.packet.sendToAllAround(packet, new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)((int)Math.floor(x)), (double)((int)Math.floor(y)), (double)((int)Math.floor(z)), 16.0));
    }

    public static void onSound(Packet packet, EntityPlayer player) throws IOException {
        int dimension = packet.readInt();
        if (DriverCardSound.isInDimension(player, dimension)) {
            int x = packet.readInt();
            int y = packet.readInt();
            int z = packet.readInt();
            int pairs = packet.readInt();
            for (int i = 0; i < pairs; ++i) {
                short frequency = packet.readShort();
                short duration = packet.readShort();
                Audio.play((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f), (int)(frequency & 0xFFFF), (int)(duration & 0xFFFF));
            }
        }
    }

    private static boolean isInDimension(EntityPlayer player, int dimension) {
        return player != null && player.field_70170_p != null && player.field_70170_p.field_73011_w != null && player.field_70170_p.field_73011_w.field_76574_g == dimension;
    }
}

