/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.oc;

import li.cil.oc.api.Network;
import li.cil.oc.api.driver.EnvironmentHost;
import li.cil.oc.api.internal.Robot;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ComponentConnector;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import net.minecraft.nbt.NBTTagCompound;
import pl.asie.computronics.oc.ManagedEnvironmentWithComponentConnector;
import pl.asie.computronics.reference.Config;

public class RobotUpgradeColorful
extends ManagedEnvironmentWithComponentConnector {
    private final EnvironmentHost host;
    private int color = -1;
    private boolean needsUpdate;

    public RobotUpgradeColorful(EnvironmentHost host) {
        this.host = host;
        ComponentConnector node = (ComponentConnector)Network.newNode((Environment)this, (Visibility)Visibility.Network).withConnector().withComponent("colors", Visibility.Neighbors).create();
        this.setNode((Node)node);
    }

    @Callback(doc="function(color:number):boolean; Sets the color of the robot. Returns true on success, false and an error message otherwise", direct=true)
    public Object[] setColor(Context context, Arguments args) {
        int color = args.checkInteger(0);
        if (color >= 0 && color <= 0xFFFFFF) {
            if (this.node.tryChangeBuffer(-Config.COLOR_CHANGE_COST)) {
                this.setColor(color);
                return new Object[]{true};
            }
            return new Object[]{false, "not enough energy"};
        }
        return new Object[]{false, "number must be between 0 and 16777215"};
    }

    @Callback(doc="function():number; Returns the color of the robot.", direct=true)
    public Object[] getColor(Context context, Arguments args) {
        return new Object[]{this.getColor()};
    }

    @Callback(doc="function():boolean; Resets the colour of the robot. Returns true on success, false and an error message otherwise", direct=true)
    public Object[] resetColor(Context context, Arguments args) {
        if (this.node.tryChangeBuffer(-Config.COLOR_CHANGE_COST)) {
            this.setColor(-1);
            return new Object[]{true};
        }
        return new Object[]{false, "not enough energy"};
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
        this.needsUpdate = true;
    }

    protected void updateClient() {
        try {
            if (this.host instanceof Robot) {
                ((Robot)this.host).synchronizeSlot(((Robot)this.host).componentSlot(this.node.address()));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public boolean canUpdate() {
        return true;
    }

    public void update() {
        if (this.needsUpdate) {
            this.updateClient();
            this.needsUpdate = false;
        }
    }

    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        if (nbt.func_74764_b("computronics:color")) {
            this.color = nbt.func_74762_e("computronics:color");
        }
        this.needsUpdate = true;
    }

    public void save(NBTTagCompound nbt) {
        super.save(nbt);
        nbt.func_74768_a("computronics:color", this.color);
    }
}

