/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.tile;

import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import pl.asie.computronics.tile.TileEntityPeripheralBase;
import pl.asie.lib.api.tile.IInventoryProvider;

public class TileEEPROMReader
extends TileEntityPeripheralBase
implements IInventoryProvider {
    private short _nedo_addr;

    public TileEEPROMReader() {
        super("eeprom_reader");
        this.createInventory(1);
    }

    @Override
    public boolean canBeColored() {
        return false;
    }

    public void onSlotUpdate(int slot) {
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        int newMeta = -1;
        if (this.isReady() && meta == 0) {
            newMeta = 1;
        } else if (!this.isReady() && meta == 1) {
            newMeta = 0;
        }
        if (newMeta >= 0) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, newMeta, 2);
        }
    }

    public boolean isReady() {
        ItemStack is = this.func_70301_a(0);
        return is != null && is.field_77994_a > 0;
    }

    public byte[] getData() {
        ItemStack is = this.func_70301_a(0);
        if (!this.isReady()) {
            return new byte[0];
        }
        if (!is.func_77942_o()) {
            is.func_77982_d(new NBTTagCompound());
        }
        return is.func_77978_p().func_74770_j("ram");
    }

    public int getSize() {
        return this.getData().length;
    }

    public void setData(byte[] data) {
        ItemStack is = this.func_70301_a(0);
        if (!this.isReady()) {
            return;
        }
        if (!is.func_77942_o()) {
            is.func_77982_d(new NBTTagCompound());
        }
        is.func_77978_p().func_74773_a("ram", data);
    }

    @Callback(doc="function():boolean; Returns whether the reader has a valid EEPROM in it", direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] isReady(Context context, Arguments args) {
        return new Object[]{this.isReady()};
    }

    @Callback(doc="function():number; Returns the size of the data on the current EEPROM", direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getSize(Context context, Arguments args) {
        return new Object[]{this.getSize()};
    }

    @Callback(doc="function(pos:number [, length:number]):number or string; Reads the piece of data at the specified position, with optionally the specified length", direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] read(Context context, Arguments args) {
        byte[] data = this.getData();
        if (args.count() >= 1 && args.isInteger(0)) {
            int pos = args.checkInteger(0);
            if (pos < 0 || pos >= data.length) {
                return null;
            }
            if (args.count() >= 2 && args.isInteger(1)) {
                int len = args.checkInteger(1);
                if (pos + len >= data.length) {
                    return null;
                }
                byte[] out = new byte[len];
                System.arraycopy(data, pos, out, 0, len);
                return new Object[]{out};
            }
            return new Object[]{(int)data[pos]};
        }
        return null;
    }

    @Callback(doc="function(pos:number, data:number or string):boolean; Writes the specified data to the specified position. Returns true on success", direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] write(Context context, Arguments args) {
        byte[] data = this.getData();
        if (args.count() == 2 && args.isInteger(0)) {
            int pos = args.checkInteger(0);
            if (pos < 0 || pos >= data.length) {
                return new Object[]{false};
            }
            if (args.isByteArray(1)) {
                byte[] inject = args.checkByteArray(1);
                if (pos + inject.length >= data.length) {
                    return new Object[]{false};
                }
                System.arraycopy(inject, 0, data, pos, inject.length);
            } else if (args.isInteger(1)) {
                data[pos] = (byte)args.checkInteger(1);
            } else {
                return new Object[]{false};
            }
            this.setData(data);
            return new Object[]{true};
        }
        return null;
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return new String[]{"isReady", "getSize", "read", "write"};
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        switch (method) {
            case 0: {
                return new Object[]{this.isReady()};
            }
            case 1: {
                return new Object[]{this.getSize()};
            }
        }
        if (arguments.length == 0 || !(arguments[0] instanceof Double)) {
            return null;
        }
        byte[] data = this.getData();
        int pos = ((Double)arguments[0]).intValue();
        if (pos < 0 || pos >= data.length) {
            return null;
        }
        switch (method) {
            case 2: {
                return new Object[]{(int)data[pos]};
            }
            case 3: {
                if (arguments.length < 2 || !(arguments[1] instanceof Double)) break;
                data[pos] = (byte)((Double)arguments[1]).intValue();
                this.setData(data);
            }
        }
        return null;
    }

    public short busRead(int addr) {
        switch (addr & 0xFFFE) {
            case 0: {
                return (short)(this.getData().length >> 1);
            }
        }
        return 0;
    }

    public void busWrite(int addr, short data) {
    }
}

