/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.util;

import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import pl.asie.computronics.reference.Config;

public class Camera {
    private World world;
    private float oxPos;
    private float oyPos;
    private float ozPos;
    private float xPos;
    private float yPos;
    private float zPos;
    private float xDirection;
    private float yDirection;
    private float zDirection;
    private Object hit;

    public boolean ray(World worldObj, float xCoord, float yCoord, float zCoord, ForgeDirection dir, float x, float y) {
        this.hit = null;
        if (x < -1.0f || x > 1.0f || y < -1.0f || y > 1.0f) {
            return false;
        }
        if (dir != null) {
            Vec3 target;
            this.xDirection = 0.0f;
            this.yDirection = y;
            this.zDirection = 0.0f;
            switch (dir) {
                case EAST: {
                    this.xDirection = 1.0f;
                    this.zDirection = -x;
                    xCoord += 0.6f;
                    break;
                }
                case NORTH: {
                    this.zDirection = -1.0f;
                    this.xDirection = x;
                    zCoord -= 0.6f;
                    break;
                }
                case SOUTH: {
                    this.zDirection = 1.0f;
                    this.xDirection = -x;
                    zCoord += 0.6f;
                    break;
                }
                case WEST: {
                    this.xDirection = -1.0f;
                    this.zDirection = x;
                    xCoord -= 0.6f;
                    break;
                }
                case DOWN: {
                    this.yDirection = -1.0f;
                    this.xDirection = x;
                    this.zDirection = y;
                    yCoord -= 0.6f;
                    break;
                }
                case UP: {
                    this.yDirection = 1.0f;
                    this.xDirection = x;
                    this.zDirection = y;
                    yCoord += 0.6f;
                    break;
                }
                case UNKNOWN: {
                    return false;
                }
                default: {
                    return false;
                }
            }
            this.world = worldObj;
            this.xPos = xCoord + 0.5f;
            this.yPos = yCoord + 0.5f;
            this.zPos = zCoord + 0.5f;
            this.oxPos = this.xPos;
            this.oyPos = this.yPos;
            this.ozPos = this.zPos;
            if (!this.world.func_147437_c((int)Math.floor(this.xPos), (int)Math.floor(this.yPos), (int)Math.floor(this.zPos))) {
                this.hit = this.world.func_147439_a((int)Math.floor(this.xPos), (int)Math.floor(this.yPos), (int)Math.floor(this.zPos));
                return true;
            }
            float steps = Config.CAMERA_DISTANCE;
            Vec3 origin = Vec3.func_72443_a((double)this.oxPos, (double)this.oyPos, (double)this.ozPos);
            MovingObjectPosition mop = this.world.func_72933_a(origin, target = Vec3.func_72443_a((double)(this.xPos + this.xDirection * steps), (double)(this.yPos + this.yDirection * steps), (double)(this.zPos + this.zDirection * steps)));
            if (mop != null) {
                this.xPos = (float)mop.field_72307_f.field_72450_a;
                this.yPos = (float)mop.field_72307_f.field_72448_b;
                this.zPos = (float)mop.field_72307_f.field_72449_c;
                switch (mop.field_72313_a) {
                    case ENTITY: {
                        this.hit = mop.field_72308_g;
                        break;
                    }
                    case BLOCK: {
                        this.hit = this.world.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                        break;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public double getDistance() {
        if (this.hit == null) {
            return -1.0;
        }
        double x = this.xPos - this.oxPos;
        double y = this.yPos - this.oyPos;
        double z = this.zPos - this.ozPos;
        return Math.sqrt(x * x + y * y + z * z);
    }
}

