/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.util;

import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.block.material.Material;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.NoteBlockEvent;
import pl.asie.computronics.util.ParticleUtils;

public class NoteUtils {
    private static final String[] instruments = new String[]{"harp", "bd", "snare", "hat", "bassattack", "pling", "bass"};

    public static void playNote(World worldObj, int xCoord, int yCoord, int zCoord, String instrument, int note, float volume) {
        float f = (float)Math.pow(2.0, (double)(note - 12) / 12.0);
        worldObj.func_72908_a((double)xCoord + 0.5, (double)yCoord + 0.5, (double)zCoord + 0.5, "note." + instrument, volume, f);
        ParticleUtils.sendParticlePacket("note", worldObj, (double)xCoord + 0.5, (double)yCoord + 1.2, (double)zCoord + 0.5, (double)note / 24.0, 1.0, 0.0);
    }

    public static void playNote(World worldObj, int xCoord, int yCoord, int zCoord, String instrument, int note) {
        NoteUtils.playNote(worldObj, xCoord, yCoord, zCoord, instrument, note, 3.0f);
    }

    public static void playNote(World worldObj, int xCoord, int yCoord, int zCoord, int instrument, int note) {
        NoteUtils.playNote(worldObj, xCoord, yCoord, zCoord, instrument, note, 3.0f);
    }

    public static void playNote(World worldObj, int xCoord, int yCoord, int zCoord, int instrument, int note, float volume) {
        if (instrument < 0) {
            int b0 = 0;
            if (yCoord > 0) {
                Material m = worldObj.func_147439_a(xCoord, yCoord - 1, zCoord).func_149688_o();
                if (m == Material.field_151576_e) {
                    b0 = 1;
                }
                if (m == Material.field_151595_p) {
                    b0 = 2;
                }
                if (m == Material.field_151592_s) {
                    b0 = 3;
                }
                if (m == Material.field_151575_d) {
                    b0 = 4;
                }
            }
            instrument = b0;
        }
        if ((instrument %= 7) <= 4) {
            NoteBlockEvent.Play e = new NoteBlockEvent.Play(worldObj, xCoord, yCoord, zCoord, Short.MAX_VALUE, note, instrument);
            if (MinecraftForge.EVENT_BUS.post((Event)e)) {
                return;
            }
            instrument = e.instrument.ordinal();
            note = e.getVanillaNoteId();
        }
        String s = instruments[0];
        if (instrument > 0 && instrument < instruments.length) {
            s = instruments[instrument];
        }
        NoteUtils.playNote(worldObj, xCoord, yCoord, zCoord, s, note, volume);
    }

    public static float toVolume(int index, double value) {
        if (value < 0.0 || value > 1.0) {
            throw new IllegalArgumentException("bad argument #" + index + " (number between 0 and 1 expected, got " + value + ")");
        }
        return Math.min(Math.max((float)value * 3.0f, 0.0f), 3.0f);
    }

    public static float toVolume(Object[] arguments, int index) {
        double value = 1.0;
        if (arguments.length > index && arguments[index] instanceof Double) {
            value = (Double)arguments[index];
        }
        return NoteUtils.toVolume(index + 1, value);
    }
}

