/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.compat.multipart;

import buildcraft.api.blueprints.BuilderAPI;
import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.compat.multipart.SchematicMcMetaPart;
import buildcraft.compat.multipart.SchematicMicroblock;
import buildcraft.compat.multipart.SchematicMultipartBlock;
import buildcraft.compat.multipart.SchematicPart;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import codechicken.multipart.handler.MultipartProxy;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;

public class MultipartSchematics {
    private static HashMap<String, SchematicPart> schematicMap = new HashMap();

    public static void registerSchematic(String type, SchematicPart schematic) {
        schematicMap.put(type, schematic);
    }

    public static LinkedList<Map.Entry<TMultiPart, SchematicPart>> getSchematics(IBuilderContext context, int x, int y, int z) {
        LinkedList<Map.Entry<TMultiPart, SchematicPart>> schematics = new LinkedList<Map.Entry<TMultiPart, SchematicPart>>();
        TileEntity tile = context.world().func_147438_o(x, y, z);
        if (!(tile instanceof TileMultipart)) {
            return schematics;
        }
        TileMultipart tileMultipart = (TileMultipart)tile;
        for (TMultiPart part : tileMultipart.jPartList()) {
            SchematicPart schematic = MultipartSchematics.getSchematic(part.getType());
            if (schematic == null) continue;
            schematics.add(new AbstractMap.SimpleEntry<TMultiPart, SchematicPart>(part, schematic));
        }
        return schematics;
    }

    public static SchematicPart getSchematic(String type) {
        return schematicMap.get(type);
    }

    public static void init() {
        BuilderAPI.schematicRegistry.registerSchematicBlock((Block)MultipartProxy.block(), SchematicMultipartBlock.class, new Object[0]);
        MultipartSchematics.registerSchematic("mcr_face", new SchematicMicroblock("mcr_face"));
        MultipartSchematics.registerSchematic("mcr_cnr", new SchematicMicroblock("mcr_cnr"));
        MultipartSchematics.registerSchematic("mcr_edge", new SchematicMicroblock("mcr_edge"));
        MultipartSchematics.registerSchematic("mcr_post", new SchematicMicroblock("mcr_post"));
        MultipartSchematics.registerSchematic("mcr_hllw", new SchematicMicroblock("mcr_hllw"));
        MultipartSchematics.registerSchematic("mc_torch", new SchematicMcMetaPart("mc_torch"));
        MultipartSchematics.registerSchematic("mc_lever", new SchematicMcMetaPart("mc_lever"));
        MultipartSchematics.registerSchematic("mc_button", new SchematicMcMetaPart("mc_button"));
        MultipartSchematics.registerSchematic("mc_redtorch", new SchematicMcMetaPart("mc_redtorch"));
    }
}

