/*
 * Decompiled with CFR 0.152.
 */
package covers1624.powerconverters.net;

import covers1624.powerconverters.PowerConverters;
import covers1624.powerconverters.api.bridge.BridgeSideData;
import covers1624.powerconverters.net.AbstractPacket;
import covers1624.powerconverters.tile.main.TileEntityEnergyBridge;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class EnergyBridgeSyncPacket
extends AbstractPacket {
    private NBTTagCompound tagCompound;

    public EnergyBridgeSyncPacket() {
    }

    public EnergyBridgeSyncPacket(NBTTagCompound tag, int x, int y, int z) {
        this.tagCompound = tag;
        this.tagCompound.func_74768_a("X", x);
        this.tagCompound.func_74768_a("Y", y);
        this.tagCompound.func_74768_a("Z", z);
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.tagCompound);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.tagCompound = ByteBufUtils.readTag((ByteBuf)buffer);
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        TileEntityEnergyBridge energyBridge;
        int x = this.tagCompound.func_74762_e("X");
        int y = this.tagCompound.func_74762_e("Y");
        int z = this.tagCompound.func_74762_e("Z");
        TileEntity tileEntity = PowerConverters.proxy.getClientWorld().func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityEnergyBridge) {
            energyBridge = (TileEntityEnergyBridge)tileEntity;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                NBTTagCompound tag = this.tagCompound.func_74775_l(String.valueOf(dir.ordinal()));
                BridgeSideData data = new BridgeSideData();
                data.loadFromNBT(tag);
                energyBridge.setClientDataForSide(dir, data);
            }
        } else {
            throw new RuntimeException(String.format("Tile @ %s, %s, %s, Does not match the server.", x, y, z));
        }
        energyBridge.setIsInputLimited(this.tagCompound.func_74767_n("InputLimited"));
        energyBridge.setEnergyScaled(this.tagCompound.func_74769_h("Energy"));
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

