/*
 * Decompiled with CFR 0.152.
 */
package covers1624.powerconverters.tile.factorization;

import covers1624.powerconverters.handler.ConfigurationHandler;
import covers1624.powerconverters.init.PowerSystems;
import covers1624.powerconverters.tile.main.TileEntityEnergyProducer;
import factorization.api.Charge;
import factorization.api.Coord;
import factorization.api.IChargeConductor;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;

public class TileEntityPowerConverterFactorizationProducer
extends TileEntityEnergyProducer<IChargeConductor>
implements IChargeConductor {
    private Charge _charge = new Charge((IChargeConductor)this);
    private static final double _maxCG = 2000.0;

    public TileEntityPowerConverterFactorizationProducer() {
        super(PowerSystems.powerSystemFactorization, 0, IChargeConductor.class);
    }

    @Override
    public double produceEnergy(double energy) {
        if (ConfigurationHandler.dissableFactorizationProducer) {
            return energy;
        }
        double CG = energy / (double)PowerSystems.powerSystemFactorization.getScaleAmmount();
        for (Map.Entry output : this.getTiles().entrySet()) {
            IChargeConductor o = (IChargeConductor)output.getValue();
            if (o == null || !((double)o.getCharge().getValue() < 2000.0)) continue;
            double store = Math.min(2000.0 - (double)o.getCharge().getValue(), CG);
            o.getCharge().addValue((int)store);
            if (!((CG -= store) <= 0.0)) continue;
            break;
        }
        return CG * (double)PowerSystems.powerSystemFactorization.getScaleAmmount();
    }

    public Charge getCharge() {
        return this._charge;
    }

    public String getInfo() {
        return null;
    }

    public Coord getCoord() {
        return new Coord((TileEntity)this);
    }
}

