/*
 * Decompiled with CFR 0.152.
 */
package covers1624.powerconverters.tile.main;

import covers1624.powerconverters.api.registry.PowerSystemRegistry;
import covers1624.powerconverters.block.BlockPowerConverter;
import covers1624.powerconverters.tile.main.TileEntityEnergyBridge;
import covers1624.powerconverters.util.BlockPosition;
import covers1624.powerconverters.util.IAdvancedLogTile;
import covers1624.powerconverters.util.INeighboorUpdateTile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityBridgeComponent<T>
extends TileEntity
implements INeighboorUpdateTile,
IAdvancedLogTile {
    private Map<ForgeDirection, TileEntityEnergyBridge> _adjacentBridges = new HashMap<ForgeDirection, TileEntityEnergyBridge>();
    private Map<ForgeDirection, T> _adjacentTiles = new HashMap<ForgeDirection, T>();
    private Class<?> _adjacentClass;
    protected PowerSystemRegistry.PowerSystem powerSystem;
    protected int _voltageIndex;
    protected String type;
    private boolean _initialized;

    protected TileEntityBridgeComponent(PowerSystemRegistry.PowerSystem powersystem, int voltageNameIndex, Class<T> adjacentClass) {
        this.powerSystem = powersystem;
        this._voltageIndex = voltageNameIndex;
        this._adjacentClass = adjacentClass;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this._initialized && !this.field_145846_f) {
            this.onNeighboorChanged();
            this._initialized = true;
        }
    }

    @Override
    public void onNeighboorChanged() {
        HashMap<ForgeDirection, TileEntityEnergyBridge> adjacentBridges = new HashMap<ForgeDirection, TileEntityEnergyBridge>();
        HashMap<ForgeDirection, T> adjacentTiles = new HashMap<ForgeDirection, T>();
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity te = BlockPosition.getAdjacentTileEntity(this, d);
            if (te != null && te instanceof TileEntityEnergyBridge) {
                adjacentBridges.put(d, (TileEntityEnergyBridge)te);
                continue;
            }
            if (te == null || !this._adjacentClass.isAssignableFrom(te.getClass())) continue;
            adjacentTiles.put(d, te);
        }
        this._adjacentBridges = adjacentBridges;
        this._adjacentTiles = adjacentTiles;
    }

    public PowerSystemRegistry.PowerSystem getPowerSystem() {
        return this.powerSystem;
    }

    public boolean isConnected() {
        return this._adjacentTiles.size() > 0;
    }

    public boolean isSideConnected(int side) {
        return this._adjacentTiles.get(ForgeDirection.getOrientation((int)side)) != null;
    }

    public boolean isSideConnectedClient(int side) {
        TileEntity te = BlockPosition.getAdjacentTileEntity(this, ForgeDirection.getOrientation((int)side));
        return te != null && this._adjacentClass.isAssignableFrom(te.getClass());
    }

    public int getVoltageIndex() {
        return this._voltageIndex;
    }

    public TileEntityEnergyBridge getFirstBridge() {
        return this._adjacentBridges.size() == 0 ? null : (TileEntityEnergyBridge)this._adjacentBridges.values().toArray()[0];
    }

    protected Map<ForgeDirection, TileEntityEnergyBridge> getBridges() {
        return this._adjacentBridges;
    }

    protected Map<ForgeDirection, T> getTiles() {
        return this._adjacentTiles;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        if (this._voltageIndex == 0) {
            this._voltageIndex = tagCompound.func_74762_e("voltageIndex");
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74768_a("voltageIndex", this._voltageIndex);
    }

    public boolean isGettingRedstone() {
        Block block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (block instanceof BlockPowerConverter) {
            BlockPowerConverter blockPowerConverter = (BlockPowerConverter)block;
            return blockPowerConverter.isGettingRedstone();
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void addWailaInfo(List<String> info) {
        info.add("Type: " + this.type);
        info.add("PowerSystem: " + this.powerSystem.getName());
        if (this.type.equals("Consumer")) {
            info.add("Consumer Dissabled: " + this.powerSystem.consumerDissabled());
        } else if (this.type.equals("Producer")) {
            info.add("Producer Dissabled: " + this.powerSystem.producerDissabled());
        }
    }

    @Override
    public void getTileInfo(List<IChatComponent> info, ForgeDirection side, EntityPlayer player, boolean debug) {
        info.add((IChatComponent)new ChatComponentText("Is getting Redstone: " + this.isGettingRedstone()));
    }
}

