/*
 * Decompiled with CFR 0.152.
 */
package covers1624.repack.cofh.lib.util;

import com.google.common.base.Objects;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class LinkedHashList<E>
extends AbstractCollection<E>
implements Cloneable {
    protected transient Entry head;
    protected transient Entry tail;
    protected transient int size;
    protected transient int mask;
    protected transient Entry[] hashTable;
    protected transient int modCount;

    protected static int roundUpToPowerOf2(int number) {
        return number >= 0x40000000 ? 0x40000000 : (number > 2 ? Integer.highestOneBit(number - 1 << 1) : 2);
    }

    public LinkedHashList() {
        this.hashTable = new Entry[8];
        this.mask = 7;
    }

    public LinkedHashList(int size) {
        size = LinkedHashList.roundUpToPowerOf2(size);
        this.hashTable = new Entry[size];
        this.mask = size - 1;
    }

    public LinkedHashList(Collection<E> col) {
        int size = LinkedHashList.roundUpToPowerOf2(col.size());
        this.hashTable = new Entry[size];
        this.mask = size - 1;
        this.addAll(col);
    }

    protected int hash(Object n) {
        int h = n == null ? 0 : n.hashCode();
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean add(E e) {
        return this.push(e);
    }

    public E get(int index) {
        this.checkElementIndex(index);
        return (E)this.index((int)index).key;
    }

    public boolean push(E obj) {
        int hash = this.hash(obj);
        if (this.seek(obj, hash) != null) {
            return false;
        }
        ++this.modCount;
        Entry e = new Entry(obj, hash);
        this.insert(e);
        this.rehashIfNecessary();
        e.prev = this.tail;
        e.next = null;
        if (this.tail != null) {
            this.tail.next = e;
        } else {
            this.head = e;
        }
        this.tail = e;
        return true;
    }

    public E pop() {
        Entry e = this.tail;
        if (e != null) {
            ++this.modCount;
            this.delete(e);
            this.tail = e.prev;
            e.prev = null;
            if (this.tail != null) {
                this.tail.next = null;
            } else {
                this.head = null;
            }
            return (E)e.key;
        }
        return null;
    }

    public E peek() {
        return (E)(this.tail != null ? this.tail.key : null);
    }

    public E poke() {
        return (E)(this.head != null ? this.head.key : null);
    }

    public boolean unshift(E obj) {
        int hash = this.hash(obj);
        if (this.seek(obj, hash) != null) {
            return false;
        }
        ++this.modCount;
        Entry e = new Entry(obj, hash);
        this.insert(e);
        this.rehashIfNecessary();
        e.next = this.head;
        e.prev = null;
        if (this.head != null) {
            this.head.prev = e;
        } else {
            this.tail = e;
        }
        this.head = e;
        return true;
    }

    public E shift() {
        Entry e = this.head;
        if (e != null) {
            ++this.modCount;
            this.delete(e);
            this.head = e.next;
            e.next = null;
            if (this.head != null) {
                this.head.prev = null;
            } else {
                this.tail = null;
            }
            return (E)e.key;
        }
        return null;
    }

    @Override
    public boolean contains(Object obj) {
        return this.seek(obj, this.hash(obj)) != null;
    }

    @Override
    public boolean remove(Object obj) {
        Entry e = this.seek(obj, this.hash(obj));
        if (e == null) {
            return false;
        }
        this.unlink(e);
        return true;
    }

    protected Entry index(int index) {
        Entry x;
        if (index < this.size >> 1) {
            x = this.head;
            int i = index;
            while (i-- > 0) {
                x = x.next;
            }
        } else {
            x = this.tail;
            int i = this.size - 1;
            while (i-- > index) {
                x = x.prev;
            }
        }
        return x;
    }

    protected Entry seek(Object obj, int hash) {
        Entry entry = this.hashTable[hash & this.mask];
        while (entry != null) {
            if (hash == entry.hash && Objects.equal((Object)obj, (Object)entry.key)) {
                return entry;
            }
            entry = entry.nextInBucket;
        }
        return null;
    }

    protected void insert(Entry entry) {
        int bucket = entry.hash & this.mask;
        entry.nextInBucket = this.hashTable[bucket];
        this.hashTable[bucket] = entry;
        ++this.size;
    }

    protected boolean linkBefore(E obj, Entry succ) {
        int hash = this.hash(obj);
        if (this.seek(obj, hash) != null) {
            return false;
        }
        Entry pred = succ.prev;
        Entry newNode = new Entry(obj, hash);
        ++this.modCount;
        this.insert(newNode);
        this.rehashIfNecessary();
        newNode.next = succ;
        newNode.prev = pred;
        succ.prev = newNode;
        if (pred == null) {
            this.head = newNode;
        } else {
            pred.next = newNode;
        }
        return true;
    }

    protected void delete(Entry entry) {
        Entry[] entryArray = this.hashTable;
        synchronized (this.hashTable) {
            block6: {
                int bucket = entry.hash & this.mask;
                Entry prev = null;
                Entry cur = this.hashTable[bucket];
                if (cur == entry) {
                    this.hashTable[bucket] = cur.nextInBucket;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    break block6;
                }
                while (true) {
                    if (cur == entry) {
                        prev.nextInBucket = entry.nextInBucket;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        break;
                    }
                    prev = cur;
                    cur = cur.nextInBucket;
                }
            }
            --this.size;
            return;
        }
    }

    protected E unlink(Entry x) {
        Object element = x.key;
        Entry next = x.next;
        Entry prev = x.prev;
        if (prev == null) {
            this.head = next;
        } else {
            prev.next = next;
            x.prev = null;
        }
        if (next == null) {
            this.tail = prev;
        } else {
            next.prev = prev;
            x.next = null;
        }
        this.delete(x);
        ++this.modCount;
        return (E)element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void rehashIfNecessary() {
        Entry[] old = this.hashTable;
        if (this.size <= old.length * 2 || old.length >= 0x40000000) return;
        Entry[] entryArray = this.hashTable;
        synchronized (this.hashTable) {
            int newTableSize = old.length * 2;
            int newMask = newTableSize - 1;
            Entry[] newTable = new Entry[newTableSize];
            this.mask = newMask;
            int bucket = old.length;
            while (bucket-- > 0) {
                Entry entry = old[bucket];
                while (entry != null) {
                    Entry nextEntry = entry.nextInBucket;
                    int keyBucket = entry.hash & newMask;
                    entry.nextInBucket = newTable[keyBucket];
                    newTable[keyBucket] = entry;
                    entry = nextEntry;
                }
            }
            this.hashTable = newTable;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    public LinkedHashList<E> clone() {
        return new LinkedHashList<E>(this);
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    public ListIterator<E> listIterator(int index) {
        this.checkPositionIndex(index);
        return new ListItr(index);
    }

    public Iterator<E> descendingIterator() {
        return new DescendingIterator();
    }

    protected boolean isElementIndex(int index) {
        return index >= 0 && index < this.size;
    }

    protected boolean isPositionIndex(int index) {
        return index >= 0 && index <= this.size;
    }

    protected String outOfBoundsMsg(int index) {
        return "Index: " + index + ", Size: " + this.size;
    }

    protected void checkElementIndex(int index) {
        if (!this.isElementIndex(index)) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    protected void checkPositionIndex(int index) {
        if (!this.isPositionIndex(index)) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    protected class DescendingIterator
    implements Iterator<E> {
        protected final ListItr itr;

        protected DescendingIterator() {
            this.itr = new ListItr(LinkedHashList.this.size());
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasPrevious();
        }

        @Override
        public E next() {
            return this.itr.previous();
        }

        @Override
        public void remove() {
            this.itr.remove();
        }
    }

    protected class ListItr
    implements ListIterator<E> {
        protected Entry lastReturned = null;
        protected Entry next;
        protected int nextIndex;
        protected int expectedModCount;

        protected ListItr(int index) {
            this.expectedModCount = LinkedHashList.this.modCount;
            this.next = index == LinkedHashList.this.size ? null : LinkedHashList.this.index(index);
            this.nextIndex = index;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < LinkedHashList.this.size;
        }

        @Override
        public E next() {
            this.checkForComodification();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next;
            this.next = this.next.next;
            ++this.nextIndex;
            return this.lastReturned.key;
        }

        @Override
        public boolean hasPrevious() {
            return this.nextIndex > 0;
        }

        @Override
        public E previous() {
            this.checkForComodification();
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.next = this.next == null ? LinkedHashList.this.tail : this.next.prev;
            this.lastReturned = this.next;
            --this.nextIndex;
            return this.lastReturned.key;
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            this.checkForComodification();
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            Entry lastNext = this.lastReturned.next;
            LinkedHashList.this.unlink(this.lastReturned);
            if (this.next == this.lastReturned) {
                this.next = lastNext;
            } else {
                --this.nextIndex;
            }
            this.lastReturned = null;
            ++this.expectedModCount;
        }

        @Override
        public void set(E e) {
            this.checkForComodification();
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            LinkedHashList.this.linkBefore(e, this.lastReturned);
            LinkedHashList.this.unlink(this.lastReturned);
            this.lastReturned = this.next == null ? LinkedHashList.this.tail : this.next.prev;
            this.expectedModCount += 2;
        }

        @Override
        public void add(E e) {
            this.checkForComodification();
            this.lastReturned = null;
            if (this.next == null) {
                LinkedHashList.this.push(e);
            } else {
                LinkedHashList.this.linkBefore(e, this.next);
            }
            ++this.nextIndex;
            ++this.expectedModCount;
        }

        protected final void checkForComodification() {
            if (LinkedHashList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    protected static final class Entry {
        protected Entry next;
        protected Entry prev;
        protected final Object key;
        protected final int hash;
        protected Entry nextInBucket;

        protected Entry(Object key, int keyHash) {
            this.key = key;
            this.hash = keyHash;
        }
    }
}

