package mods.immibis.core.experimental.mgui1;

import immibis.mgui.MControl;
import immibis.mgui.MItemSlot;
import immibis.mgui.MWindow;

import java.util.*;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

class BridgeUtils {
	static class BridgeInventory implements IInventory {
		private Map<String, IInventory> nameToInv = new HashMap<>();
		private Map<String, int[]> slotIndices = new HashMap<>();
		private IInventory[] slotToSourceInventory;
		private int[] slotToSourceIndex;
		public int getSlotIndexFor(String invName, int slot) {
			int[] im = slotIndices.get(invName);
			if(im == null) throw new IllegalArgumentException("unknown inventory "+invName);
			if(slot < 0 || slot >= im.length || im[slot] < 0) throw new IllegalArgumentException("non-mapped slot "+slot+" in "+invName);
			return im[slot];
		}
		
		@Override
		public void closeInventory() {
			for(IInventory i : nameToInv.values())
				i.closeInventory();
		}
		
		@Override
		public void openInventory() {
			for(IInventory i : nameToInv.values())
				i.openInventory();
		}
		
		@Override
		public ItemStack decrStackSize(int slot, int amt) {
			return slotToSourceInventory[slot].decrStackSize(slotToSourceIndex[slot], amt);
		}
		
		@Override
		public String getInventoryName() {
			return "MGUI Combined Inventory";
		}
		
		@Override
		public int getInventoryStackLimit() {
			return 64; // XXX
		}
		
		@Override
		public int getSizeInventory() {
			return slotToSourceInventory.length;
		}
		
		@Override
		public ItemStack getStackInSlot(int slot) {
			return slotToSourceInventory[slot].getStackInSlot(slotToSourceIndex[slot]);
		}
		
		@Override
		public ItemStack getStackInSlotOnClosing(int slot) {
			return slotToSourceInventory[slot].getStackInSlotOnClosing(slotToSourceIndex[slot]);
		}
		
		@Override
		public boolean hasCustomInventoryName() {
			return true;
		}
		
		@Override
		public boolean isItemValidForSlot(int slot, ItemStack item) {
			return slotToSourceInventory[slot].isItemValidForSlot(slotToSourceIndex[slot], item);
		}
		
		@Override
		public boolean isUseableByPlayer(EntityPlayer ply) {
			for(IInventory inv : nameToInv.values())
				if(!inv.isUseableByPlayer(ply))
					return false;
			return true;
		}

		@Override
		public void setInventorySlotContents(int slot, ItemStack item) {
			slotToSourceInventory[slot].setInventorySlotContents(slotToSourceIndex[slot], item);
		}

		@Override
		public void markDirty() {
			for(IInventory inv : nameToInv.values())
				inv.markDirty();
		}
	}
	static BridgeInventory generateBridgeInventory(MWindow w) {
		TreeMap<String, TreeSet<Integer>> slots = new TreeMap<>();
		Map<String, String> invNameToControlID = new HashMap<>();
		for(MControl c : w.getControls()) {
			if(c.getIdentifier().equals("")) continue;
			if(c instanceof MItemSlot) {
				MItemSlot is = (MItemSlot)c;
				int numslots = is.getSlotsTotal();
				
				TreeSet<Integer> csslots = slots.get(is.containerSource);
				if(csslots == null)
					slots.put(is.containerSource, csslots = new TreeSet<>());
				
				invNameToControlID.put(is.containerSource, is.getIdentifier());
				
				for(int k = 0; k < numslots; k++) {
					csslots.add(is.firstSlot + k);
				}
			}
		}
		
		BridgeInventory bi = new BridgeInventory();
		
		int numBridgeSlots = 0;
		
		for(String invName : slots.keySet()) {
			IInventory inv = (IInventory)w.getEventHandler().handleEvent(invNameToControlID.get(invName), "getContainer", "");
			if(inv == null)
				throw new RuntimeException("Event handler returned no inventory for control "+invNameToControlID.get(invName)+" (containerSource "+invName+")");
			bi.nameToInv.put(invName, inv);
			
			int slotArraySize = slots.get(invName).last() + 1;
			int[] slotMapping = new int[slotArraySize];
			Arrays.fill(slotMapping, -1);
			for(int sourceSlot : slots.get(invName))
				slotMapping[sourceSlot] = numBridgeSlots++;
			bi.slotIndices.put(invName, slotMapping);
		}
		
		bi.slotToSourceIndex = new int[numBridgeSlots];
		bi.slotToSourceInventory = new IInventory[numBridgeSlots];
		
		for(String invName : bi.nameToInv.keySet()) {
			int[] slotMapping = bi.slotIndices.get(invName);
			IInventory inv = bi.nameToInv.get(invName);
			
			for(int sourceSlot = 0; sourceSlot < slotMapping.length; sourceSlot++)
				if(slotMapping[sourceSlot] != -1) {
					bi.slotToSourceIndex[slotMapping[sourceSlot]] = sourceSlot;
					bi.slotToSourceInventory[slotMapping[sourceSlot]] = inv;
				}
		}
		
		return bi;
	}
}
