package mods.immibis.core.experimental.mgui1;

import immibis.mgui.MScreenData;
import immibis.mgui.MWindow;
import immibis.mgui.MWorkspace;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerMGUI extends Container {

	MScreenData msd = new MScreenData();
	
	MWorkspace workspace = new MWorkspace(msd);
	
	MWindow mainWindow;
	
	BridgeUtils.BridgeInventory myCombinedInventory;
	
	void initInventories(MWindow w) {
		myCombinedInventory = BridgeUtils.generateBridgeInventory(w);
		
		inventorySlots.clear();
		inventoryItemStacks.clear();
		for(int k = 0; k < myCombinedInventory.getSizeInventory(); k++) {
			addSlotToContainer(new Slot(myCombinedInventory, k, 0, 0));
		}
	}
	
	@Override
	public boolean canInteractWith(EntityPlayer ply) {
		return myCombinedInventory.isUseableByPlayer(ply);
	}

	public void setMainWindow(MWindow w) {
		if(w == null) throw new NullPointerException();
		if(mainWindow != null) throw new IllegalStateException();
		mainWindow = w;
		if(w.getEventHandler() != null)
			initInventories(w);
		workspace.add(w);
	}
	
	@Override
	public void detectAndSendChanges() {
		if(mainWindow != null && mainWindow.getEventHandler() != null) {
			if(myCombinedInventory == null)
				initInventories(mainWindow);
			
			mainWindow.getEventHandler().update();
		}
		
		super.detectAndSendChanges();
	}
	
	@Override
	public ItemStack transferStackInSlot(EntityPlayer p_82846_1_, int p_82846_2_) {
		return null;
	}

}
