package mods.immibis.core.experimental.mgui1;

import immibis.mgui.IControlRenderHook;
import immibis.mgui.MControl;
import immibis.mgui.MItemSlot;
import immibis.mgui.XYValue;

import java.awt.Point;

import org.lwjgl.opengl.GL11;

import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Slot;

public class GuiMGUI extends GuiContainer implements IControlRenderHook {
	public GuiMGUI(ContainerMGUI container) {
		super(container);
	}

	@Override
	protected void drawGuiContainerBackgroundLayer(float var1, int var2, int var3) {
		ContainerMGUI c = (ContainerMGUI)inventorySlots;
		c.msd.cursorPos = new XYValue(var2, var3);
		
		ScaledResolution res = new ScaledResolution(mc, mc.displayWidth, mc.displayHeight);
		c.msd.screenWidth = res.getScaledWidth();
		c.msd.screenHeight = res.getScaledHeight();
		c.msd.renderHook = this;
		
		Point p = c.workspace.getMaximumWindowSize();
		xSize = p.x; ySize = p.y;
		guiLeft = (c.msd.screenWidth - xSize) / 2;
		guiTop = (c.msd.screenHeight - ySize) / 2;
		
		GL11.glDisable(GL11.GL_CULL_FACE);
		c.workspace.render();
		GL11.glEnable(GL11.GL_CULL_FACE);
	}
	
	@Override
	protected void drawGuiContainerForegroundLayer(int p_146979_1_,
		int p_146979_2_) {
		// TODO Auto-generated method stub
		super.drawGuiContainerForegroundLayer(p_146979_1_, p_146979_2_);
	}

	@Override
	public void preRender(MControl c) {
	}

	@Override
	public void postRender(MControl c) {
		if(c instanceof MItemSlot)
			renderItems((MItemSlot)c);
	}
	
	private void renderItems(MItemSlot c) {
		if(c.getIdentifier().equals(""))
			return;
		
		//Method renderSlot = ReflectionHelper.findMethod(GuiContainer.class, this, new String[] {"func_146977_a"}, Slot.class);;
		
		XYValue controlPos = c.getPositionInWorkspace();
		
		int slotIndex = 0;
		for(int y = 0; y < c.height/18; y++) {
			for(int x = 0; x < c.width/18; x++) {
				int combinedInventorySlotIndex = ((ContainerMGUI)inventorySlots).myCombinedInventory.getSlotIndexFor(c.containerSource, slotIndex + c.firstSlot);

				Slot slotObject = (Slot)inventorySlots.inventorySlots.get(combinedInventorySlotIndex);
				slotObject.xDisplayPosition = x*18+1+controlPos.x-guiLeft;
				slotObject.yDisplayPosition = y*18+1+controlPos.y-guiTop;
				slotIndex++;
			}
		}
	}
}
