package mods.immibis.core.experimental.mgui1;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;

import cpw.mods.fml.relauncher.FMLLaunchHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import immibis.mgui.MCommandInterposer;
import immibis.mgui.MEventHandler;
import immibis.mgui.MGUI;
import immibis.mgui.MWindow;
import mods.immibis.core.api.APILocator;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;

public class IC_MGUI {
	
	public static MWindow createWindow(String guiResourcePath, MEventHandler eventHandler) {
		return createWindow(new ResourceLocation(guiResourcePath), eventHandler);
	}
	
	static MWindow createWindow(ResourceLocation loc, MEventHandler eventHandler) {
		try {
			if(FMLLaunchHandler.side().isServer()) {
				try (InputStream in = IC_MGUI.class.getClassLoader().getResourceAsStream("assets/"+loc.getResourceDomain()+"/"+loc.getResourcePath())) {
					return MGUI.createWindowFromStream(in, eventHandler);
				}
			} else {
				try (InputStream in = getClientResourceStream(loc)) {
					return MGUI.createWindowFromStream(in, eventHandler);
				}
			}
		} catch(IOException e) {
			throw new RuntimeException(e);
		}
	}
	
	public static MWindow openGUI(final EntityPlayerMP ply, String guiResourcePath, MEventHandler eventHandler) {
		MWindow w = createWindow(guiResourcePath, eventHandler);
		
		PacketOpenMGUI p = new PacketOpenMGUI();
		p.guifile = new ResourceLocation(guiResourcePath);
		if(!(ply.openContainer instanceof ContainerMGUI)) {
			ply.getNextWindowId();
			ply.openContainer = new ContainerMGUI();
			ply.openContainer.windowId = ply.currentWindowId;
		}
		p.windowID = ply.currentWindowId;
		APILocator.getNetManager().sendToClient(p, ply);
		
		w.setCommandInterposer(new MCommandInterposer() {
			@Override
			public void send(String controlIdentifier, DataWriter data) {
				ByteArrayOutputStream baos = new ByteArrayOutputStream();
				try {
					data.write(new DataOutputStream(baos));
				} catch(IOException e) {
					throw new RuntimeException(e);
				}
				PacketInterposedCommand p = new PacketInterposedCommand();
				p.id = controlIdentifier;
				p.data = baos.toByteArray();
				APILocator.getNetManager().sendToClient(p, ply);
			}
		});
		((ContainerMGUI)ply.openContainer).setMainWindow(w);
		ply.openContainer.addCraftingToCrafters(ply);
		ply.openContainer.detectAndSendChanges();
		
		return w;
	}
	
	private static InputStream getClientResourceStream(ResourceLocation loc) throws IOException {
		return getClientResourceStream2(loc);
	}
	
	@SideOnly(Side.CLIENT)
	private static InputStream getClientResourceStream2(ResourceLocation loc) throws IOException {
		return Minecraft.getMinecraft().getResourceManager().getResource(loc).getInputStream();
	}
}
