/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.imagine.fastdiscover;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.launchwrapper.LaunchClassLoader;
import pw.prok.imagine.fastdiscover.DiscoverCandidate;

public class JarCandidate
extends DiscoverCandidate {
    private final File mJarFile;
    private final boolean mNeedInjection;

    public JarCandidate(File jarFile, boolean needInjection) {
        this.mJarFile = jarFile;
        this.mNeedInjection = needInjection;
    }

    @Override
    public Iterator<InputStream> iterator() {
        return new Iter(this.mJarFile);
    }

    @Override
    public void injectClassLoader(LaunchClassLoader classLoader) {
        if (this.mNeedInjection) {
            try {
                classLoader.addURL(this.mJarFile.toURI().toURL());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    public String toString() {
        return String.valueOf(this.mJarFile);
    }

    private static final class Iter
    implements Iterator<InputStream> {
        private ZipFile mZipFile;
        private Enumeration<? extends ZipEntry> mEntries;
        private InputStream mNextStream;

        public Iter(File jarFile) {
            try {
                this.mZipFile = new ZipFile(jarFile);
                this.mEntries = this.mZipFile.entries();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public boolean hasNext() {
            this.acquire();
            return this.mNextStream != null;
        }

        private void acquire() {
            if (this.mNextStream != null || this.mEntries == null) {
                return;
            }
            while (this.mEntries.hasMoreElements()) {
                ZipEntry entry = this.mEntries.nextElement();
                if (!entry.getName().endsWith(".class")) continue;
                try {
                    this.mNextStream = this.mZipFile.getInputStream(entry);
                }
                catch (IOException iOException) {}
                break;
            }
        }

        @Override
        public InputStream next() {
            this.acquire();
            InputStream is = this.mNextStream;
            this.mNextStream = null;
            return is;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

