/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.imagine.writer;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import pw.prok.imagine.api.ICopyable;

public class Writer {
    public static <T extends ICopyable<T>> T copy(T t) {
        return t != null ? (T)t.copy() : null;
    }

    public static <T extends ICopyable<T>> List<T> copyList(List<T> list) {
        if (list == null) {
            return null;
        }
        LinkedList result = Lists.newLinkedList(list);
        Writer.copyContent(result);
        return result;
    }

    public static <T extends ICopyable<T>> void copyContent(List<T> list) {
        ListIterator<T> iterator = list.listIterator();
        while (iterator.hasNext()) {
            ICopyable t = (ICopyable)iterator.next();
            iterator.set(Writer.copy(t));
        }
    }

    public static <K extends ICopyable<K>, V extends ICopyable<V>> Map<K, V> copyMap(Map<K, V> map) {
        return Writer.copyMap(map, true, true);
    }

    public static <K extends ICopyable<K>, V extends ICopyable<V>> Map<K, V> copyMap(Map<K, V> map, boolean copyKey, boolean copyValue) {
        if (map == null) {
            return null;
        }
        HashMap<K, V> newMap = new HashMap<K, V>(map);
        Writer.copyContent(newMap, copyKey, copyValue);
        return newMap;
    }

    public static <K extends ICopyable<K>, V extends ICopyable<V>> void copyContent(Map<K, V> map, boolean copyKey, boolean copyValue) {
        if (!copyKey && !copyValue) {
            return;
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            ICopyable key = (ICopyable)entry.getKey();
            ICopyable value = (ICopyable)entry.getValue();
            map.remove(key);
            map.put(copyKey ? Writer.copy(key) : key, copyValue ? Writer.copy(value) : value);
        }
    }
}

