/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.CharMatcher;
import com.google.common.base.Platform;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.SmallCharMatcher;
import java.util.Arrays;
import java.util.BitSet;
import javax.annotation.CheckReturnValue;

/*
 * Exception performing whole class analysis ignored.
 */
@Beta
@GwtCompatible(emulated=true)
public abstract class CharMatcher
implements Predicate<Character> {
    public static final CharMatcher BREAKING_WHITESPACE = new /* Unavailable Anonymous Inner Class!! */;
    public static final CharMatcher ASCII = CharMatcher.inRange((char)'\u0000', (char)'\u007f', (String)"CharMatcher.ASCII");
    private static final String ZEROES = "0\u0660\u06f0\u07c0\u0966\u09e6\u0a66\u0ae6\u0b66\u0be6\u0c66\u0ce6\u0d66\u0e50\u0ed0\u0f20\u1040\u1090\u17e0\u1810\u1946\u19d0\u1b50\u1bb0\u1c40\u1c50\ua620\ua8d0\ua900\uaa50\uff10";
    private static final String NINES;
    public static final CharMatcher DIGIT;
    public static final CharMatcher JAVA_DIGIT;
    public static final CharMatcher JAVA_LETTER;
    public static final CharMatcher JAVA_LETTER_OR_DIGIT;
    public static final CharMatcher JAVA_UPPER_CASE;
    public static final CharMatcher JAVA_LOWER_CASE;
    public static final CharMatcher JAVA_ISO_CONTROL;
    public static final CharMatcher INVISIBLE;
    public static final CharMatcher SINGLE_WIDTH;
    public static final CharMatcher ANY;
    public static final CharMatcher NONE;
    final String description;
    private static final int DISTINCT_CHARS = 65536;
    static final String WHITESPACE_TABLE = "\u2002\u3000\r\u0085\u200a\u2005\u2000\u3000\u2029\u000b\u3000\u2008\u2003\u205f\u3000\u1680\t \u2006\u2001\u202f\u00a0\f\u2009\u3000\u2004\u3000\u3000\u2028\n\u2007\u3000";
    static final int WHITESPACE_MULTIPLIER = 1682554634;
    static final int WHITESPACE_SHIFT;
    public static final CharMatcher WHITESPACE;

    private static String showCharacter(char c) {
        String hex = "0123456789ABCDEF";
        char[] tmp = new char[]{'\\', 'u', '\u0000', '\u0000', '\u0000', '\u0000'};
        for (int i = 0; i < 4; ++i) {
            tmp[5 - i] = hex.charAt(c & 0xF);
            c = (char)(c >> 4);
        }
        return String.copyValueOf(tmp);
    }

    public static CharMatcher is(char match) {
        String description = "CharMatcher.is('" + CharMatcher.showCharacter((char)match) + "')";
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static CharMatcher isNot(char match) {
        String description = "CharMatcher.isNot('" + CharMatcher.showCharacter((char)match) + "')";
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static CharMatcher anyOf(CharSequence sequence) {
        switch (sequence.length()) {
            case 0: {
                return NONE;
            }
            case 1: {
                return CharMatcher.is((char)sequence.charAt(0));
            }
            case 2: {
                return CharMatcher.isEither((char)sequence.charAt(0), (char)sequence.charAt(1));
            }
        }
        char[] chars = sequence.toString().toCharArray();
        Arrays.sort(chars);
        StringBuilder description = new StringBuilder("CharMatcher.anyOf(\"");
        for (char c : chars) {
            description.append(CharMatcher.showCharacter((char)c));
        }
        description.append("\")");
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private static CharMatcher isEither(char match1, char match2) {
        String description = "CharMatcher.anyOf(\"" + CharMatcher.showCharacter((char)match1) + CharMatcher.showCharacter((char)match2) + "\")";
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static CharMatcher noneOf(CharSequence sequence) {
        return CharMatcher.anyOf((CharSequence)sequence).negate();
    }

    public static CharMatcher inRange(char startInclusive, char endInclusive) {
        Preconditions.checkArgument((endInclusive >= startInclusive ? 1 : 0) != 0);
        String description = "CharMatcher.inRange('" + CharMatcher.showCharacter((char)startInclusive) + "', '" + CharMatcher.showCharacter((char)endInclusive) + "')";
        return CharMatcher.inRange((char)startInclusive, (char)endInclusive, (String)description);
    }

    static CharMatcher inRange(char startInclusive, char endInclusive, String description) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static CharMatcher forPredicate(Predicate<? super Character> predicate) {
        Preconditions.checkNotNull(predicate);
        if (predicate instanceof CharMatcher) {
            return (CharMatcher)predicate;
        }
        String description = "CharMatcher.forPredicate(" + predicate + ")";
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    CharMatcher(String description) {
        this.description = description;
    }

    protected CharMatcher() {
        this.description = super.toString();
    }

    public abstract boolean matches(char var1);

    public CharMatcher negate() {
        return new NegatedMatcher(this);
    }

    public CharMatcher and(CharMatcher other) {
        return new And(this, (CharMatcher)Preconditions.checkNotNull((Object)other));
    }

    public CharMatcher or(CharMatcher other) {
        return new Or(this, (CharMatcher)Preconditions.checkNotNull((Object)other));
    }

    public CharMatcher precomputed() {
        return Platform.precomputeCharMatcher((CharMatcher)this);
    }

    CharMatcher withToString(String description) {
        throw new UnsupportedOperationException();
    }

    @GwtIncompatible(value="java.util.BitSet")
    CharMatcher precomputedInternal() {
        BitSet table = new BitSet();
        this.setBits(table);
        int totalCharacters = table.cardinality();
        if (totalCharacters * 2 <= 65536) {
            return CharMatcher.precomputedPositive((int)totalCharacters, (BitSet)table, (String)this.description);
        }
        table.flip(0, 65536);
        int negatedCharacters = 65536 - totalCharacters;
        String suffix = ".negate()";
        String negatedDescription = this.description.endsWith(suffix) ? this.description.substring(0, this.description.length() - suffix.length()) : this.description + suffix;
        return new NegatedFastMatcher(this.toString(), CharMatcher.precomputedPositive((int)negatedCharacters, (BitSet)table, (String)negatedDescription));
    }

    @GwtIncompatible(value="java.util.BitSet")
    private static CharMatcher precomputedPositive(int totalCharacters, BitSet table, String description) {
        switch (totalCharacters) {
            case 0: {
                return NONE;
            }
            case 1: {
                return CharMatcher.is((char)((char)table.nextSetBit(0)));
            }
            case 2: {
                char c1 = (char)table.nextSetBit(0);
                char c2 = (char)table.nextSetBit(c1 + '\u0001');
                return CharMatcher.isEither((char)c1, (char)c2);
            }
        }
        return CharMatcher.isSmall((int)totalCharacters, (int)table.length()) ? SmallCharMatcher.from((BitSet)table, (String)description) : new BitSetMatcher(table, description, null);
    }

    @GwtIncompatible(value="SmallCharMatcher")
    private static boolean isSmall(int totalCharacters, int tableLength) {
        return totalCharacters <= 1023 && tableLength > totalCharacters * 4 * 16;
    }

    @GwtIncompatible(value="java.util.BitSet")
    void setBits(BitSet table) {
        for (int c = 65535; c >= 0; --c) {
            if (!this.matches((char)c)) continue;
            table.set(c);
        }
    }

    public boolean matchesAnyOf(CharSequence sequence) {
        return !this.matchesNoneOf(sequence);
    }

    public boolean matchesAllOf(CharSequence sequence) {
        for (int i = sequence.length() - 1; i >= 0; --i) {
            if (this.matches(sequence.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean matchesNoneOf(CharSequence sequence) {
        return this.indexIn(sequence) == -1;
    }

    public int indexIn(CharSequence sequence) {
        int length = sequence.length();
        for (int i = 0; i < length; ++i) {
            if (!this.matches(sequence.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public int indexIn(CharSequence sequence, int start) {
        int length = sequence.length();
        Preconditions.checkPositionIndex((int)start, (int)length);
        for (int i = start; i < length; ++i) {
            if (!this.matches(sequence.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexIn(CharSequence sequence) {
        for (int i = sequence.length() - 1; i >= 0; --i) {
            if (!this.matches(sequence.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public int countIn(CharSequence sequence) {
        int count = 0;
        for (int i = 0; i < sequence.length(); ++i) {
            if (!this.matches(sequence.charAt(i))) continue;
            ++count;
        }
        return count;
    }

    @CheckReturnValue
    public String removeFrom(CharSequence sequence) {
        String string = sequence.toString();
        int pos = this.indexIn((CharSequence)string);
        if (pos == -1) {
            return string;
        }
        char[] chars = string.toCharArray();
        int spread = 1;
        block0: while (true) {
            ++pos;
            while (pos != chars.length) {
                if (!this.matches(chars[pos])) {
                    chars[pos - spread] = chars[pos];
                    ++pos;
                    continue;
                }
                ++spread;
                continue block0;
            }
            break;
        }
        return new String(chars, 0, pos - spread);
    }

    @CheckReturnValue
    public String retainFrom(CharSequence sequence) {
        return this.negate().removeFrom(sequence);
    }

    @CheckReturnValue
    public String replaceFrom(CharSequence sequence, char replacement) {
        String string = sequence.toString();
        int pos = this.indexIn((CharSequence)string);
        if (pos == -1) {
            return string;
        }
        char[] chars = string.toCharArray();
        chars[pos] = replacement;
        for (int i = pos + 1; i < chars.length; ++i) {
            if (!this.matches(chars[i])) continue;
            chars[i] = replacement;
        }
        return new String(chars);
    }

    @CheckReturnValue
    public String replaceFrom(CharSequence sequence, CharSequence replacement) {
        int replacementLen = replacement.length();
        if (replacementLen == 0) {
            return this.removeFrom(sequence);
        }
        if (replacementLen == 1) {
            return this.replaceFrom(sequence, replacement.charAt(0));
        }
        String string = sequence.toString();
        int pos = this.indexIn((CharSequence)string);
        if (pos == -1) {
            return string;
        }
        int len = string.length();
        StringBuilder buf = new StringBuilder(len * 3 / 2 + 16);
        int oldpos = 0;
        do {
            buf.append(string, oldpos, pos);
            buf.append(replacement);
        } while ((pos = this.indexIn((CharSequence)string, oldpos = pos + 1)) != -1);
        buf.append(string, oldpos, len);
        return buf.toString();
    }

    @CheckReturnValue
    public String trimFrom(CharSequence sequence) {
        int last;
        int first;
        int len = sequence.length();
        for (first = 0; first < len && this.matches(sequence.charAt(first)); ++first) {
        }
        for (last = len - 1; last > first && this.matches(sequence.charAt(last)); --last) {
        }
        return sequence.subSequence(first, last + 1).toString();
    }

    @CheckReturnValue
    public String trimLeadingFrom(CharSequence sequence) {
        int len = sequence.length();
        for (int first = 0; first < len; ++first) {
            if (this.matches(sequence.charAt(first))) continue;
            return sequence.subSequence(first, len).toString();
        }
        return "";
    }

    @CheckReturnValue
    public String trimTrailingFrom(CharSequence sequence) {
        int len = sequence.length();
        for (int last = len - 1; last >= 0; --last) {
            if (this.matches(sequence.charAt(last))) continue;
            return sequence.subSequence(0, last + 1).toString();
        }
        return "";
    }

    @CheckReturnValue
    public String collapseFrom(CharSequence sequence, char replacement) {
        int len = sequence.length();
        for (int i = 0; i < len; ++i) {
            char c = sequence.charAt(i);
            if (!this.matches(c)) continue;
            if (!(c != replacement || i != len - 1 && this.matches(sequence.charAt(i + 1)))) {
                ++i;
                continue;
            }
            StringBuilder builder = new StringBuilder(len).append(sequence.subSequence(0, i)).append(replacement);
            return this.finishCollapseFrom(sequence, i + 1, len, replacement, builder, true);
        }
        return sequence.toString();
    }

    @CheckReturnValue
    public String trimAndCollapseFrom(CharSequence sequence, char replacement) {
        int last;
        int first;
        int len = sequence.length();
        for (first = 0; first < len && this.matches(sequence.charAt(first)); ++first) {
        }
        for (last = len - 1; last > first && this.matches(sequence.charAt(last)); --last) {
        }
        return first == 0 && last == len - 1 ? this.collapseFrom(sequence, replacement) : this.finishCollapseFrom(sequence, first, last + 1, replacement, new StringBuilder(last + 1 - first), false);
    }

    private String finishCollapseFrom(CharSequence sequence, int start, int end, char replacement, StringBuilder builder, boolean inMatchingGroup) {
        for (int i = start; i < end; ++i) {
            char c = sequence.charAt(i);
            if (this.matches(c)) {
                if (inMatchingGroup) continue;
                builder.append(replacement);
                inMatchingGroup = true;
                continue;
            }
            builder.append(c);
            inMatchingGroup = false;
        }
        return builder.toString();
    }

    @Deprecated
    public boolean apply(Character character) {
        return this.matches(character.charValue());
    }

    public String toString() {
        return this.description;
    }

    static {
        StringBuilder builder = new StringBuilder("0\u0660\u06f0\u07c0\u0966\u09e6\u0a66\u0ae6\u0b66\u0be6\u0c66\u0ce6\u0d66\u0e50\u0ed0\u0f20\u1040\u1090\u17e0\u1810\u1946\u19d0\u1b50\u1bb0\u1c40\u1c50\ua620\ua8d0\ua900\uaa50\uff10".length());
        for (int i = 0; i < "0\u0660\u06f0\u07c0\u0966\u09e6\u0a66\u0ae6\u0b66\u0be6\u0c66\u0ce6\u0d66\u0e50\u0ed0\u0f20\u1040\u1090\u17e0\u1810\u1946\u19d0\u1b50\u1bb0\u1c40\u1c50\ua620\ua8d0\ua900\uaa50\uff10".length(); ++i) {
            builder.append((char)("0\u0660\u06f0\u07c0\u0966\u09e6\u0a66\u0ae6\u0b66\u0be6\u0c66\u0ce6\u0d66\u0e50\u0ed0\u0f20\u1040\u1090\u17e0\u1810\u1946\u19d0\u1b50\u1bb0\u1c40\u1c50\ua620\ua8d0\ua900\uaa50\uff10".charAt(i) + 9));
        }
        NINES = builder.toString();
        DIGIT = new RangesMatcher("CharMatcher.DIGIT", "0\u0660\u06f0\u07c0\u0966\u09e6\u0a66\u0ae6\u0b66\u0be6\u0c66\u0ce6\u0d66\u0e50\u0ed0\u0f20\u1040\u1090\u17e0\u1810\u1946\u19d0\u1b50\u1bb0\u1c40\u1c50\ua620\ua8d0\ua900\uaa50\uff10".toCharArray(), NINES.toCharArray());
        JAVA_DIGIT = new /* Unavailable Anonymous Inner Class!! */;
        JAVA_LETTER = new /* Unavailable Anonymous Inner Class!! */;
        JAVA_LETTER_OR_DIGIT = new /* Unavailable Anonymous Inner Class!! */;
        JAVA_UPPER_CASE = new /* Unavailable Anonymous Inner Class!! */;
        JAVA_LOWER_CASE = new /* Unavailable Anonymous Inner Class!! */;
        JAVA_ISO_CONTROL = CharMatcher.inRange((char)'\u0000', (char)'\u001f').or(CharMatcher.inRange((char)'\u007f', (char)'\u009f')).withToString("CharMatcher.JAVA_ISO_CONTROL");
        INVISIBLE = new RangesMatcher("CharMatcher.INVISIBLE", "\u0000\u007f\u00ad\u0600\u061c\u06dd\u070f\u1680\u180e\u2000\u2028\u205f\u2066\u2067\u2068\u2069\u206a\u3000\ud800\ufeff\ufff9\ufffa".toCharArray(), " \u00a0\u00ad\u0604\u061c\u06dd\u070f\u1680\u180e\u200f\u202f\u2064\u2066\u2067\u2068\u2069\u206f\u3000\uf8ff\ufeff\ufff9\ufffb".toCharArray());
        SINGLE_WIDTH = new RangesMatcher("CharMatcher.SINGLE_WIDTH", "\u0000\u05be\u05d0\u05f3\u0600\u0750\u0e00\u1e00\u2100\ufb50\ufe70\uff61".toCharArray(), "\u04f9\u05be\u05ea\u05f4\u06ff\u077f\u0e7f\u20af\u213a\ufdff\ufeff\uffdc".toCharArray());
        ANY = new /* Unavailable Anonymous Inner Class!! */;
        NONE = new /* Unavailable Anonymous Inner Class!! */;
        WHITESPACE_SHIFT = Integer.numberOfLeadingZeros("\u2002\u3000\r\u0085\u200a\u2005\u2000\u3000\u2029\u000b\u3000\u2008\u2003\u205f\u3000\u1680\t \u2006\u2001\u202f\u00a0\f\u2009\u3000\u2004\u3000\u3000\u2028\n\u2007\u3000".length() - 1);
        WHITESPACE = new /* Unavailable Anonymous Inner Class!! */;
    }
}

