/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.DenseImmutableTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.RegularImmutableTable;
import com.google.common.collect.Table;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

/*
 * Exception performing whole class analysis ignored.
 */
@GwtCompatible
@Immutable
final class DenseImmutableTable<R, C, V>
extends RegularImmutableTable<R, C, V> {
    private final ImmutableMap<R, Integer> rowKeyToIndex;
    private final ImmutableMap<C, Integer> columnKeyToIndex;
    private final ImmutableMap<R, Map<C, V>> rowMap;
    private final ImmutableMap<C, Map<R, V>> columnMap;
    private final int[] rowCounts;
    private final int[] columnCounts;
    private final V[][] values;
    private final int[] iterationOrderRow;
    private final int[] iterationOrderColumn;

    private static <E> ImmutableMap<E, Integer> makeIndex(ImmutableSet<E> set) {
        ImmutableMap.Builder indexBuilder = ImmutableMap.builder();
        int i = 0;
        for (Object key : set) {
            indexBuilder.put(key, (Object)i);
            ++i;
        }
        return indexBuilder.build();
    }

    DenseImmutableTable(ImmutableList<Table.Cell<R, C, V>> cellList, ImmutableSet<R> rowSpace, ImmutableSet<C> columnSpace) {
        Object[][] array = new Object[rowSpace.size()][columnSpace.size()];
        this.values = array;
        this.rowKeyToIndex = DenseImmutableTable.makeIndex(rowSpace);
        this.columnKeyToIndex = DenseImmutableTable.makeIndex(columnSpace);
        this.rowCounts = new int[this.rowKeyToIndex.size()];
        this.columnCounts = new int[this.columnKeyToIndex.size()];
        int[] iterationOrderRow = new int[cellList.size()];
        int[] iterationOrderColumn = new int[cellList.size()];
        for (int i = 0; i < cellList.size(); ++i) {
            int columnIndex;
            Table.Cell cell = (Table.Cell)cellList.get(i);
            Object rowKey = cell.getRowKey();
            Object columnKey = cell.getColumnKey();
            int rowIndex = (Integer)this.rowKeyToIndex.get(rowKey);
            Object existingValue = this.values[rowIndex][columnIndex = ((Integer)this.columnKeyToIndex.get(columnKey)).intValue()];
            Preconditions.checkArgument((existingValue == null ? 1 : 0) != 0, (String)"duplicate key: (%s, %s)", (Object[])new Object[]{rowKey, columnKey});
            this.values[rowIndex][columnIndex] = cell.getValue();
            int n = rowIndex;
            this.rowCounts[n] = this.rowCounts[n] + 1;
            int n2 = columnIndex;
            this.columnCounts[n2] = this.columnCounts[n2] + 1;
            iterationOrderRow[i] = rowIndex;
            iterationOrderColumn[i] = columnIndex;
        }
        this.iterationOrderRow = iterationOrderRow;
        this.iterationOrderColumn = iterationOrderColumn;
        this.rowMap = new RowMap(this, null);
        this.columnMap = new ColumnMap(this, null);
    }

    public ImmutableMap<C, Map<R, V>> columnMap() {
        return this.columnMap;
    }

    public ImmutableMap<R, Map<C, V>> rowMap() {
        return this.rowMap;
    }

    public V get(@Nullable Object rowKey, @Nullable Object columnKey) {
        Integer rowIndex = (Integer)this.rowKeyToIndex.get(rowKey);
        Integer columnIndex = (Integer)this.columnKeyToIndex.get(columnKey);
        return (V)(rowIndex == null || columnIndex == null ? null : this.values[rowIndex][columnIndex]);
    }

    public int size() {
        return this.iterationOrderRow.length;
    }

    Table.Cell<R, C, V> getCell(int index) {
        int rowIndex = this.iterationOrderRow[index];
        int columnIndex = this.iterationOrderColumn[index];
        Object rowKey = this.rowKeySet().asList().get(rowIndex);
        Object columnKey = this.columnKeySet().asList().get(columnIndex);
        Object value = this.values[rowIndex][columnIndex];
        return DenseImmutableTable.cellOf((Object)rowKey, (Object)columnKey, (Object)value);
    }

    V getValue(int index) {
        return (V)this.values[this.iterationOrderRow[index]][this.iterationOrderColumn[index]];
    }

    static /* synthetic */ int[] access$200(DenseImmutableTable x0) {
        return x0.rowCounts;
    }

    static /* synthetic */ ImmutableMap access$300(DenseImmutableTable x0) {
        return x0.columnKeyToIndex;
    }

    static /* synthetic */ Object[][] access$400(DenseImmutableTable x0) {
        return x0.values;
    }

    static /* synthetic */ int[] access$500(DenseImmutableTable x0) {
        return x0.columnCounts;
    }

    static /* synthetic */ ImmutableMap access$600(DenseImmutableTable x0) {
        return x0.rowKeyToIndex;
    }
}

