/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Objects;
import com.google.common.collect.ForwardingCollection;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;

@GwtCompatible
public abstract class ForwardingMultiset<E>
extends ForwardingCollection<E>
implements Multiset<E> {
    protected ForwardingMultiset() {
    }

    protected abstract Multiset<E> delegate();

    public int count(Object element) {
        return this.delegate().count(element);
    }

    public int add(E element, int occurrences) {
        return this.delegate().add(element, occurrences);
    }

    public int remove(Object element, int occurrences) {
        return this.delegate().remove(element, occurrences);
    }

    public Set<E> elementSet() {
        return this.delegate().elementSet();
    }

    public Set<Multiset.Entry<E>> entrySet() {
        return this.delegate().entrySet();
    }

    public boolean equals(@Nullable Object object) {
        return object == this || this.delegate().equals(object);
    }

    public int hashCode() {
        return this.delegate().hashCode();
    }

    public int setCount(E element, int count) {
        return this.delegate().setCount(element, count);
    }

    public boolean setCount(E element, int oldCount, int newCount) {
        return this.delegate().setCount(element, oldCount, newCount);
    }

    protected boolean standardContains(@Nullable Object object) {
        return this.count(object) > 0;
    }

    protected void standardClear() {
        Iterators.clear(this.entrySet().iterator());
    }

    @Beta
    protected int standardCount(@Nullable Object object) {
        for (Multiset.Entry entry : this.entrySet()) {
            if (!Objects.equal((Object)entry.getElement(), (Object)object)) continue;
            return entry.getCount();
        }
        return 0;
    }

    protected boolean standardAdd(E element) {
        this.add(element, 1);
        return true;
    }

    @Beta
    protected boolean standardAddAll(Collection<? extends E> elementsToAdd) {
        return Multisets.addAllImpl((Multiset)this, elementsToAdd);
    }

    protected boolean standardRemove(Object element) {
        return this.remove(element, 1) > 0;
    }

    protected boolean standardRemoveAll(Collection<?> elementsToRemove) {
        return Multisets.removeAllImpl((Multiset)this, elementsToRemove);
    }

    protected boolean standardRetainAll(Collection<?> elementsToRetain) {
        return Multisets.retainAllImpl((Multiset)this, elementsToRetain);
    }

    protected int standardSetCount(E element, int count) {
        return Multisets.setCountImpl((Multiset)this, element, (int)count);
    }

    protected boolean standardSetCount(E element, int oldCount, int newCount) {
        return Multisets.setCountImpl((Multiset)this, element, (int)oldCount, (int)newCount);
    }

    protected Iterator<E> standardIterator() {
        return Multisets.iteratorImpl((Multiset)this);
    }

    protected int standardSize() {
        return Multisets.sizeImpl((Multiset)this);
    }

    protected boolean standardEquals(@Nullable Object object) {
        return Multisets.equalsImpl((Multiset)this, (Object)object);
    }

    protected int standardHashCode() {
        return this.entrySet().hashCode();
    }

    protected String standardToString() {
        return this.entrySet().toString();
    }
}

