/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Objects;
import com.google.common.collect.BiMap;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Hashing;
import com.google.common.collect.Serialization;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
@GwtCompatible(emulated=true)
public final class HashBiMap<K, V>
extends AbstractMap<K, V>
implements BiMap<K, V>,
Serializable {
    private static final double LOAD_FACTOR = 1.0;
    private transient BiEntry<K, V>[] hashTableKToV;
    private transient BiEntry<K, V>[] hashTableVToK;
    private transient int size;
    private transient int mask;
    private transient int modCount;
    private transient BiMap<V, K> inverse;
    @GwtIncompatible(value="Not needed in emulated source")
    private static final long serialVersionUID = 0L;

    public static <K, V> HashBiMap<K, V> create() {
        return HashBiMap.create((int)16);
    }

    public static <K, V> HashBiMap<K, V> create(int expectedSize) {
        return new HashBiMap(expectedSize);
    }

    public static <K, V> HashBiMap<K, V> create(Map<? extends K, ? extends V> map) {
        HashBiMap bimap = HashBiMap.create((int)map.size());
        bimap.putAll(map);
        return bimap;
    }

    private HashBiMap(int expectedSize) {
        this.init(expectedSize);
    }

    private void init(int expectedSize) {
        CollectPreconditions.checkNonnegative((int)expectedSize, (String)"expectedSize");
        int tableSize = Hashing.closedTableSize((int)expectedSize, (double)1.0);
        this.hashTableKToV = this.createTable(tableSize);
        this.hashTableVToK = this.createTable(tableSize);
        this.mask = tableSize - 1;
        this.modCount = 0;
        this.size = 0;
    }

    private void delete(BiEntry<K, V> entry) {
        int keyBucket = entry.keyHash & this.mask;
        BiEntry prevBucketEntry = null;
        BiEntry bucketEntry = this.hashTableKToV[keyBucket];
        while (true) {
            if (bucketEntry == entry) {
                if (prevBucketEntry == null) {
                    this.hashTableKToV[keyBucket] = entry.nextInKToVBucket;
                    break;
                }
                prevBucketEntry.nextInKToVBucket = entry.nextInKToVBucket;
                break;
            }
            prevBucketEntry = bucketEntry;
            bucketEntry = bucketEntry.nextInKToVBucket;
        }
        int valueBucket = entry.valueHash & this.mask;
        prevBucketEntry = null;
        BiEntry bucketEntry2 = this.hashTableVToK[valueBucket];
        while (true) {
            if (bucketEntry2 == entry) {
                if (prevBucketEntry == null) {
                    this.hashTableVToK[valueBucket] = entry.nextInVToKBucket;
                    break;
                }
                prevBucketEntry.nextInVToKBucket = entry.nextInVToKBucket;
                break;
            }
            prevBucketEntry = bucketEntry2;
            bucketEntry2 = bucketEntry2.nextInVToKBucket;
        }
        --this.size;
        ++this.modCount;
    }

    private void insert(BiEntry<K, V> entry) {
        int keyBucket = entry.keyHash & this.mask;
        entry.nextInKToVBucket = this.hashTableKToV[keyBucket];
        this.hashTableKToV[keyBucket] = entry;
        int valueBucket = entry.valueHash & this.mask;
        entry.nextInVToKBucket = this.hashTableVToK[valueBucket];
        this.hashTableVToK[valueBucket] = entry;
        ++this.size;
        ++this.modCount;
    }

    private static int hash(@Nullable Object o) {
        return Hashing.smear((int)(o == null ? 0 : o.hashCode()));
    }

    private BiEntry<K, V> seekByKey(@Nullable Object key, int keyHash) {
        BiEntry entry = this.hashTableKToV[keyHash & this.mask];
        while (entry != null) {
            if (keyHash == entry.keyHash && Objects.equal((Object)key, (Object)entry.key)) {
                return entry;
            }
            entry = entry.nextInKToVBucket;
        }
        return null;
    }

    private BiEntry<K, V> seekByValue(@Nullable Object value, int valueHash) {
        BiEntry entry = this.hashTableVToK[valueHash & this.mask];
        while (entry != null) {
            if (valueHash == entry.valueHash && Objects.equal((Object)value, (Object)entry.value)) {
                return entry;
            }
            entry = entry.nextInVToKBucket;
        }
        return null;
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        return this.seekByKey(key, HashBiMap.hash((Object)key)) != null;
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        return this.seekByValue(value, HashBiMap.hash((Object)value)) != null;
    }

    @Override
    @Nullable
    public V get(@Nullable Object key) {
        BiEntry entry = this.seekByKey(key, HashBiMap.hash((Object)key));
        return (V)(entry == null ? null : entry.value);
    }

    @Override
    public V put(@Nullable K key, @Nullable V value) {
        return (V)this.put(key, value, false);
    }

    public V forcePut(@Nullable K key, @Nullable V value) {
        return (V)this.put(key, value, true);
    }

    private V put(@Nullable K key, @Nullable V value, boolean force) {
        int keyHash = HashBiMap.hash(key);
        int valueHash = HashBiMap.hash(value);
        BiEntry oldEntryForKey = this.seekByKey(key, keyHash);
        if (oldEntryForKey != null && valueHash == oldEntryForKey.valueHash && Objects.equal(value, (Object)oldEntryForKey.value)) {
            return value;
        }
        BiEntry oldEntryForValue = this.seekByValue(value, valueHash);
        if (oldEntryForValue != null) {
            if (force) {
                this.delete(oldEntryForValue);
            } else {
                throw new IllegalArgumentException("value already present: " + value);
            }
        }
        if (oldEntryForKey != null) {
            this.delete(oldEntryForKey);
        }
        BiEntry newEntry = new BiEntry(key, keyHash, value, valueHash);
        this.insert(newEntry);
        this.rehashIfNecessary();
        return (V)(oldEntryForKey == null ? null : oldEntryForKey.value);
    }

    @Nullable
    private K putInverse(@Nullable V value, @Nullable K key, boolean force) {
        int valueHash = HashBiMap.hash(value);
        int keyHash = HashBiMap.hash(key);
        BiEntry oldEntryForValue = this.seekByValue(value, valueHash);
        if (oldEntryForValue != null && keyHash == oldEntryForValue.keyHash && Objects.equal(key, (Object)oldEntryForValue.key)) {
            return key;
        }
        BiEntry oldEntryForKey = this.seekByKey(key, keyHash);
        if (oldEntryForKey != null) {
            if (force) {
                this.delete(oldEntryForKey);
            } else {
                throw new IllegalArgumentException("value already present: " + key);
            }
        }
        if (oldEntryForValue != null) {
            this.delete(oldEntryForValue);
        }
        BiEntry newEntry = new BiEntry(key, keyHash, value, valueHash);
        this.insert(newEntry);
        this.rehashIfNecessary();
        return (K)(oldEntryForValue == null ? null : oldEntryForValue.key);
    }

    private void rehashIfNecessary() {
        BiEntry[] oldKToV = this.hashTableKToV;
        if (Hashing.needsResizing((int)this.size, (int)oldKToV.length, (double)1.0)) {
            int newTableSize = oldKToV.length * 2;
            this.hashTableKToV = this.createTable(newTableSize);
            this.hashTableVToK = this.createTable(newTableSize);
            this.mask = newTableSize - 1;
            this.size = 0;
            for (int bucket = 0; bucket < oldKToV.length; ++bucket) {
                BiEntry entry = oldKToV[bucket];
                while (entry != null) {
                    BiEntry nextEntry = entry.nextInKToVBucket;
                    this.insert(entry);
                    entry = nextEntry;
                }
            }
            ++this.modCount;
        }
    }

    private BiEntry<K, V>[] createTable(int length) {
        return new BiEntry[length];
    }

    @Override
    public V remove(@Nullable Object key) {
        BiEntry entry = this.seekByKey(key, HashBiMap.hash((Object)key));
        if (entry == null) {
            return null;
        }
        this.delete(entry);
        return (V)entry.value;
    }

    @Override
    public void clear() {
        this.size = 0;
        Arrays.fill(this.hashTableKToV, null);
        Arrays.fill(this.hashTableVToK, null);
        ++this.modCount;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Set<K> keySet() {
        return new KeySet(this);
    }

    @Override
    public Set<V> values() {
        return this.inverse().keySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet(this, null);
    }

    public BiMap<V, K> inverse() {
        return this.inverse == null ? (this.inverse = new Inverse(this, null)) : this.inverse;
    }

    @GwtIncompatible(value="java.io.ObjectOutputStream")
    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        Serialization.writeMap((Map)this, (ObjectOutputStream)stream);
    }

    @GwtIncompatible(value="java.io.ObjectInputStream")
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = Serialization.readCount((ObjectInputStream)stream);
        this.init(size);
        Serialization.populateMap((Map)this, (ObjectInputStream)stream, (int)size);
    }

    static /* synthetic */ int access$000(HashBiMap x0) {
        return x0.modCount;
    }

    static /* synthetic */ BiEntry[] access$100(HashBiMap x0) {
        return x0.hashTableKToV;
    }

    static /* synthetic */ void access$200(HashBiMap x0, BiEntry x1) {
        x0.delete(x1);
    }

    static /* synthetic */ int access$300(Object x0) {
        return HashBiMap.hash((Object)x0);
    }

    static /* synthetic */ BiEntry access$400(HashBiMap x0, Object x1, int x2) {
        return x0.seekByKey(x1, x2);
    }

    static /* synthetic */ BiEntry access$600(HashBiMap x0, Object x1, int x2) {
        return x0.seekByValue(x1, x2);
    }

    static /* synthetic */ void access$700(HashBiMap x0, BiEntry x1) {
        x0.insert(x1);
    }

    static /* synthetic */ int access$900(HashBiMap x0) {
        return x0.size;
    }

    static /* synthetic */ Object access$1000(HashBiMap x0, Object x1, Object x2, boolean x3) {
        return x0.putInverse(x1, x2, x3);
    }
}

