/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractTable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.RegularImmutableTable;
import com.google.common.collect.SingletonImmutableTable;
import com.google.common.collect.SparseImmutableTable;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
@GwtCompatible
public abstract class ImmutableTable<R, C, V>
extends AbstractTable<R, C, V> {
    private static final ImmutableTable<Object, Object, Object> EMPTY = new SparseImmutableTable(ImmutableList.of(), ImmutableSet.of(), ImmutableSet.of());

    public static <R, C, V> ImmutableTable<R, C, V> of() {
        return EMPTY;
    }

    public static <R, C, V> ImmutableTable<R, C, V> of(R rowKey, C columnKey, V value) {
        return new SingletonImmutableTable(rowKey, columnKey, value);
    }

    public static <R, C, V> ImmutableTable<R, C, V> copyOf(Table<? extends R, ? extends C, ? extends V> table) {
        if (table instanceof ImmutableTable) {
            ImmutableTable parameterizedTable = (ImmutableTable)table;
            return parameterizedTable;
        }
        int size = table.size();
        switch (size) {
            case 0: {
                return ImmutableTable.of();
            }
            case 1: {
                Table.Cell onlyCell = (Table.Cell)Iterables.getOnlyElement((Iterable)table.cellSet());
                return ImmutableTable.of((Object)onlyCell.getRowKey(), (Object)onlyCell.getColumnKey(), (Object)onlyCell.getValue());
            }
        }
        ImmutableSet.Builder cellSetBuilder = ImmutableSet.builder();
        for (Table.Cell cell : table.cellSet()) {
            cellSetBuilder.add((Object)ImmutableTable.cellOf((Object)cell.getRowKey(), (Object)cell.getColumnKey(), (Object)cell.getValue()));
        }
        return RegularImmutableTable.forCells((Iterable)cellSetBuilder.build());
    }

    public static <R, C, V> Builder<R, C, V> builder() {
        return new Builder();
    }

    static <R, C, V> Table.Cell<R, C, V> cellOf(R rowKey, C columnKey, V value) {
        return Tables.immutableCell((Object)Preconditions.checkNotNull(rowKey), (Object)Preconditions.checkNotNull(columnKey), (Object)Preconditions.checkNotNull(value));
    }

    ImmutableTable() {
    }

    public ImmutableSet<Table.Cell<R, C, V>> cellSet() {
        return (ImmutableSet)super.cellSet();
    }

    abstract ImmutableSet<Table.Cell<R, C, V>> createCellSet();

    final UnmodifiableIterator<Table.Cell<R, C, V>> cellIterator() {
        throw new AssertionError((Object)"should never be called");
    }

    public ImmutableCollection<V> values() {
        return (ImmutableCollection)super.values();
    }

    abstract ImmutableCollection<V> createValues();

    final Iterator<V> valuesIterator() {
        throw new AssertionError((Object)"should never be called");
    }

    public ImmutableMap<R, V> column(C columnKey) {
        Preconditions.checkNotNull(columnKey);
        return (ImmutableMap)Objects.firstNonNull((Object)((ImmutableMap)this.columnMap().get(columnKey)), (Object)ImmutableMap.of());
    }

    public ImmutableSet<C> columnKeySet() {
        return this.columnMap().keySet();
    }

    public abstract ImmutableMap<C, Map<R, V>> columnMap();

    public ImmutableMap<C, V> row(R rowKey) {
        Preconditions.checkNotNull(rowKey);
        return (ImmutableMap)Objects.firstNonNull((Object)((ImmutableMap)this.rowMap().get(rowKey)), (Object)ImmutableMap.of());
    }

    public ImmutableSet<R> rowKeySet() {
        return this.rowMap().keySet();
    }

    public abstract ImmutableMap<R, Map<C, V>> rowMap();

    public boolean contains(@Nullable Object rowKey, @Nullable Object columnKey) {
        return this.get(rowKey, columnKey) != null;
    }

    public boolean containsValue(@Nullable Object value) {
        return this.values().contains(value);
    }

    @Deprecated
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final V put(R rowKey, C columnKey, V value) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final void putAll(Table<? extends R, ? extends C, ? extends V> table) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final V remove(Object rowKey, Object columnKey) {
        throw new UnsupportedOperationException();
    }
}

