/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Ascii;
import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.google.common.collect.GenericMapMaker;
import com.google.common.collect.MapMaker;
import com.google.common.collect.MapMakerInternalMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

@GwtCompatible(emulated=true)
public final class MapMaker
extends GenericMapMaker<Object, Object> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int DEFAULT_CONCURRENCY_LEVEL = 4;
    private static final int DEFAULT_EXPIRATION_NANOS = 0;
    static final int UNSET_INT = -1;
    boolean useCustomMap;
    int initialCapacity = -1;
    int concurrencyLevel = -1;
    int maximumSize = -1;
    MapMakerInternalMap.Strength keyStrength;
    MapMakerInternalMap.Strength valueStrength;
    long expireAfterWriteNanos = -1L;
    long expireAfterAccessNanos = -1L;
    RemovalCause nullRemovalCause;
    Equivalence<Object> keyEquivalence;
    Ticker ticker;

    @GwtIncompatible(value="To be supported")
    MapMaker keyEquivalence(Equivalence<Object> equivalence) {
        Preconditions.checkState((this.keyEquivalence == null ? 1 : 0) != 0, (String)"key equivalence was already set to %s", (Object[])new Object[]{this.keyEquivalence});
        this.keyEquivalence = (Equivalence)Preconditions.checkNotNull(equivalence);
        this.useCustomMap = true;
        return this;
    }

    Equivalence<Object> getKeyEquivalence() {
        return (Equivalence)Objects.firstNonNull((Object)this.keyEquivalence, (Object)this.getKeyStrength().defaultEquivalence());
    }

    public MapMaker initialCapacity(int initialCapacity) {
        Preconditions.checkState((this.initialCapacity == -1 ? 1 : 0) != 0, (String)"initial capacity was already set to %s", (Object[])new Object[]{this.initialCapacity});
        Preconditions.checkArgument((initialCapacity >= 0 ? 1 : 0) != 0);
        this.initialCapacity = initialCapacity;
        return this;
    }

    int getInitialCapacity() {
        return this.initialCapacity == -1 ? 16 : this.initialCapacity;
    }

    @Deprecated
    MapMaker maximumSize(int size) {
        Preconditions.checkState((this.maximumSize == -1 ? 1 : 0) != 0, (String)"maximum size was already set to %s", (Object[])new Object[]{this.maximumSize});
        Preconditions.checkArgument((size >= 0 ? 1 : 0) != 0, (Object)"maximum size must not be negative");
        this.maximumSize = size;
        this.useCustomMap = true;
        if (this.maximumSize == 0) {
            this.nullRemovalCause = RemovalCause.SIZE;
        }
        return this;
    }

    public MapMaker concurrencyLevel(int concurrencyLevel) {
        Preconditions.checkState((this.concurrencyLevel == -1 ? 1 : 0) != 0, (String)"concurrency level was already set to %s", (Object[])new Object[]{this.concurrencyLevel});
        Preconditions.checkArgument((concurrencyLevel > 0 ? 1 : 0) != 0);
        this.concurrencyLevel = concurrencyLevel;
        return this;
    }

    int getConcurrencyLevel() {
        return this.concurrencyLevel == -1 ? 4 : this.concurrencyLevel;
    }

    @GwtIncompatible(value="java.lang.ref.WeakReference")
    public MapMaker weakKeys() {
        return this.setKeyStrength(MapMakerInternalMap.Strength.WEAK);
    }

    MapMaker setKeyStrength(MapMakerInternalMap.Strength strength) {
        Preconditions.checkState((this.keyStrength == null ? 1 : 0) != 0, (String)"Key strength was already set to %s", (Object[])new Object[]{this.keyStrength});
        this.keyStrength = (MapMakerInternalMap.Strength)Preconditions.checkNotNull((Object)strength);
        Preconditions.checkArgument((this.keyStrength != MapMakerInternalMap.Strength.SOFT ? 1 : 0) != 0, (Object)"Soft keys are not supported");
        if (strength != MapMakerInternalMap.Strength.STRONG) {
            this.useCustomMap = true;
        }
        return this;
    }

    MapMakerInternalMap.Strength getKeyStrength() {
        return (MapMakerInternalMap.Strength)Objects.firstNonNull((Object)this.keyStrength, (Object)MapMakerInternalMap.Strength.STRONG);
    }

    @GwtIncompatible(value="java.lang.ref.WeakReference")
    public MapMaker weakValues() {
        return this.setValueStrength(MapMakerInternalMap.Strength.WEAK);
    }

    @Deprecated
    @GwtIncompatible(value="java.lang.ref.SoftReference")
    public MapMaker softValues() {
        return this.setValueStrength(MapMakerInternalMap.Strength.SOFT);
    }

    MapMaker setValueStrength(MapMakerInternalMap.Strength strength) {
        Preconditions.checkState((this.valueStrength == null ? 1 : 0) != 0, (String)"Value strength was already set to %s", (Object[])new Object[]{this.valueStrength});
        this.valueStrength = (MapMakerInternalMap.Strength)Preconditions.checkNotNull((Object)strength);
        if (strength != MapMakerInternalMap.Strength.STRONG) {
            this.useCustomMap = true;
        }
        return this;
    }

    MapMakerInternalMap.Strength getValueStrength() {
        return (MapMakerInternalMap.Strength)Objects.firstNonNull((Object)this.valueStrength, (Object)MapMakerInternalMap.Strength.STRONG);
    }

    @Deprecated
    MapMaker expireAfterWrite(long duration, TimeUnit unit) {
        this.checkExpiration(duration, unit);
        this.expireAfterWriteNanos = unit.toNanos(duration);
        if (duration == 0L && this.nullRemovalCause == null) {
            this.nullRemovalCause = RemovalCause.EXPIRED;
        }
        this.useCustomMap = true;
        return this;
    }

    private void checkExpiration(long duration, TimeUnit unit) {
        Preconditions.checkState((this.expireAfterWriteNanos == -1L ? 1 : 0) != 0, (String)"expireAfterWrite was already set to %s ns", (Object[])new Object[]{this.expireAfterWriteNanos});
        Preconditions.checkState((this.expireAfterAccessNanos == -1L ? 1 : 0) != 0, (String)"expireAfterAccess was already set to %s ns", (Object[])new Object[]{this.expireAfterAccessNanos});
        Preconditions.checkArgument((duration >= 0L ? 1 : 0) != 0, (String)"duration cannot be negative: %s %s", (Object[])new Object[]{duration, unit});
    }

    long getExpireAfterWriteNanos() {
        return this.expireAfterWriteNanos == -1L ? 0L : this.expireAfterWriteNanos;
    }

    @Deprecated
    @GwtIncompatible(value="To be supported")
    MapMaker expireAfterAccess(long duration, TimeUnit unit) {
        this.checkExpiration(duration, unit);
        this.expireAfterAccessNanos = unit.toNanos(duration);
        if (duration == 0L && this.nullRemovalCause == null) {
            this.nullRemovalCause = RemovalCause.EXPIRED;
        }
        this.useCustomMap = true;
        return this;
    }

    long getExpireAfterAccessNanos() {
        return this.expireAfterAccessNanos == -1L ? 0L : this.expireAfterAccessNanos;
    }

    Ticker getTicker() {
        return (Ticker)Objects.firstNonNull((Object)this.ticker, (Object)Ticker.systemTicker());
    }

    @Deprecated
    @GwtIncompatible(value="To be supported")
    <K, V> GenericMapMaker<K, V> removalListener(RemovalListener<K, V> listener) {
        Preconditions.checkState((this.removalListener == null ? 1 : 0) != 0);
        MapMaker me = this;
        me.removalListener = (RemovalListener)Preconditions.checkNotNull(listener);
        this.useCustomMap = true;
        return me;
    }

    public <K, V> ConcurrentMap<K, V> makeMap() {
        if (!this.useCustomMap) {
            return new ConcurrentHashMap(this.getInitialCapacity(), 0.75f, this.getConcurrencyLevel());
        }
        return (ConcurrentMap)(this.nullRemovalCause == null ? new MapMakerInternalMap(this) : new NullConcurrentMap(this));
    }

    @GwtIncompatible(value="MapMakerInternalMap")
    <K, V> MapMakerInternalMap<K, V> makeCustomMap() {
        return new MapMakerInternalMap(this);
    }

    @Deprecated
    <K, V> ConcurrentMap<K, V> makeComputingMap(Function<? super K, ? extends V> computingFunction) {
        return (ConcurrentMap)(this.nullRemovalCause == null ? new ComputingMapAdapter(this, computingFunction) : new NullComputingConcurrentMap(this, computingFunction));
    }

    public String toString() {
        Objects.ToStringHelper s = Objects.toStringHelper((Object)this);
        if (this.initialCapacity != -1) {
            s.add("initialCapacity", this.initialCapacity);
        }
        if (this.concurrencyLevel != -1) {
            s.add("concurrencyLevel", this.concurrencyLevel);
        }
        if (this.maximumSize != -1) {
            s.add("maximumSize", this.maximumSize);
        }
        if (this.expireAfterWriteNanos != -1L) {
            s.add("expireAfterWrite", (Object)(this.expireAfterWriteNanos + "ns"));
        }
        if (this.expireAfterAccessNanos != -1L) {
            s.add("expireAfterAccess", (Object)(this.expireAfterAccessNanos + "ns"));
        }
        if (this.keyStrength != null) {
            s.add("keyStrength", (Object)Ascii.toLowerCase((String)this.keyStrength.toString()));
        }
        if (this.valueStrength != null) {
            s.add("valueStrength", (Object)Ascii.toLowerCase((String)this.valueStrength.toString()));
        }
        if (this.keyEquivalence != null) {
            s.addValue((Object)"keyEquivalence");
        }
        if (this.removalListener != null) {
            s.addValue((Object)"removalListener");
        }
        return s.toString();
    }
}

