/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.MinMaxPriorityQueue;
import com.google.common.collect.Ordering;
import com.google.common.math.IntMath;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * Exception performing whole class analysis ignored.
 */
@Beta
public final class MinMaxPriorityQueue<E>
extends AbstractQueue<E> {
    private final Heap minHeap;
    private final Heap maxHeap;
    @VisibleForTesting
    final int maximumSize;
    private Object[] queue;
    private int size;
    private int modCount;
    private static final int EVEN_POWERS_OF_TWO = 0x55555555;
    private static final int ODD_POWERS_OF_TWO = -1431655766;
    private static final int DEFAULT_CAPACITY = 11;

    public static <E extends Comparable<E>> MinMaxPriorityQueue<E> create() {
        return new Builder((Comparator)Ordering.natural(), null).create();
    }

    public static <E extends Comparable<E>> MinMaxPriorityQueue<E> create(Iterable<? extends E> initialContents) {
        return new Builder((Comparator)Ordering.natural(), null).create(initialContents);
    }

    public static <B> Builder<B> orderedBy(Comparator<B> comparator) {
        return new Builder(comparator, null);
    }

    public static Builder<Comparable> expectedSize(int expectedSize) {
        return new Builder((Comparator)Ordering.natural(), null).expectedSize(expectedSize);
    }

    public static Builder<Comparable> maximumSize(int maximumSize) {
        return new Builder((Comparator)Ordering.natural(), null).maximumSize(maximumSize);
    }

    private MinMaxPriorityQueue(Builder<? super E> builder, int queueSize) {
        Ordering ordering = Builder.access$200(builder);
        this.minHeap = new Heap(this, ordering);
        this.minHeap.otherHeap = this.maxHeap = new Heap(this, ordering.reverse());
        this.maxHeap.otherHeap = this.minHeap;
        this.maximumSize = Builder.access$300(builder);
        this.queue = new Object[queueSize];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean add(E element) {
        this.offer(element);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> newElements) {
        boolean modified = false;
        for (E element : newElements) {
            this.offer(element);
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean offer(E element) {
        Preconditions.checkNotNull(element);
        ++this.modCount;
        int insertIndex = this.size++;
        this.growIfNeeded();
        this.heapForIndex(insertIndex).bubbleUp(insertIndex, element);
        return this.size <= this.maximumSize || this.pollLast() != element;
    }

    @Override
    public E poll() {
        return (E)(this.isEmpty() ? null : this.removeAndGet(0));
    }

    E elementData(int index) {
        return (E)this.queue[index];
    }

    @Override
    public E peek() {
        return (E)(this.isEmpty() ? null : this.elementData(0));
    }

    private int getMaxElementIndex() {
        switch (this.size) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
        }
        return this.maxHeap.compareElements(1, 2) <= 0 ? 1 : 2;
    }

    public E pollFirst() {
        return (E)this.poll();
    }

    public E removeFirst() {
        return (E)this.remove();
    }

    public E peekFirst() {
        return (E)this.peek();
    }

    public E pollLast() {
        return (E)(this.isEmpty() ? null : this.removeAndGet(this.getMaxElementIndex()));
    }

    public E removeLast() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return (E)this.removeAndGet(this.getMaxElementIndex());
    }

    public E peekLast() {
        return (E)(this.isEmpty() ? null : this.elementData(this.getMaxElementIndex()));
    }

    @VisibleForTesting
    MoveDesc<E> removeAt(int index) {
        Preconditions.checkPositionIndex((int)index, (int)this.size);
        ++this.modCount;
        --this.size;
        if (this.size == index) {
            this.queue[this.size] = null;
            return null;
        }
        Object actualLastElement = this.elementData(this.size);
        int lastElementAt = this.heapForIndex(this.size).getCorrectLastElement(actualLastElement);
        Object toTrickle = this.elementData(this.size);
        this.queue[this.size] = null;
        MoveDesc changes = this.fillHole(index, toTrickle);
        if (lastElementAt < index) {
            if (changes == null) {
                return new MoveDesc(actualLastElement, toTrickle);
            }
            return new MoveDesc(actualLastElement, changes.replaced);
        }
        return changes;
    }

    private MoveDesc<E> fillHole(int index, E toTrickle) {
        int vacated;
        Heap heap = this.heapForIndex(index);
        int bubbledTo = heap.bubbleUpAlternatingLevels(vacated = heap.fillHoleAt(index), toTrickle);
        if (bubbledTo == vacated) {
            return heap.tryCrossOverAndBubbleUp(index, vacated, toTrickle);
        }
        return bubbledTo < index ? new MoveDesc(toTrickle, this.elementData(index)) : null;
    }

    private E removeAndGet(int index) {
        Object value = this.elementData(index);
        this.removeAt(index);
        return (E)value;
    }

    private Heap heapForIndex(int i) {
        return MinMaxPriorityQueue.isEvenLevel((int)i) ? this.minHeap : this.maxHeap;
    }

    @VisibleForTesting
    static boolean isEvenLevel(int index) {
        int oneBased = index + 1;
        Preconditions.checkState((oneBased > 0 ? 1 : 0) != 0, (Object)"negative index");
        return (oneBased & 0x55555555) > (oneBased & 0xAAAAAAAA);
    }

    @VisibleForTesting
    boolean isIntact() {
        for (int i = 1; i < this.size; ++i) {
            if (Heap.access$400((Heap)this.heapForIndex(i), (int)i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<E> iterator() {
        return new QueueIterator(this, null);
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.queue[i] = null;
        }
        this.size = 0;
    }

    @Override
    public Object[] toArray() {
        Object[] copyTo = new Object[this.size];
        System.arraycopy(this.queue, 0, copyTo, 0, this.size);
        return copyTo;
    }

    public Comparator<? super E> comparator() {
        return this.minHeap.ordering;
    }

    @VisibleForTesting
    int capacity() {
        return this.queue.length;
    }

    @VisibleForTesting
    static int initialQueueSize(int configuredExpectedSize, int maximumSize, Iterable<?> initialContents) {
        int result;
        int n = result = configuredExpectedSize == -1 ? 11 : configuredExpectedSize;
        if (initialContents instanceof Collection) {
            int initialSize = ((Collection)initialContents).size();
            result = Math.max(result, initialSize);
        }
        return MinMaxPriorityQueue.capAtMaximumSize((int)result, (int)maximumSize);
    }

    private void growIfNeeded() {
        if (this.size > this.queue.length) {
            int newCapacity = this.calculateNewCapacity();
            Object[] newQueue = new Object[newCapacity];
            System.arraycopy(this.queue, 0, newQueue, 0, this.queue.length);
            this.queue = newQueue;
        }
    }

    private int calculateNewCapacity() {
        int oldCapacity = this.queue.length;
        int newCapacity = oldCapacity < 64 ? (oldCapacity + 1) * 2 : IntMath.checkedMultiply((int)(oldCapacity / 2), (int)3);
        return MinMaxPriorityQueue.capAtMaximumSize((int)newCapacity, (int)this.maximumSize);
    }

    private static int capAtMaximumSize(int queueSize, int maximumSize) {
        return Math.min(queueSize - 1, maximumSize) + 1;
    }

    static /* synthetic */ Object[] access$500(MinMaxPriorityQueue x0) {
        return x0.queue;
    }

    static /* synthetic */ int access$600(MinMaxPriorityQueue x0) {
        return x0.size;
    }

    static /* synthetic */ int access$700(MinMaxPriorityQueue x0) {
        return x0.modCount;
    }
}

