/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.eventbus;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.EventSubscriber;
import com.google.common.eventbus.SubscriberExceptionHandler;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;

@Beta
public class AsyncEventBus
extends EventBus {
    private final Executor executor;
    private final ConcurrentLinkedQueue<EventBus.EventWithSubscriber> eventsToDispatch = new ConcurrentLinkedQueue();

    public AsyncEventBus(String identifier, Executor executor) {
        super(identifier);
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
    }

    public AsyncEventBus(Executor executor, SubscriberExceptionHandler subscriberExceptionHandler) {
        super(subscriberExceptionHandler);
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
    }

    public AsyncEventBus(Executor executor) {
        super("default");
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
    }

    void enqueueEvent(Object event, EventSubscriber subscriber) {
        this.eventsToDispatch.offer(new EventBus.EventWithSubscriber(event, subscriber));
    }

    protected void dispatchQueuedEvents() {
        EventBus.EventWithSubscriber eventWithSubscriber;
        while ((eventWithSubscriber = (EventBus.EventWithSubscriber)this.eventsToDispatch.poll()) != null) {
            this.dispatch(eventWithSubscriber.event, eventWithSubscriber.subscriber);
        }
    }

    void dispatch(Object event, EventSubscriber subscriber) {
        Preconditions.checkNotNull((Object)event);
        Preconditions.checkNotNull((Object)subscriber);
        this.executor.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ void access$001(AsyncEventBus x0, Object x1, EventSubscriber x2) {
        super.dispatch(x1, x2);
    }
}

