/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractNonStreamingHashFunction;
import com.google.common.hash.Funnel;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import java.nio.charset.Charset;

abstract class AbstractNonStreamingHashFunction
implements HashFunction {
    AbstractNonStreamingHashFunction() {
    }

    public Hasher newHasher() {
        return new BufferingHasher(this, 32);
    }

    public Hasher newHasher(int expectedInputSize) {
        Preconditions.checkArgument((expectedInputSize >= 0 ? 1 : 0) != 0);
        return new BufferingHasher(this, expectedInputSize);
    }

    public <T> HashCode hashObject(T instance, Funnel<? super T> funnel) {
        return this.newHasher().putObject(instance, funnel).hash();
    }

    public HashCode hashUnencodedChars(CharSequence input) {
        int len = input.length();
        Hasher hasher = this.newHasher(len * 2);
        for (int i = 0; i < len; ++i) {
            hasher.putChar(input.charAt(i));
        }
        return hasher.hash();
    }

    public HashCode hashString(CharSequence input, Charset charset) {
        return this.hashBytes(input.toString().getBytes(charset));
    }

    public HashCode hashInt(int input) {
        return this.newHasher(4).putInt(input).hash();
    }

    public HashCode hashLong(long input) {
        return this.newHasher(8).putLong(input).hash();
    }

    public HashCode hashBytes(byte[] input) {
        return this.hashBytes(input, 0, input.length);
    }
}

