/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.BloomFilterStrategies;
import com.google.common.hash.Funnel;
import java.io.Serializable;
import javax.annotation.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
@Beta
public final class BloomFilter<T>
implements Predicate<T>,
Serializable {
    private final BloomFilterStrategies.BitArray bits;
    private final int numHashFunctions;
    private final Funnel<T> funnel;
    private final Strategy strategy;
    private static final Strategy DEFAULT_STRATEGY = BloomFilter.getDefaultStrategyFromSystemProperty();
    @VisibleForTesting
    static final String USE_MITZ32_PROPERTY = "com.google.common.hash.BloomFilter.useMitz32";

    private BloomFilter(BloomFilterStrategies.BitArray bits, int numHashFunctions, Funnel<T> funnel, Strategy strategy) {
        Preconditions.checkArgument((numHashFunctions > 0 ? 1 : 0) != 0, (String)"numHashFunctions (%s) must be > 0", (Object[])new Object[]{numHashFunctions});
        Preconditions.checkArgument((numHashFunctions <= 255 ? 1 : 0) != 0, (String)"numHashFunctions (%s) must be <= 255", (Object[])new Object[]{numHashFunctions});
        this.bits = (BloomFilterStrategies.BitArray)Preconditions.checkNotNull((Object)bits);
        this.numHashFunctions = numHashFunctions;
        this.funnel = (Funnel)Preconditions.checkNotNull(funnel);
        this.strategy = (Strategy)Preconditions.checkNotNull((Object)strategy);
    }

    public BloomFilter<T> copy() {
        return new BloomFilter(this.bits.copy(), this.numHashFunctions, this.funnel, this.strategy);
    }

    public boolean mightContain(T object) {
        return this.strategy.mightContain(object, this.funnel, this.numHashFunctions, this.bits);
    }

    @Deprecated
    public boolean apply(T input) {
        return this.mightContain(input);
    }

    public boolean put(T object) {
        return this.strategy.put(object, this.funnel, this.numHashFunctions, this.bits);
    }

    public double expectedFpp() {
        return Math.pow((double)this.bits.bitCount() / (double)this.bitSize(), this.numHashFunctions);
    }

    @VisibleForTesting
    long bitSize() {
        return this.bits.bitSize();
    }

    public boolean isCompatible(BloomFilter<T> that) {
        Preconditions.checkNotNull(that);
        return this != that && this.numHashFunctions == that.numHashFunctions && this.bitSize() == that.bitSize() && this.strategy.equals(that.strategy) && this.funnel.equals(that.funnel);
    }

    public void putAll(BloomFilter<T> that) {
        Preconditions.checkNotNull(that);
        Preconditions.checkArgument((this != that ? 1 : 0) != 0, (Object)"Cannot combine a BloomFilter with itself.");
        Preconditions.checkArgument((this.numHashFunctions == that.numHashFunctions ? 1 : 0) != 0, (String)"BloomFilters must have the same number of hash functions (%s != %s)", (Object[])new Object[]{this.numHashFunctions, that.numHashFunctions});
        Preconditions.checkArgument((this.bitSize() == that.bitSize() ? 1 : 0) != 0, (String)"BloomFilters must have the same size underlying bit arrays (%s != %s)", (Object[])new Object[]{this.bitSize(), that.bitSize()});
        Preconditions.checkArgument((boolean)this.strategy.equals(that.strategy), (String)"BloomFilters must have equal strategies (%s != %s)", (Object[])new Object[]{this.strategy, that.strategy});
        Preconditions.checkArgument((boolean)this.funnel.equals(that.funnel), (String)"BloomFilters must have equal funnels (%s != %s)", (Object[])new Object[]{this.funnel, that.funnel});
        this.bits.putAll(that.bits);
    }

    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BloomFilter) {
            BloomFilter that = (BloomFilter)object;
            return this.numHashFunctions == that.numHashFunctions && this.funnel.equals(that.funnel) && this.bits.equals((Object)that.bits) && this.strategy.equals(that.strategy);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.numHashFunctions, this.funnel, this.strategy, this.bits});
    }

    @VisibleForTesting
    static Strategy getDefaultStrategyFromSystemProperty() {
        return Boolean.parseBoolean(System.getProperty("com.google.common.hash.BloomFilter.useMitz32")) ? BloomFilterStrategies.MURMUR128_MITZ_32 : BloomFilterStrategies.MURMUR128_MITZ_64;
    }

    public static <T> BloomFilter<T> create(Funnel<T> funnel, int expectedInsertions, double fpp) {
        return BloomFilter.create(funnel, (int)expectedInsertions, (double)fpp, (Strategy)DEFAULT_STRATEGY);
    }

    @VisibleForTesting
    static <T> BloomFilter<T> create(Funnel<T> funnel, int expectedInsertions, double fpp, Strategy strategy) {
        Preconditions.checkNotNull(funnel);
        Preconditions.checkArgument((expectedInsertions >= 0 ? 1 : 0) != 0, (String)"Expected insertions (%s) must be >= 0", (Object[])new Object[]{expectedInsertions});
        Preconditions.checkArgument((fpp > 0.0 ? 1 : 0) != 0, (String)"False positive probability (%s) must be > 0.0", (Object[])new Object[]{fpp});
        Preconditions.checkArgument((fpp < 1.0 ? 1 : 0) != 0, (String)"False positive probability (%s) must be < 1.0", (Object[])new Object[]{fpp});
        Preconditions.checkNotNull((Object)strategy);
        if (expectedInsertions == 0) {
            expectedInsertions = 1;
        }
        long numBits = BloomFilter.optimalNumOfBits((long)expectedInsertions, (double)fpp);
        int numHashFunctions = BloomFilter.optimalNumOfHashFunctions((long)expectedInsertions, (long)numBits);
        try {
            return new BloomFilter(new BloomFilterStrategies.BitArray(numBits), numHashFunctions, funnel, strategy);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Could not create BloomFilter of " + numBits + " bits", e);
        }
    }

    public static <T> BloomFilter<T> create(Funnel<T> funnel, int expectedInsertions) {
        return BloomFilter.create(funnel, (int)expectedInsertions, (double)0.03);
    }

    @VisibleForTesting
    static int optimalNumOfHashFunctions(long n, long m) {
        return Math.max(1, (int)Math.round((double)(m / n) * Math.log(2.0)));
    }

    @VisibleForTesting
    static long optimalNumOfBits(long n, double p) {
        if (p == 0.0) {
            p = Double.MIN_VALUE;
        }
        return (long)((double)(-n) * Math.log(p) / (Math.log(2.0) * Math.log(2.0)));
    }

    private Object writeReplace() {
        return new SerialForm(this);
    }

    static /* synthetic */ BloomFilterStrategies.BitArray access$000(BloomFilter x0) {
        return x0.bits;
    }

    static /* synthetic */ int access$100(BloomFilter x0) {
        return x0.numHashFunctions;
    }

    static /* synthetic */ Funnel access$200(BloomFilter x0) {
        return x0.funnel;
    }

    static /* synthetic */ Strategy access$300(BloomFilter x0) {
        return x0.strategy;
    }
}

