/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.net;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Ascii;
import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.net.MediaType;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

/*
 * Exception performing whole class analysis ignored.
 */
@Beta
@GwtCompatible
@Immutable
public final class MediaType {
    private static final String CHARSET_ATTRIBUTE = "charset";
    private static final ImmutableListMultimap<String, String> UTF_8_CONSTANT_PARAMETERS = ImmutableListMultimap.of((Object)"charset", (Object)Ascii.toLowerCase((String)Charsets.UTF_8.name()));
    private static final CharMatcher TOKEN_MATCHER = CharMatcher.ASCII.and(CharMatcher.JAVA_ISO_CONTROL.negate()).and(CharMatcher.isNot((char)' ')).and(CharMatcher.noneOf((CharSequence)"()<>@,;:\\\"/[]?="));
    private static final CharMatcher QUOTED_TEXT_MATCHER = CharMatcher.ASCII.and(CharMatcher.noneOf((CharSequence)"\"\\\r"));
    private static final CharMatcher LINEAR_WHITE_SPACE = CharMatcher.anyOf((CharSequence)" \t\r\n");
    private static final String APPLICATION_TYPE = "application";
    private static final String AUDIO_TYPE = "audio";
    private static final String IMAGE_TYPE = "image";
    private static final String TEXT_TYPE = "text";
    private static final String VIDEO_TYPE = "video";
    private static final String WILDCARD = "*";
    private static final Map<MediaType, MediaType> KNOWN_TYPES = Maps.newHashMap();
    public static final MediaType ANY_TYPE = MediaType.createConstant((String)"*", (String)"*");
    public static final MediaType ANY_TEXT_TYPE = MediaType.createConstant((String)"text", (String)"*");
    public static final MediaType ANY_IMAGE_TYPE = MediaType.createConstant((String)"image", (String)"*");
    public static final MediaType ANY_AUDIO_TYPE = MediaType.createConstant((String)"audio", (String)"*");
    public static final MediaType ANY_VIDEO_TYPE = MediaType.createConstant((String)"video", (String)"*");
    public static final MediaType ANY_APPLICATION_TYPE = MediaType.createConstant((String)"application", (String)"*");
    public static final MediaType CACHE_MANIFEST_UTF_8 = MediaType.createConstantUtf8((String)"text", (String)"cache-manifest");
    public static final MediaType CSS_UTF_8 = MediaType.createConstantUtf8((String)"text", (String)"css");
    public static final MediaType CSV_UTF_8 = MediaType.createConstantUtf8((String)"text", (String)"csv");
    public static final MediaType HTML_UTF_8 = MediaType.createConstantUtf8((String)"text", (String)"html");
    public static final MediaType I_CALENDAR_UTF_8 = MediaType.createConstantUtf8((String)"text", (String)"calendar");
    public static final MediaType PLAIN_TEXT_UTF_8 = MediaType.createConstantUtf8((String)"text", (String)"plain");
    public static final MediaType TEXT_JAVASCRIPT_UTF_8 = MediaType.createConstantUtf8((String)"text", (String)"javascript");
    public static final MediaType TSV_UTF_8 = MediaType.createConstantUtf8((String)"text", (String)"tab-separated-values");
    public static final MediaType VCARD_UTF_8 = MediaType.createConstantUtf8((String)"text", (String)"vcard");
    public static final MediaType WML_UTF_8 = MediaType.createConstantUtf8((String)"text", (String)"vnd.wap.wml");
    public static final MediaType XML_UTF_8 = MediaType.createConstantUtf8((String)"text", (String)"xml");
    public static final MediaType BMP = MediaType.createConstant((String)"image", (String)"bmp");
    public static final MediaType CRW = MediaType.createConstant((String)"image", (String)"x-canon-crw");
    public static final MediaType GIF = MediaType.createConstant((String)"image", (String)"gif");
    public static final MediaType ICO = MediaType.createConstant((String)"image", (String)"vnd.microsoft.icon");
    public static final MediaType JPEG = MediaType.createConstant((String)"image", (String)"jpeg");
    public static final MediaType PNG = MediaType.createConstant((String)"image", (String)"png");
    public static final MediaType PSD = MediaType.createConstant((String)"image", (String)"vnd.adobe.photoshop");
    public static final MediaType SVG_UTF_8 = MediaType.createConstantUtf8((String)"image", (String)"svg+xml");
    public static final MediaType TIFF = MediaType.createConstant((String)"image", (String)"tiff");
    public static final MediaType WEBP = MediaType.createConstant((String)"image", (String)"webp");
    public static final MediaType MP4_AUDIO = MediaType.createConstant((String)"audio", (String)"mp4");
    public static final MediaType MPEG_AUDIO = MediaType.createConstant((String)"audio", (String)"mpeg");
    public static final MediaType OGG_AUDIO = MediaType.createConstant((String)"audio", (String)"ogg");
    public static final MediaType WEBM_AUDIO = MediaType.createConstant((String)"audio", (String)"webm");
    public static final MediaType MP4_VIDEO = MediaType.createConstant((String)"video", (String)"mp4");
    public static final MediaType MPEG_VIDEO = MediaType.createConstant((String)"video", (String)"mpeg");
    public static final MediaType OGG_VIDEO = MediaType.createConstant((String)"video", (String)"ogg");
    public static final MediaType QUICKTIME = MediaType.createConstant((String)"video", (String)"quicktime");
    public static final MediaType WEBM_VIDEO = MediaType.createConstant((String)"video", (String)"webm");
    public static final MediaType WMV = MediaType.createConstant((String)"video", (String)"x-ms-wmv");
    public static final MediaType APPLICATION_XML_UTF_8 = MediaType.createConstantUtf8((String)"application", (String)"xml");
    public static final MediaType ATOM_UTF_8 = MediaType.createConstantUtf8((String)"application", (String)"atom+xml");
    public static final MediaType BZIP2 = MediaType.createConstant((String)"application", (String)"x-bzip2");
    public static final MediaType EOT = MediaType.createConstant((String)"application", (String)"vnd.ms-fontobject");
    public static final MediaType EPUB = MediaType.createConstant((String)"application", (String)"epub+zip");
    public static final MediaType FORM_DATA = MediaType.createConstant((String)"application", (String)"x-www-form-urlencoded");
    public static final MediaType KEY_ARCHIVE = MediaType.createConstant((String)"application", (String)"pkcs12");
    public static final MediaType APPLICATION_BINARY = MediaType.createConstant((String)"application", (String)"binary");
    public static final MediaType GZIP = MediaType.createConstant((String)"application", (String)"x-gzip");
    public static final MediaType JAVASCRIPT_UTF_8 = MediaType.createConstantUtf8((String)"application", (String)"javascript");
    public static final MediaType JSON_UTF_8 = MediaType.createConstantUtf8((String)"application", (String)"json");
    public static final MediaType KML = MediaType.createConstant((String)"application", (String)"vnd.google-earth.kml+xml");
    public static final MediaType KMZ = MediaType.createConstant((String)"application", (String)"vnd.google-earth.kmz");
    public static final MediaType MBOX = MediaType.createConstant((String)"application", (String)"mbox");
    public static final MediaType MICROSOFT_EXCEL = MediaType.createConstant((String)"application", (String)"vnd.ms-excel");
    public static final MediaType MICROSOFT_POWERPOINT = MediaType.createConstant((String)"application", (String)"vnd.ms-powerpoint");
    public static final MediaType MICROSOFT_WORD = MediaType.createConstant((String)"application", (String)"msword");
    public static final MediaType OCTET_STREAM = MediaType.createConstant((String)"application", (String)"octet-stream");
    public static final MediaType OGG_CONTAINER = MediaType.createConstant((String)"application", (String)"ogg");
    public static final MediaType OOXML_DOCUMENT = MediaType.createConstant((String)"application", (String)"vnd.openxmlformats-officedocument.wordprocessingml.document");
    public static final MediaType OOXML_PRESENTATION = MediaType.createConstant((String)"application", (String)"vnd.openxmlformats-officedocument.presentationml.presentation");
    public static final MediaType OOXML_SHEET = MediaType.createConstant((String)"application", (String)"vnd.openxmlformats-officedocument.spreadsheetml.sheet");
    public static final MediaType OPENDOCUMENT_GRAPHICS = MediaType.createConstant((String)"application", (String)"vnd.oasis.opendocument.graphics");
    public static final MediaType OPENDOCUMENT_PRESENTATION = MediaType.createConstant((String)"application", (String)"vnd.oasis.opendocument.presentation");
    public static final MediaType OPENDOCUMENT_SPREADSHEET = MediaType.createConstant((String)"application", (String)"vnd.oasis.opendocument.spreadsheet");
    public static final MediaType OPENDOCUMENT_TEXT = MediaType.createConstant((String)"application", (String)"vnd.oasis.opendocument.text");
    public static final MediaType PDF = MediaType.createConstant((String)"application", (String)"pdf");
    public static final MediaType POSTSCRIPT = MediaType.createConstant((String)"application", (String)"postscript");
    public static final MediaType PROTOBUF = MediaType.createConstant((String)"application", (String)"protobuf");
    public static final MediaType RDF_XML_UTF_8 = MediaType.createConstantUtf8((String)"application", (String)"rdf+xml");
    public static final MediaType RTF_UTF_8 = MediaType.createConstantUtf8((String)"application", (String)"rtf");
    public static final MediaType SFNT = MediaType.createConstant((String)"application", (String)"font-sfnt");
    public static final MediaType SHOCKWAVE_FLASH = MediaType.createConstant((String)"application", (String)"x-shockwave-flash");
    public static final MediaType SKETCHUP = MediaType.createConstant((String)"application", (String)"vnd.sketchup.skp");
    public static final MediaType TAR = MediaType.createConstant((String)"application", (String)"x-tar");
    public static final MediaType WOFF = MediaType.createConstant((String)"application", (String)"font-woff");
    public static final MediaType XHTML_UTF_8 = MediaType.createConstantUtf8((String)"application", (String)"xhtml+xml");
    public static final MediaType XRD_UTF_8 = MediaType.createConstantUtf8((String)"application", (String)"xrd+xml");
    public static final MediaType ZIP = MediaType.createConstant((String)"application", (String)"zip");
    private final String type;
    private final String subtype;
    private final ImmutableListMultimap<String, String> parameters;
    private static final Joiner.MapJoiner PARAMETER_JOINER = Joiner.on((String)"; ").withKeyValueSeparator("=");

    private static MediaType createConstant(String type, String subtype) {
        return MediaType.addKnownType((MediaType)new MediaType(type, subtype, ImmutableListMultimap.of()));
    }

    private static MediaType createConstantUtf8(String type, String subtype) {
        return MediaType.addKnownType((MediaType)new MediaType(type, subtype, UTF_8_CONSTANT_PARAMETERS));
    }

    private static MediaType addKnownType(MediaType mediaType) {
        KNOWN_TYPES.put(mediaType, mediaType);
        return mediaType;
    }

    private MediaType(String type, String subtype, ImmutableListMultimap<String, String> parameters) {
        this.type = type;
        this.subtype = subtype;
        this.parameters = parameters;
    }

    public String type() {
        return this.type;
    }

    public String subtype() {
        return this.subtype;
    }

    public ImmutableListMultimap<String, String> parameters() {
        return this.parameters;
    }

    private Map<String, ImmutableMultiset<String>> parametersAsMap() {
        return Maps.transformValues((Map)this.parameters.asMap(), (Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Optional<Charset> charset() {
        ImmutableSet charsetValues = ImmutableSet.copyOf((Collection)this.parameters.get((Object)"charset"));
        switch (charsetValues.size()) {
            case 0: {
                return Optional.absent();
            }
            case 1: {
                return Optional.of((Object)Charset.forName((String)Iterables.getOnlyElement((Iterable)charsetValues)));
            }
        }
        throw new IllegalStateException("Multiple charset values defined: " + charsetValues);
    }

    public MediaType withoutParameters() {
        return this.parameters.isEmpty() ? this : MediaType.create((String)this.type, (String)this.subtype);
    }

    public MediaType withParameters(Multimap<String, String> parameters) {
        return MediaType.create((String)this.type, (String)this.subtype, parameters);
    }

    public MediaType withParameter(String attribute, String value) {
        Preconditions.checkNotNull((Object)attribute);
        Preconditions.checkNotNull((Object)value);
        String normalizedAttribute = MediaType.normalizeToken((String)attribute);
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (Map.Entry entry : this.parameters.entries()) {
            String key = (String)entry.getKey();
            if (normalizedAttribute.equals(key)) continue;
            builder.put((Object)key, entry.getValue());
        }
        builder.put((Object)normalizedAttribute, (Object)MediaType.normalizeParameterValue((String)normalizedAttribute, (String)value));
        MediaType mediaType = new MediaType(this.type, this.subtype, builder.build());
        return (MediaType)Objects.firstNonNull(KNOWN_TYPES.get(mediaType), (Object)mediaType);
    }

    public MediaType withCharset(Charset charset) {
        Preconditions.checkNotNull((Object)charset);
        return this.withParameter("charset", charset.name());
    }

    public boolean hasWildcard() {
        return "*".equals(this.type) || "*".equals(this.subtype);
    }

    public boolean is(MediaType mediaTypeRange) {
        return !(!mediaTypeRange.type.equals("*") && !mediaTypeRange.type.equals(this.type) || !mediaTypeRange.subtype.equals("*") && !mediaTypeRange.subtype.equals(this.subtype) || !this.parameters.entries().containsAll((Collection)mediaTypeRange.parameters.entries()));
    }

    public static MediaType create(String type, String subtype) {
        return MediaType.create((String)type, (String)subtype, (Multimap)ImmutableListMultimap.of());
    }

    static MediaType createApplicationType(String subtype) {
        return MediaType.create((String)"application", (String)subtype);
    }

    static MediaType createAudioType(String subtype) {
        return MediaType.create((String)"audio", (String)subtype);
    }

    static MediaType createImageType(String subtype) {
        return MediaType.create((String)"image", (String)subtype);
    }

    static MediaType createTextType(String subtype) {
        return MediaType.create((String)"text", (String)subtype);
    }

    static MediaType createVideoType(String subtype) {
        return MediaType.create((String)"video", (String)subtype);
    }

    private static MediaType create(String type, String subtype, Multimap<String, String> parameters) {
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkNotNull((Object)subtype);
        Preconditions.checkNotNull(parameters);
        String normalizedType = MediaType.normalizeToken((String)type);
        String normalizedSubtype = MediaType.normalizeToken((String)subtype);
        Preconditions.checkArgument((!"*".equals(normalizedType) || "*".equals(normalizedSubtype) ? 1 : 0) != 0, (Object)"A wildcard type cannot be used with a non-wildcard subtype");
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (Map.Entry entry : parameters.entries()) {
            String attribute = MediaType.normalizeToken((String)((String)entry.getKey()));
            builder.put((Object)attribute, (Object)MediaType.normalizeParameterValue((String)attribute, (String)((String)entry.getValue())));
        }
        MediaType mediaType = new MediaType(normalizedType, normalizedSubtype, builder.build());
        return (MediaType)Objects.firstNonNull(KNOWN_TYPES.get(mediaType), (Object)mediaType);
    }

    private static String normalizeToken(String token) {
        Preconditions.checkArgument((boolean)TOKEN_MATCHER.matchesAllOf((CharSequence)token));
        return Ascii.toLowerCase((String)token);
    }

    private static String normalizeParameterValue(String attribute, String value) {
        return "charset".equals(attribute) ? Ascii.toLowerCase((String)value) : value;
    }

    public static MediaType parse(String input) {
        Preconditions.checkNotNull((Object)input);
        Tokenizer tokenizer = new Tokenizer(input);
        try {
            String type = tokenizer.consumeToken(TOKEN_MATCHER);
            tokenizer.consumeCharacter('/');
            String subtype = tokenizer.consumeToken(TOKEN_MATCHER);
            ImmutableListMultimap.Builder parameters = ImmutableListMultimap.builder();
            while (tokenizer.hasMore()) {
                String value;
                tokenizer.consumeCharacter(';');
                tokenizer.consumeTokenIfPresent(LINEAR_WHITE_SPACE);
                String attribute = tokenizer.consumeToken(TOKEN_MATCHER);
                tokenizer.consumeCharacter('=');
                if ('\"' == tokenizer.previewChar()) {
                    tokenizer.consumeCharacter('\"');
                    StringBuilder valueBuilder = new StringBuilder();
                    while ('\"' != tokenizer.previewChar()) {
                        if ('\\' == tokenizer.previewChar()) {
                            tokenizer.consumeCharacter('\\');
                            valueBuilder.append(tokenizer.consumeCharacter(CharMatcher.ASCII));
                            continue;
                        }
                        valueBuilder.append(tokenizer.consumeToken(QUOTED_TEXT_MATCHER));
                    }
                    value = valueBuilder.toString();
                    tokenizer.consumeCharacter('\"');
                } else {
                    value = tokenizer.consumeToken(TOKEN_MATCHER);
                }
                parameters.put((Object)attribute, (Object)value);
            }
            return MediaType.create((String)type, (String)subtype, (Multimap)parameters.build());
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException("Could not parse '" + input + "'", e);
        }
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MediaType) {
            MediaType that = (MediaType)obj;
            return this.type.equals(that.type) && this.subtype.equals(that.subtype) && this.parametersAsMap().equals(that.parametersAsMap());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.subtype, this.parametersAsMap()});
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append(this.type).append('/').append(this.subtype);
        if (!this.parameters.isEmpty()) {
            builder.append("; ");
            ListMultimap quotedParameters = Multimaps.transformValues((ListMultimap)this.parameters, (Function)new /* Unavailable Anonymous Inner Class!! */);
            PARAMETER_JOINER.appendTo(builder, (Iterable)quotedParameters.entries());
        }
        return builder.toString();
    }

    private static String escapeAndQuote(String value) {
        StringBuilder escaped = new StringBuilder(value.length() + 16).append('\"');
        for (char ch : value.toCharArray()) {
            if (ch == '\r' || ch == '\\' || ch == '\"') {
                escaped.append('\\');
            }
            escaped.append(ch);
        }
        return escaped.append('\"').toString();
    }

    static /* synthetic */ CharMatcher access$000() {
        return TOKEN_MATCHER;
    }

    static /* synthetic */ String access$100(String x0) {
        return MediaType.escapeAndQuote((String)x0);
    }
}

