/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AsyncSettableFuture;
import com.google.common.util.concurrent.ForwardingListenableFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import javax.annotation.Nullable;

final class AsyncSettableFuture<V>
extends ForwardingListenableFuture<V> {
    private final NestedFuture<V> nested = new NestedFuture(null);
    private final ListenableFuture<V> dereferenced = Futures.dereference((ListenableFuture)this.nested);

    public static <V> AsyncSettableFuture<V> create() {
        return new AsyncSettableFuture();
    }

    private AsyncSettableFuture() {
    }

    protected ListenableFuture<V> delegate() {
        return this.dereferenced;
    }

    public boolean setFuture(ListenableFuture<? extends V> future) {
        return this.nested.setFuture((ListenableFuture)Preconditions.checkNotNull(future));
    }

    public boolean setValue(@Nullable V value) {
        return this.setFuture(Futures.immediateFuture(value));
    }

    public boolean setException(Throwable exception) {
        return this.setFuture(Futures.immediateFailedFuture((Throwable)exception));
    }

    public boolean isSet() {
        return this.nested.isDone();
    }
}

