/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.SerializingExecutor;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import javax.annotation.concurrent.GuardedBy;

final class SerializingExecutor
implements Executor {
    private static final Logger log = Logger.getLogger(SerializingExecutor.class.getName());
    private final Executor executor;
    @GuardedBy(value="internalLock")
    private final Queue<Runnable> waitQueue = new ArrayDeque();
    @GuardedBy(value="internalLock")
    private boolean isThreadScheduled = false;
    private final TaskRunner taskRunner = new TaskRunner(this, null);
    private final Object internalLock = new /* Unavailable Anonymous Inner Class!! */;

    public SerializingExecutor(Executor executor) {
        Preconditions.checkNotNull((Object)executor, (Object)"'executor' must not be null.");
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable r) {
        Preconditions.checkNotNull((Object)r, (Object)"'r' must not be null.");
        boolean scheduleTaskRunner = false;
        Object object = this.internalLock;
        synchronized (object) {
            this.waitQueue.add(r);
            if (!this.isThreadScheduled) {
                this.isThreadScheduled = true;
                scheduleTaskRunner = true;
            }
        }
        if (scheduleTaskRunner) {
            boolean threw = true;
            try {
                this.executor.execute((Runnable)this.taskRunner);
                threw = false;
            }
            finally {
                if (threw) {
                    Object object2 = this.internalLock;
                    synchronized (object2) {
                        this.isThreadScheduled = false;
                    }
                }
            }
        }
    }

    static /* synthetic */ boolean access$100(SerializingExecutor x0) {
        return x0.isThreadScheduled;
    }

    static /* synthetic */ Object access$200(SerializingExecutor x0) {
        return x0.internalLock;
    }

    static /* synthetic */ Queue access$300(SerializingExecutor x0) {
        return x0.waitQueue;
    }

    static /* synthetic */ boolean access$102(SerializingExecutor x0, boolean x1) {
        x0.isThreadScheduled = x1;
        return x0.isThreadScheduled;
    }

    static /* synthetic */ Logger access$400() {
        return log;
    }
}

