/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.asm;

import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.CertificateHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import cpw.mods.fml.common.patcher.ClassPatchManager;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import cpw.mods.fml.relauncher.IFMLCallHook;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.logging.log4j.Level;

public class FMLSanityChecker
implements IFMLCallHook {
    private static final String FMLFINGERPRINT = "51:0A:FB:4C:AF:A4:A0:F2:F5:CF:C5:0E:B4:CC:3C:30:24:4A:E3:8E".toLowerCase().replace(":", "");
    private static final String FORGEFINGERPRINT = "E3:C3:D5:0C:7C:98:6D:F7:4C:64:5C:0A:C5:46:39:74:1C:90:A5:57".toLowerCase().replace(":", "");
    private static final String MCFINGERPRINT = "CD:99:95:96:56:F7:53:DC:28:D8:63:B4:67:69:F7:F8:FB:AE:FC:FC".toLowerCase().replace(":", "");
    private LaunchClassLoader cl;
    private boolean liveEnv;
    public static File fmlLocation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Void call() throws Exception {
        CodeSource codeSource = this.getClass().getProtectionDomain().getCodeSource();
        boolean goodFML = false;
        boolean fmlIsJar = false;
        if (codeSource.getLocation().getProtocol().equals("jar")) {
            fmlIsJar = true;
            Certificate[] certificates = codeSource.getCertificates();
            if (certificates != null) {
                for (Certificate cert : certificates) {
                    String fingerprint = CertificateHelper.getFingerprint(cert);
                    if (fingerprint.equals(FMLFINGERPRINT)) {
                        FMLRelaunchLog.info("Found valid fingerprint for FML. Certificate fingerprint %s", fingerprint);
                        goodFML = true;
                        continue;
                    }
                    if (fingerprint.equals(FORGEFINGERPRINT)) {
                        FMLRelaunchLog.info("Found valid fingerprint for Minecraft Forge. Certificate fingerprint %s", fingerprint);
                        goodFML = true;
                        continue;
                    }
                    FMLRelaunchLog.severe("Found invalid fingerprint for FML: %s", fingerprint);
                }
            }
        } else {
            goodFML = true;
        }
        boolean goodMC = FMLLaunchHandler.side() == Side.SERVER || !this.liveEnv;
        int certCount = 0;
        try {
            Class<?> cbr = Class.forName("net.minecraft.client.ClientBrandRetriever", false, (ClassLoader)this.cl);
            codeSource = cbr.getProtectionDomain().getCodeSource();
        }
        catch (Exception e) {
            goodMC = true;
        }
        ZipFile mcJarFile = null;
        if (!fmlIsJar) return null;
        if (goodMC) return null;
        if (!codeSource.getLocation().getProtocol().equals("jar")) return null;
        try {
            String mcPath = codeSource.getLocation().getPath().substring(5);
            mcPath = mcPath.substring(0, mcPath.lastIndexOf(33));
            mcPath = URLDecoder.decode(mcPath, Charsets.UTF_8.name());
            mcJarFile = new JarFile(mcPath, true);
            ((JarFile)mcJarFile).getManifest();
            JarEntry cbrEntry = ((JarFile)mcJarFile).getJarEntry("net/minecraft/client/ClientBrandRetriever.class");
            ByteStreams.toByteArray((InputStream)((JarFile)mcJarFile).getInputStream(cbrEntry));
            Certificate[] certificates = cbrEntry.getCertificates();
            int n = certCount = certificates != null ? certificates.length : 0;
            if (certificates != null) {
                for (Certificate cert : certificates) {
                    String fingerprint = CertificateHelper.getFingerprint(cert);
                    if (!fingerprint.equals(MCFINGERPRINT)) continue;
                    FMLRelaunchLog.info("Found valid fingerprint for Minecraft. Certificate fingerprint %s", fingerprint);
                    goodMC = true;
                }
            }
        }
        catch (Throwable e) {
            FMLRelaunchLog.log(Level.ERROR, e, "A critical error occurred trying to read the minecraft jar file", new Object[0]);
        }
        finally {
            if (mcJarFile != null) {
                try {
                    mcJarFile.close();
                }
                catch (IOException ioe) {}
            }
        }
        if (goodMC) return null;
        FMLRelaunchLog.severe("The minecraft jar %s appears to be corrupt! There has been CRITICAL TAMPERING WITH MINECRAFT, it is highly unlikely minecraft will work! STOP NOW, get a clean copy and try again!", codeSource.getLocation().getFile());
        if (!Boolean.parseBoolean(System.getProperty("fml.ignoreInvalidMinecraftCertificates", "false"))) {
            FMLRelaunchLog.severe("For your safety, FML will not launch minecraft. You will need to fetch a clean version of the minecraft jar file", new Object[0]);
            FMLRelaunchLog.severe("Technical information: The class net.minecraft.client.ClientBrandRetriever should have been associated with the minecraft jar file, and should have returned us a valid, intact minecraft jar location. This did not work. Either you have modified the minecraft jar file (if so run the forge installer again), or you are using a base editing jar that is changing this class (and likely others too). If you REALLY want to run minecraft in this configuration, add the flag -Dfml.ignoreInvalidMinecraftCertificates=true to the 'JVM settings' in your launcher profile.", new Object[0]);
            FMLCommonHandler.instance().exitJava(1, false);
            return null;
        } else {
            FMLRelaunchLog.severe("FML has been ordered to ignore the invalid or missing minecraft certificate. This is very likely to cause a problem!", new Object[0]);
            FMLRelaunchLog.severe("Technical information: ClientBrandRetriever was at %s, there were %d certificates for it", codeSource.getLocation(), certCount);
        }
        return null;
    }

    @Override
    public void injectData(Map<String, Object> data) {
        this.liveEnv = (Boolean)data.get("runtimeDeobfuscationEnabled");
        this.cl = (LaunchClassLoader)data.get("classLoader");
        File mcDir = (File)data.get("mcLocation");
        fmlLocation = (File)data.get("coremodLocation");
        ClassPatchManager.INSTANCE.setup(FMLLaunchHandler.side());
        FMLDeobfuscatingRemapper.INSTANCE.setup(mcDir, this.cl, (String)data.get("deobfuscationFileName"));
    }
}

