/*
 * Decompiled with CFR 0.152.
 */
package thermos.thermite;

import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;

public class ThermiteRandom
extends Random {
    private static final long serialVersionUID = 6208727693524452904L;
    private long seed;
    private static final AtomicLong seedUniquifier = new AtomicLong(8682522807148012L);
    private static final double DOUBLE_UNIT = (double)1.110223E-16f;
    boolean haveNextNextGaussian = false;
    double nextNextGaussian = 0.0;

    public ThermiteRandom() {
        this(ThermiteRandom.seedUniquifier() ^ System.nanoTime());
    }

    private static long seedUniquifier() {
        long next;
        long current;
        while (!seedUniquifier.compareAndSet(current = seedUniquifier.get(), next = current * 181783497276652981L)) {
        }
        return next;
    }

    public ThermiteRandom(long seed) {
        this.seed = seed;
    }

    @Override
    public boolean nextBoolean() {
        return this.next(1) != 0;
    }

    @Override
    public double nextDouble() {
        return (double)(((long)this.next(26) << 27) + (long)this.next(27)) * (double)1.110223E-16f;
    }

    public synchronized long getSeed() {
        return this.seed;
    }

    @Override
    public synchronized void setSeed(long seed) {
        this.seed = seed;
    }

    public ThermiteRandom clone() {
        return new ThermiteRandom(this.getSeed());
    }

    @Override
    public int next(int nbits) {
        long x = this.seed;
        x ^= x << 21;
        x ^= x >>> 35;
        x ^= x << 4;
        this.seed = x;
        return (int)(x &= (1L << nbits) - 1L);
    }

    @Override
    public synchronized double nextGaussian() {
        double v2;
        double v1;
        double s;
        if (this.haveNextNextGaussian) {
            this.haveNextNextGaussian = false;
            return this.nextNextGaussian;
        }
        while ((s = (v1 = 2.0 * this.nextDouble() - 1.0) * v1 + (v2 = 2.0 * this.nextDouble() - 1.0) * v2) >= 1.0 || s == 0.0) {
        }
        double multiplier = StrictMath.sqrt(-2.0 * StrictMath.log(s) / s);
        this.nextNextGaussian = v2 * multiplier;
        this.haveNextNextGaussian = true;
        return v1 * multiplier;
    }

    @Override
    public int nextInt(int bound) {
        if (bound <= 0) {
            throw new RuntimeException("BadBound");
        }
        int r2 = this.next(31);
        int m = bound - 1;
        if ((bound & m) == 0) {
            r2 = (int)((long)bound * (long)r2 >> 31);
        } else {
            int u2 = r2;
            while (u2 - (r2 = u2 % bound) + m < 0) {
                u2 = this.next(31);
            }
        }
        return r2;
    }

    @Override
    public int nextInt() {
        return this.next(32);
    }
}

