/*
 * Decompiled with CFR 0.152.
 */
package thermos.updater;

import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerJoinEvent;
import thermos.Thermos;
import thermos.updater.CommandSenderUpdateCallback;
import thermos.updater.TVersionRetriever;

public class DefaultUpdateCallback
implements TVersionRetriever.IVersionCheckCallback {
    public static DefaultUpdateCallback INSTANCE = new DefaultUpdateCallback();
    private boolean mHasUpdate;
    private String mCurrentVersion;
    private String mNewVersion;

    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.hasPermission(player) && this.mHasUpdate) {
            this.sendUpdate(player);
        }
    }

    private boolean hasPermission(CommandSender player) {
        return player.hasPermission("thermos.update") || player.isOp();
    }

    private void sendUpdate(CommandSender player) {
        CommandSenderUpdateCallback.newVersion(player, this.mCurrentVersion, this.mNewVersion);
    }

    private DefaultUpdateCallback() {
    }

    @Override
    public void upToDate() {
        this.mHasUpdate = false;
        this.mCurrentVersion = Thermos.getCurrentVersion();
        this.mNewVersion = null;
    }

    @Override
    public void newVersion(String newVersion) {
        this.mCurrentVersion = Thermos.getCurrentVersion();
        this.mNewVersion = newVersion;
        if (!this.mHasUpdate) {
            Bukkit.getConsoleSender().sendMessage("New version of Thermos available: " + newVersion);
            Bukkit.getConsoleSender().sendMessage("Download at: https://github.com/CyberdyneCC/Thermos/releases");
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!this.hasPermission(player)) continue;
                this.sendUpdate(player);
            }
        }
        this.mHasUpdate = true;
    }

    @Override
    public void error(Throwable t) {
    }
}

