/*
 * Decompiled with CFR 0.152.
 */
package thermos.updater;

import java.io.InputStreamReader;
import java.io.Reader;
import net.minecraft.server.MinecraftServer;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import thermos.TLog;
import thermos.Thermos;
import thermos.updater.DefaultUpdateCallback;

public class TVersionRetriever
implements Runnable,
Thread.UncaughtExceptionHandler {
    private static final boolean DEBUG = false;
    private static final TLog sLogger = TLog.get(TVersionRetriever.class.getSimpleName());
    private static final JSONParser sParser = new JSONParser();
    private static MinecraftServer sServer;
    private final IVersionCheckCallback mCallback;
    private final boolean mLoop;
    private final Thread mThread;
    private final String mGroup;
    private final String mName;
    private final boolean mUpToDateSupport;

    public static void init(MinecraftServer server) {
        sServer = server;
        if (MinecraftServer.thermosConfig.updatecheckerEnable.getValue().booleanValue()) {
            TVersionRetriever.startServer(DefaultUpdateCallback.INSTANCE, true);
        }
    }

    public static void startServer(IVersionCheckCallback callback, boolean loop) {
        new TVersionRetriever(callback, loop, true, Thermos.getGroup(), Thermos.getChannel());
    }

    public TVersionRetriever(IVersionCheckCallback callback, boolean loop, boolean upToDateSupport, String group, String name) {
        if (DEBUG) {
            sLogger.info("Created new version retriever", new Object[0]);
        }
        this.mCallback = callback;
        this.mLoop = loop;
        this.mUpToDateSupport = upToDateSupport;
        this.mGroup = group;
        this.mName = name;
        this.mThread = new Thread(Thermos.sThermosThreadGroup, this, "Thermos version retriever");
        this.mThread.setPriority(1);
        this.mThread.setDaemon(true);
        this.mThread.setUncaughtExceptionHandler(this);
        this.mThread.start();
    }

    @Override
    public void run() {
        while (!this.mThread.isInterrupted()) {
            this.check();
            if (!this.mLoop) break;
            try {
                Thread.sleep(600000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void check() {
        try {
            HttpUriRequest request = RequestBuilder.get().setUri("http://i.tcpr.ca/thermos/version").addParameter("version", Thermos.getCurrentVersion()).build();
            CloseableHttpResponse response = HttpClientBuilder.create().setUserAgent("Thermos Version Retriever").setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build().execute(request);
            if (response.getStatusLine().getStatusCode() != 200) {
                this.uncaughtException(this.mThread, new IllegalStateException("Status code isn't OK"));
                return;
            }
            JSONObject json = (JSONObject)sParser.parse((Reader)new InputStreamReader(response.getEntity().getContent()));
            String version = (String)json.get((Object)"version");
            if (!this.mUpToDateSupport || Thermos.getCurrentVersion() == null || !version.equals(Thermos.getCurrentVersion())) {
                this.mCallback.newVersion(version);
            } else {
                this.mCallback.upToDate();
            }
        }
        catch (Exception e) {
            this.uncaughtException(null, e);
        }
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        sLogger.warning(e, "Error occured during retriving version", new Object[0]);
        if (this.mCallback != null) {
            this.mCallback.error(e);
        }
    }

    public static interface IVersionCheckCallback {
        public void upToDate();

        public void newVersion(String var1);

        public void error(Throwable var1);
    }
}

