/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.base;

import com.teammetallurgy.atum.blocks.base.tileentity.ChestBaseTileEntity;
import com.teammetallurgy.atum.init.AtumBlocks;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class ChestBaseBlock
extends ChestBlock {
    protected ChestBaseBlock(Supplier<TileEntityType<? extends ChestTileEntity>> tileEntitySupplier) {
        super(Block.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151658_d).func_200948_a(3.0f, 10.0f).func_200947_a(SoundType.field_185851_d).harvestTool(ToolType.PICKAXE).harvestLevel(0), tileEntitySupplier);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)AtumBlocks.LIMESTONE_CHEST);
    }

    public void func_176208_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull PlayerEntity player) {
        super.func_176208_a(world, pos, state, player);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (player.func_184812_l_() && tileEntity instanceof ChestBaseTileEntity) {
            this.func_180657_a(world, player, pos, state, tileEntity, player.func_184614_ca());
        }
    }

    public void func_180657_a(@Nonnull World world, PlayerEntity player, @Nonnull BlockPos pos, @Nonnull BlockState state, TileEntity tileEntity, @Nonnull ItemStack stack) {
        if (!player.func_184812_l_()) {
            super.func_180657_a(world, player, pos, state, tileEntity, stack);
        }
        world.func_217377_a(pos, false);
        if (tileEntity instanceof ChestBaseTileEntity) {
            ChestBaseTileEntity chestBase = (ChestBaseTileEntity)tileEntity;
            if (chestBase.canBeDouble && !chestBase.canBeSingle) {
                for (int i = 0; i < 4; ++i) {
                    Direction direction = (Direction)state.func_177229_b((IProperty)field_176459_a);
                    ChestType type = (ChestType)state.func_177229_b((IProperty)field_196314_b);
                    if (type == ChestType.LEFT) {
                        direction = direction.func_176746_e();
                    } else if (type == ChestType.RIGHT) {
                        direction = direction.func_176735_f();
                    }
                    BlockPos offsetPos = pos.func_177972_a(direction);
                    if (world.func_180495_p(offsetPos).func_177230_c() != this) continue;
                    this.breakDoubleChest(world, offsetPos);
                }
            }
            chestBase.func_145843_s();
        }
    }

    private void breakDoubleChest(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof ChestBaseTileEntity) {
            ChestBaseTileEntity chestBase = (ChestBaseTileEntity)tileEntity;
            if (!chestBase.func_191420_l()) {
                InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)chestBase);
            }
            world.func_175666_e(pos, (Block)this);
        }
        world.func_217377_a(pos, false);
    }

    @Nonnull
    public BlockState func_196271_a(@Nonnull BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull IWorld world, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        TileEntity tileEntity = world.func_175625_s(currentPos);
        if (tileEntity instanceof ChestBaseTileEntity) {
            ChestBaseTileEntity chest = (ChestBaseTileEntity)tileEntity;
            if (chest.canBeSingle && !chest.canBeDouble) {
                return state;
            }
            return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
        }
        return state;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        TileEntity tileEntity;
        Block block = Block.func_149634_a((Item)context.func_195996_i().func_77973_b());
        if (block instanceof ChestBaseBlock && block.func_149716_u() && (tileEntity = this.func_196283_a_((IBlockReader)context.func_195991_k())) instanceof ChestBaseTileEntity && !((ChestBaseTileEntity)tileEntity).canBeDouble) {
            return (BlockState)super.func_196258_a(context).func_206870_a((IProperty)field_196314_b, (Comparable)ChestType.SINGLE);
        }
        return super.func_196258_a(context);
    }

    public void func_180633_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull LivingEntity placer, @Nonnull ItemStack stack) {
        TileEntity tileEntity;
        super.func_180633_a(world, pos, state, placer, stack);
        if (placer instanceof PlayerEntity && (tileEntity = world.func_175625_s(pos)) instanceof ChestBaseTileEntity) {
            ChestBaseTileEntity chest = (ChestBaseTileEntity)tileEntity;
            if (chest.canBeDouble && !chest.canBeSingle) {
                Direction direction = Direction.func_176731_b((int)(MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3)).func_176734_d();
                BlockPos posRight = pos.func_177972_a(direction.func_176746_e().func_176734_d());
                BlockState rightState = world.func_180495_p(posRight);
                BlockRayTraceResult rayTrace = new BlockRayTraceResult(new Vec3d((double)posRight.func_177958_n(), (double)posRight.func_177956_o(), (double)posRight.func_177952_p()), direction, pos, false);
                BlockItemUseContext context = new BlockItemUseContext(new ItemUseContext((PlayerEntity)placer, Hand.MAIN_HAND, rayTrace));
                if (rightState.isAir((IBlockReader)world, posRight) || rightState.func_196953_a(context)) {
                    placer.field_70170_p.func_175656_a(posRight, (BlockState)state.func_206870_a((IProperty)field_196314_b, (Comparable)ChestType.LEFT));
                }
            }
        }
    }

    public static BlockState correctFacing(IBlockReader world, BlockPos pos, BlockState state, Block checkBlock) {
        Direction direction = null;
        for (Direction horizontal : Direction.Plane.HORIZONTAL) {
            BlockPos horizontalPos = pos.func_177972_a(horizontal);
            BlockState horizontalState = world.func_180495_p(horizontalPos);
            if (horizontalState.func_177230_c() == checkBlock) {
                return state;
            }
            if (!horizontalState.func_200015_d(world, horizontalPos)) continue;
            if (direction != null) {
                direction = null;
                break;
            }
            direction = horizontal;
        }
        if (direction != null) {
            return (BlockState)state.func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)direction.func_176734_d());
        }
        Direction facing = (Direction)state.func_177229_b((IProperty)HorizontalBlock.field_185512_D);
        BlockPos facingPos = pos.func_177972_a(facing);
        if (world.func_180495_p(facingPos).func_200015_d(world, facingPos)) {
            facing = facing.func_176734_d();
            facingPos = pos.func_177972_a(facing);
        }
        if (world.func_180495_p(facingPos).func_200015_d(world, facingPos)) {
            facing = facing.func_176746_e();
            facingPos = pos.func_177972_a(facing);
        }
        if (world.func_180495_p(facingPos).func_200015_d(world, facingPos)) {
            facing = facing.func_176734_d();
            pos.func_177972_a(facing);
        }
        return (BlockState)state.func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)facing);
    }
}

