/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.stone.limestone.chest;

import com.teammetallurgy.atum.blocks.base.ChestBaseBlock;
import com.teammetallurgy.atum.blocks.stone.limestone.chest.tileentity.SarcophagusTileEntity;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumTileEntities;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="atum")
public class SarcophagusBlock
extends ChestBaseBlock {
    public SarcophagusBlock() {
        super(() -> AtumTileEntities.SARCOPHAGUS);
    }

    public TileEntity func_196283_a_(@Nonnull IBlockReader reader) {
        return new SarcophagusTileEntity();
    }

    public float func_176195_g(@Nonnull BlockState state, IBlockReader world, @Nonnull BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof SarcophagusTileEntity && !((SarcophagusTileEntity)tileEntity).isOpenable) {
            return -1.0f;
        }
        return 4.0f;
    }

    public float getExplosionResistance(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof SarcophagusTileEntity && !((SarcophagusTileEntity)tileEntity).isOpenable) {
            return 6000000.0f;
        }
        return super.getExplosionResistance(state, world, pos, exploder, explosion);
    }

    @Nonnull
    public ActionResultType func_225533_a_(BlockState state, World world, @Nonnull BlockPos pos, @Nonnull PlayerEntity player, @Nonnull Hand hand, @Nonnull BlockRayTraceResult hit) {
        SarcophagusTileEntity sarcophagus;
        TileEntity tileEntity = world.func_175625_s(pos);
        Direction facing = (Direction)state.func_177229_b((IProperty)field_176459_a);
        BlockPos posLeft = pos.func_177972_a(facing.func_176746_e());
        TileEntity tileLeft = world.func_175625_s(posLeft);
        if (world.func_180495_p(posLeft).func_177230_c() == this && tileLeft instanceof SarcophagusTileEntity) {
            sarcophagus = (SarcophagusTileEntity)tileLeft;
            if (!sarcophagus.hasSpawned) {
                this.func_225533_a_(state, world, pos.func_177972_a(facing.func_176746_e()), player, hand, hit);
                return ActionResultType.PASS;
            }
        }
        if (tileEntity instanceof SarcophagusTileEntity) {
            sarcophagus = (SarcophagusTileEntity)tileEntity;
            if (!sarcophagus.hasSpawned) {
                if (this.canSpawnPharaoh(world, pos, facing)) {
                    for (Direction horizontal : Direction.Plane.HORIZONTAL) {
                        TileEntity tileEntityOffset = world.func_175625_s(pos.func_177972_a(horizontal));
                        if (!(tileEntityOffset instanceof SarcophagusTileEntity)) continue;
                        ((SarcophagusTileEntity)tileEntityOffset).hasSpawned = true;
                    }
                    sarcophagus.spawn(player, world.func_175649_E(pos));
                    sarcophagus.hasSpawned = true;
                    return ActionResultType.PASS;
                }
                if (!sarcophagus.isOpenable) {
                    player.func_146105_b(new TranslationTextComponent("chat.atum.cannot_spawn_pharaoh", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), true);
                    world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187945_hs, SoundCategory.HOSTILE, 0.7f, 0.4f, false);
                    return ActionResultType.PASS;
                }
            }
        }
        return super.func_225533_a_(state, world, pos, player, hand, hit);
    }

    private boolean canSpawnPharaoh(World world, BlockPos pos, Direction facing) {
        boolean isTopLeftCorner = world.func_180495_p(pos.func_177967_a(facing.func_176746_e(), 2).func_177967_a(facing.func_176734_d(), 1)).func_177230_c() == AtumBlocks.PHARAOH_TORCH;
        boolean isBottomLeftCorner = world.func_180495_p(pos.func_177967_a(facing.func_176746_e(), 2).func_177967_a(facing, 2)).func_177230_c() == AtumBlocks.PHARAOH_TORCH;
        boolean isTopRightCorner = world.func_180495_p(pos.func_177967_a(facing.func_176735_f(), 3).func_177967_a(facing.func_176734_d(), 1)).func_177230_c() == AtumBlocks.PHARAOH_TORCH;
        boolean isBottomRightCorner = world.func_180495_p(pos.func_177967_a(facing.func_176735_f(), 3).func_177967_a(facing, 2)).func_177230_c() == AtumBlocks.PHARAOH_TORCH;
        return isTopLeftCorner && isBottomLeftCorner && isTopRightCorner && isBottomRightCorner;
    }

    @Override
    public void func_180633_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull LivingEntity placer, @Nonnull ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof SarcophagusTileEntity) {
            SarcophagusTileEntity sarcophagus = (SarcophagusTileEntity)tileEntity;
            sarcophagus.hasSpawned = true;
            sarcophagus.setOpenable();
            sarcophagus.func_145836_u();
            for (Direction horizontal : Direction.Plane.HORIZONTAL) {
                TileEntity tileEntityOffset = world.func_175625_s(pos.func_177972_a(horizontal));
                if (!(tileEntityOffset instanceof SarcophagusTileEntity)) continue;
                ((SarcophagusTileEntity)tileEntityOffset).hasSpawned = true;
                ((SarcophagusTileEntity)tileEntityOffset).setOpenable();
                tileEntityOffset.func_145836_u();
            }
        }
    }

    @SubscribeEvent
    public static void onPlaced(BlockEvent.EntityPlaceEvent event) {
        BlockState placedState = event.getPlacedBlock();
        if (placedState.func_177230_c() instanceof SarcophagusBlock && !SarcophagusBlock.canPlaceRightSac(event.getWorld(), event.getPos(), (Direction)placedState.func_177229_b((IProperty)field_176459_a))) {
            event.setCanceled(true);
        }
    }

    private static boolean canPlaceRightSac(IWorld world, BlockPos pos, Direction facing) {
        BlockPos posOffset = pos.func_177972_a(facing.func_176735_f());
        BlockState offsetState = world.func_180495_p(posOffset);
        if (offsetState.func_177230_c() instanceof SarcophagusBlock) {
            return offsetState.func_177229_b((IProperty)field_196314_b) == ChestType.LEFT && offsetState.func_177229_b((IProperty)field_176459_a) == facing;
        }
        return false;
    }

    @Override
    @Nonnull
    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)AtumBlocks.SARCOPHAGUS);
    }
}

